/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.DependencyVersionSelector;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.search.FindGradleProject;
import org.openrewrite.gradle.trait.GradleDependency;
import org.openrewrite.gradle.util.ChangeStringLiteral;
import org.openrewrite.gradle.util.Dependency;
import org.openrewrite.gradle.util.DependencyStringNotationConverter;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.semver.DependencyMatcher;
import org.openrewrite.semver.Semver;

public final class ChangeDependency
extends Recipe {
    @Option(displayName="Old groupId", description="The old groupId to replace. The groupId is the first part of a dependency coordinate 'com.google.guava:guava:VERSION'. Supports glob expressions.", example="org.openrewrite.recipe")
    private final String oldGroupId;
    @Option(displayName="Old artifactId", description="The old artifactId to replace. The artifactId is the second part of a dependency coordinate 'com.google.guava:guava:VERSION'. Supports glob expressions.", example="rewrite-testing-frameworks")
    private final String oldArtifactId;
    @Option(displayName="New groupId", description="The new groupId to use. Defaults to the existing group id.", example="corp.internal.openrewrite.recipe", required=false)
    private final @Nullable String newGroupId;
    @Option(displayName="New artifactId", description="The new artifactId to use. Defaults to the existing artifact id.", example="rewrite-testing-frameworks", required=false)
    private final @Nullable String newArtifactId;
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number. You can also use `latest.release` for the latest available version and `latest.patch` if the current version is a valid semantic version. For more details, you can look at the documentation page of [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors).", example="29.X", required=false)
    private final @Nullable String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    private final @Nullable String versionPattern;
    @Option(displayName="Override managed version", description="If the old dependency has a managed version, this flag can be used to explicitly set the version on the new dependency. WARNING: No check is done on the NEW dependency to verify if it is managed, it relies on whether the OLD dependency had a managed version. The default for this flag is `false`.", required=false)
    private final @Nullable Boolean overrideManagedVersion;

    @Deprecated
    public ChangeDependency(String oldGroupId, String oldArtifactId, @Nullable String newGroupId, @Nullable String newArtifactId, @Nullable String newVersion, @Nullable String versionPattern) {
        this(oldGroupId, oldArtifactId, newGroupId, newArtifactId, newVersion, versionPattern, null);
    }

    @JsonCreator
    public ChangeDependency(String oldGroupId, String oldArtifactId, @Nullable String newGroupId, @Nullable String newArtifactId, @Nullable String newVersion, @Nullable String versionPattern, @Nullable Boolean overrideManagedVersion) {
        this.oldGroupId = oldGroupId;
        this.oldArtifactId = oldArtifactId;
        this.newGroupId = newGroupId;
        this.newArtifactId = newArtifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
        this.overrideManagedVersion = overrideManagedVersion;
    }

    public String getDisplayName() {
        return "Change Gradle dependency";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s`", this.oldGroupId, this.oldArtifactId);
    }

    public String getDescription() {
        return "Change a Gradle dependency coordinates. The `newGroupId` or `newArtifactId` **MUST** be different from before.";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        validated = validated.and(Validated.required((String)"newGroupId", (Object)this.newGroupId).or(Validated.required((String)"newArtifactId", (Object)this.newArtifactId)));
        validated = validated.and(Validated.test((String)"coordinates", (String)"newGroupId OR newArtifactId must be different from before", (Object)((Object)this), r -> {
            boolean sameGroupId = StringUtils.isBlank((String)r.newGroupId) || Objects.equals(r.oldGroupId, r.newGroupId);
            boolean sameArtifactId = StringUtils.isBlank((String)r.newArtifactId) || Objects.equals(r.oldArtifactId, r.newArtifactId);
            return !sameGroupId || !sameArtifactId;
        }));
        return validated;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new FindGradleProject(FindGradleProject.SearchCriteria.Marker).getVisitor(), (TreeVisitor)new GroovyIsoVisitor<ExecutionContext>(){
            final DependencyMatcher depMatcher;
            GradleProject gradleProject;
            {
                this.depMatcher = Objects.requireNonNull((DependencyMatcher)DependencyMatcher.build((String)(ChangeDependency.this.oldGroupId + ":" + ChangeDependency.this.oldArtifactId)).getValue());
            }

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                Optional maybeGp = cu.getMarkers().findFirst(GradleProject.class);
                if (!maybeGp.isPresent()) {
                    return cu;
                }
                this.gradleProject = (GradleProject)maybeGp.get();
                G.CompilationUnit g = super.visitCompilationUnit(cu, (Object)ctx);
                if (g != cu) {
                    g = g.withMarkers(g.getMarkers().setByType((Marker)this.updateGradleModel(this.gradleProject)));
                }
                return g;
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                GradleDependency.Matcher gradleDependencyMatcher = new GradleDependency.Matcher();
                if (!gradleDependencyMatcher.get(this.getCursor()).isPresent()) {
                    return m;
                }
                List depArgs = m.getArguments();
                if (depArgs.get(0) instanceof J.Literal || depArgs.get(0) instanceof G.GString || depArgs.get(0) instanceof G.MapEntry) {
                    m = this.updateDependency(m, ctx);
                } else if (depArgs.get(0) instanceof J.MethodInvocation && (((J.MethodInvocation)depArgs.get(0)).getSimpleName().equals("platform") || ((J.MethodInvocation)depArgs.get(0)).getSimpleName().equals("enforcedPlatform"))) {
                    m = m.withArguments(ListUtils.mapFirst((List)depArgs, platform -> this.updateDependency((J.MethodInvocation)platform, ctx)));
                }
                return m;
            }

            private J.MethodInvocation updateDependency(J.MethodInvocation m, ExecutionContext ctx) {
                List depArgs = m.getArguments();
                if (depArgs.get(0) instanceof J.Literal) {
                    Dependency original;
                    String gav = (String)((J.Literal)depArgs.get(0)).getValue();
                    if (gav != null && (original = DependencyStringNotationConverter.parse(gav)) != null && this.depMatcher.matches(original.getGroupId(), original.getArtifactId())) {
                        Dependency updated = original;
                        if (!StringUtils.isBlank((String)ChangeDependency.this.newGroupId) && !updated.getGroupId().equals(ChangeDependency.this.newGroupId)) {
                            updated = updated.withGroupId(ChangeDependency.this.newGroupId);
                        }
                        if (!StringUtils.isBlank((String)ChangeDependency.this.newArtifactId) && !updated.getArtifactId().equals(ChangeDependency.this.newArtifactId)) {
                            updated = updated.withArtifactId(ChangeDependency.this.newArtifactId);
                        }
                        if (!(StringUtils.isBlank((String)ChangeDependency.this.newVersion) || StringUtils.isBlank((String)original.getVersion()) && !Boolean.TRUE.equals(ChangeDependency.this.overrideManagedVersion))) {
                            String resolvedVersion;
                            try {
                                resolvedVersion = new DependencyVersionSelector(null, this.gradleProject, null).select(new GroupArtifact(updated.getGroupId(), updated.getArtifactId()), m.getSimpleName(), ChangeDependency.this.newVersion, ChangeDependency.this.versionPattern, ctx);
                            }
                            catch (MavenDownloadingException e) {
                                return (J.MethodInvocation)e.warn((Tree)m);
                            }
                            if (resolvedVersion != null && !resolvedVersion.equals(updated.getVersion())) {
                                updated = updated.withVersion(resolvedVersion);
                            }
                        }
                        if (original != updated) {
                            String replacement = updated.toStringNotation();
                            m = m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> ChangeStringLiteral.withStringValue((J.Literal)arg, replacement)));
                        }
                    }
                } else if (m.getArguments().get(0) instanceof G.GString) {
                    J.Literal literal;
                    Dependency original;
                    G.GString gstring = (G.GString)depArgs.get(0);
                    List strings = gstring.getStrings();
                    if (strings.size() >= 2 && strings.get(0) instanceof J.Literal && ((J.Literal)strings.get(0)).getValue() != null && (original = DependencyStringNotationConverter.parse((String)Objects.requireNonNull((literal = (J.Literal)strings.get(0)).getValue()))) != null && this.depMatcher.matches(original.getGroupId(), original.getArtifactId())) {
                        Dependency updated = original;
                        if (!StringUtils.isBlank((String)ChangeDependency.this.newGroupId) && !updated.getGroupId().equals(ChangeDependency.this.newGroupId)) {
                            updated = updated.withGroupId(ChangeDependency.this.newGroupId);
                        }
                        if (!StringUtils.isBlank((String)ChangeDependency.this.newArtifactId) && !updated.getArtifactId().equals(ChangeDependency.this.newArtifactId)) {
                            updated = updated.withArtifactId(ChangeDependency.this.newArtifactId);
                        }
                        if (!StringUtils.isBlank((String)ChangeDependency.this.newVersion)) {
                            String resolvedVersion;
                            try {
                                resolvedVersion = new DependencyVersionSelector(null, this.gradleProject, null).select(new GroupArtifact(updated.getGroupId(), updated.getArtifactId()), m.getSimpleName(), ChangeDependency.this.newVersion, ChangeDependency.this.versionPattern, ctx);
                            }
                            catch (MavenDownloadingException e) {
                                return (J.MethodInvocation)e.warn((Tree)m);
                            }
                            if (resolvedVersion != null && !resolvedVersion.equals(updated.getVersion())) {
                                updated = updated.withVersion(resolvedVersion);
                            }
                        }
                        if (original != updated) {
                            String replacement = updated.toStringNotation();
                            J.Literal newLiteral = literal.withValue((Object)replacement).withValueSource(gstring.getDelimiter() + replacement + gstring.getDelimiter());
                            m = m.withArguments(Collections.singletonList(newLiteral));
                        }
                    }
                } else if (m.getArguments().get(0) instanceof G.MapEntry) {
                    G.MapEntry groupEntry = null;
                    G.MapEntry artifactEntry = null;
                    G.MapEntry versionEntry = null;
                    String groupId = null;
                    String artifactId = null;
                    String version = null;
                    for (Expression e : depArgs) {
                        G.MapEntry arg2;
                        if (!(e instanceof G.MapEntry) || !((arg2 = (G.MapEntry)e).getKey() instanceof J.Literal) || !(arg2.getValue() instanceof J.Literal)) continue;
                        J.Literal key = (J.Literal)arg2.getKey();
                        J.Literal value = (J.Literal)arg2.getValue();
                        if (!(key.getValue() instanceof String) || !(value.getValue() instanceof String)) continue;
                        String keyValue = (String)key.getValue();
                        String valueValue = (String)value.getValue();
                        switch (keyValue) {
                            case "group": {
                                groupEntry = arg2;
                                groupId = valueValue;
                                break;
                            }
                            case "name": {
                                artifactEntry = arg2;
                                artifactId = valueValue;
                                break;
                            }
                            case "version": {
                                versionEntry = arg2;
                                version = valueValue;
                            }
                        }
                    }
                    if (groupId == null || artifactId == null) {
                        return m;
                    }
                    if (!this.depMatcher.matches(groupId, artifactId)) {
                        return m;
                    }
                    String updatedGroupId = groupId;
                    if (!StringUtils.isBlank((String)ChangeDependency.this.newGroupId) && !updatedGroupId.equals(ChangeDependency.this.newGroupId)) {
                        updatedGroupId = ChangeDependency.this.newGroupId;
                    }
                    String updatedArtifactId = artifactId;
                    if (!StringUtils.isBlank((String)ChangeDependency.this.newArtifactId) && !updatedArtifactId.equals(ChangeDependency.this.newArtifactId)) {
                        updatedArtifactId = ChangeDependency.this.newArtifactId;
                    }
                    String updatedVersion = version;
                    if (!(StringUtils.isBlank((String)ChangeDependency.this.newVersion) || StringUtils.isBlank(version) && !Boolean.TRUE.equals(ChangeDependency.this.overrideManagedVersion))) {
                        String resolvedVersion;
                        try {
                            resolvedVersion = new DependencyVersionSelector(null, this.gradleProject, null).select(new GroupArtifact(updatedGroupId, updatedArtifactId), m.getSimpleName(), ChangeDependency.this.newVersion, ChangeDependency.this.versionPattern, ctx);
                        }
                        catch (MavenDownloadingException e) {
                            return (J.MethodInvocation)e.warn((Tree)m);
                        }
                        if (resolvedVersion != null && !resolvedVersion.equals(updatedVersion)) {
                            updatedVersion = resolvedVersion;
                        }
                    }
                    if (!updatedGroupId.equals(groupId) || !updatedArtifactId.equals(artifactId) || updatedVersion != null && !updatedVersion.equals(version)) {
                        G.MapEntry finalGroup = groupEntry;
                        String finalGroupIdValue = updatedGroupId;
                        G.MapEntry finalArtifact = artifactEntry;
                        String finalArtifactIdValue = updatedArtifactId;
                        G.MapEntry finalVersion = versionEntry;
                        String finalVersionValue = updatedVersion;
                        m = m.withArguments(ListUtils.map((List)m.getArguments(), arg -> {
                            if (arg == finalGroup) {
                                return finalGroup.withValue((Expression)ChangeStringLiteral.withStringValue((J.Literal)finalGroup.getValue(), finalGroupIdValue));
                            }
                            if (arg == finalArtifact) {
                                return finalArtifact.withValue((Expression)ChangeStringLiteral.withStringValue((J.Literal)finalArtifact.getValue(), finalArtifactIdValue));
                            }
                            if (arg == finalVersion) {
                                return finalVersion.withValue((Expression)ChangeStringLiteral.withStringValue((J.Literal)finalVersion.getValue(), finalVersionValue));
                            }
                            return arg;
                        }));
                    }
                }
                return m;
            }

            private GradleProject updateGradleModel(GradleProject gp) {
                Map<String, GradleDependencyConfiguration> nameToConfiguration = gp.getNameToConfiguration();
                HashMap<String, GradleDependencyConfiguration> newNameToConfiguration = new HashMap<String, GradleDependencyConfiguration>(nameToConfiguration.size());
                boolean anyChanged = false;
                Iterator<GradleDependencyConfiguration> iterator = nameToConfiguration.values().iterator();
                while (iterator.hasNext()) {
                    GradleDependencyConfiguration gdc;
                    GradleDependencyConfiguration newGdc = gdc = iterator.next();
                    newGdc = newGdc.withRequested(ListUtils.map(gdc.getRequested(), requested -> {
                        if (this.depMatcher.matches(requested.getGroupId(), requested.getArtifactId())) {
                            GroupArtifactVersion gav = requested.getGav();
                            if (ChangeDependency.this.newGroupId != null) {
                                gav = gav.withGroupId(ChangeDependency.this.newGroupId);
                            }
                            if (ChangeDependency.this.newArtifactId != null) {
                                gav = gav.withArtifactId(ChangeDependency.this.newArtifactId);
                            }
                            if (gav != requested.getGav()) {
                                return requested.withGav(gav);
                            }
                        }
                        return requested;
                    }));
                    anyChanged |= (newGdc = newGdc.withDirectResolved(ListUtils.map(gdc.getDirectResolved(), resolved -> {
                        if (this.depMatcher.matches(resolved.getGroupId(), resolved.getArtifactId())) {
                            ResolvedGroupArtifactVersion gav = resolved.getGav();
                            if (ChangeDependency.this.newGroupId != null) {
                                gav = gav.withGroupId(ChangeDependency.this.newGroupId);
                            }
                            if (ChangeDependency.this.newArtifactId != null) {
                                gav = gav.withArtifactId(ChangeDependency.this.newArtifactId);
                            }
                            if (gav != resolved.getGav()) {
                                return resolved.withGav(gav);
                            }
                        }
                        return resolved;
                    }))) != gdc;
                    newNameToConfiguration.put(newGdc.getName(), newGdc);
                }
                if (anyChanged) {
                    gp = gp.withNameToConfiguration(newNameToConfiguration);
                }
                return gp;
            }
        });
    }

    @Generated
    public String getOldGroupId() {
        return this.oldGroupId;
    }

    @Generated
    public String getOldArtifactId() {
        return this.oldArtifactId;
    }

    @Generated
    public @Nullable String getNewGroupId() {
        return this.newGroupId;
    }

    @Generated
    public @Nullable String getNewArtifactId() {
        return this.newArtifactId;
    }

    @Generated
    public @Nullable String getNewVersion() {
        return this.newVersion;
    }

    @Generated
    public @Nullable String getVersionPattern() {
        return this.versionPattern;
    }

    @Generated
    public @Nullable Boolean getOverrideManagedVersion() {
        return this.overrideManagedVersion;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeDependency(oldGroupId=" + this.getOldGroupId() + ", oldArtifactId=" + this.getOldArtifactId() + ", newGroupId=" + this.getNewGroupId() + ", newArtifactId=" + this.getNewArtifactId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ", overrideManagedVersion=" + this.getOverrideManagedVersion() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeDependency)) {
            return false;
        }
        ChangeDependency other = (ChangeDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$overrideManagedVersion = this.getOverrideManagedVersion();
        Boolean other$overrideManagedVersion = other.getOverrideManagedVersion();
        if (this$overrideManagedVersion == null ? other$overrideManagedVersion != null : !((Object)this$overrideManagedVersion).equals(other$overrideManagedVersion)) {
            return false;
        }
        String this$oldGroupId = this.getOldGroupId();
        String other$oldGroupId = other.getOldGroupId();
        if (this$oldGroupId == null ? other$oldGroupId != null : !this$oldGroupId.equals(other$oldGroupId)) {
            return false;
        }
        String this$oldArtifactId = this.getOldArtifactId();
        String other$oldArtifactId = other.getOldArtifactId();
        if (this$oldArtifactId == null ? other$oldArtifactId != null : !this$oldArtifactId.equals(other$oldArtifactId)) {
            return false;
        }
        String this$newGroupId = this.getNewGroupId();
        String other$newGroupId = other.getNewGroupId();
        if (this$newGroupId == null ? other$newGroupId != null : !this$newGroupId.equals(other$newGroupId)) {
            return false;
        }
        String this$newArtifactId = this.getNewArtifactId();
        String other$newArtifactId = other.getNewArtifactId();
        if (this$newArtifactId == null ? other$newArtifactId != null : !this$newArtifactId.equals(other$newArtifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangeDependency;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $overrideManagedVersion = this.getOverrideManagedVersion();
        result = result * 59 + ($overrideManagedVersion == null ? 43 : ((Object)$overrideManagedVersion).hashCode());
        String $oldGroupId = this.getOldGroupId();
        result = result * 59 + ($oldGroupId == null ? 43 : $oldGroupId.hashCode());
        String $oldArtifactId = this.getOldArtifactId();
        result = result * 59 + ($oldArtifactId == null ? 43 : $oldArtifactId.hashCode());
        String $newGroupId = this.getNewGroupId();
        result = result * 59 + ($newGroupId == null ? 43 : $newGroupId.hashCode());
        String $newArtifactId = this.getNewArtifactId();
        result = result * 59 + ($newArtifactId == null ? 43 : $newArtifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }
}

