/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.marker.GradleSettings;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.semver.ExactVersion;
import org.openrewrite.semver.LatestPatch;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

@Incubating(since="8.17.0")
public final class DependencyVersionSelector {
    @Nullable
    private final MavenMetadataFailures metadataFailures;
    @Nullable
    private final GradleProject gradleProject;
    @Nullable
    private final GradleSettings gradleSettings;

    @Nullable
    public String select(GroupArtifact ga, String configuration, @Nullable String version, @Nullable String versionPattern, ExecutionContext ctx) throws MavenDownloadingException {
        return this.select(new GroupArtifactVersion(ga.getGroupId(), ga.getArtifactId(), "0"), configuration, "latest.patch".equalsIgnoreCase(version) ? "latest.release" : version, versionPattern, ctx);
    }

    @Nullable
    public String select(ResolvedGroupArtifactVersion gav, String configuration, @Nullable String version, @Nullable String versionPattern, ExecutionContext ctx) throws MavenDownloadingException {
        return this.select(new GroupArtifactVersion(gav.getGroupId(), gav.getArtifactId(), gav.getVersion()), configuration, version, versionPattern, ctx);
    }

    @Nullable
    public String select(GroupArtifactVersion gav, @Nullable String configuration, @Nullable String version, @Nullable String versionPattern, ExecutionContext ctx) throws MavenDownloadingException {
        LatestRelease versionComparator;
        if (gav.getVersion() == null) {
            throw new IllegalArgumentException("Version must be specified. Call the select method that accepts a GroupArtifact instead if there is no current version.");
        }
        Object object = versionComparator = StringUtils.isBlank((String)version) ? new LatestRelease(versionPattern) : Objects.requireNonNull((VersionComparator)Semver.validate((String)version, (String)versionPattern).getValue());
        if (versionComparator instanceof ExactVersion) {
            return versionComparator.upgrade(gav.getVersion(), Collections.singletonList(version)).orElse(null);
        }
        if (versionComparator instanceof LatestPatch && !versionComparator.isValid(gav.getVersion(), gav.getVersion())) {
            return null;
        }
        return this.findNewerVersion(gav, configuration, (VersionComparator)versionComparator, ctx).orElse(null);
    }

    private Optional<String> findNewerVersion(GroupArtifactVersion gav, @Nullable String configuration, VersionComparator versionComparator, ExecutionContext ctx) throws MavenDownloadingException {
        try {
            if (gav.getGroupId() == null) {
                return Optional.empty();
            }
            List<MavenRepository> repos = this.determineRepos(configuration);
            MavenMetadata mavenMetadata = this.metadataFailures == null ? this.downloadMetadata(gav.getGroupId(), gav.getArtifactId(), repos, ctx) : this.metadataFailures.insertRows(ctx, () -> this.downloadMetadata(gav.getGroupId(), gav.getArtifactId(), repos, ctx));
            return versionComparator.upgrade(Objects.requireNonNull(gav.getVersion()), (Collection)mavenMetadata.getVersioning().getVersions());
        }
        catch (IllegalStateException e) {
            return Optional.empty();
        }
    }

    private MavenMetadata downloadMetadata(String groupId, String artifactId, List<MavenRepository> repositories, ExecutionContext ctx) throws MavenDownloadingException {
        return new MavenPomDownloader(ctx).downloadMetadata(new GroupArtifact(groupId, artifactId), null, repositories);
    }

    private List<MavenRepository> determineRepos(@Nullable String configuration) {
        if (this.gradleSettings != null) {
            return this.gradleSettings.getPluginRepositories();
        }
        Objects.requireNonNull(this.gradleProject);
        return "classpath".equals(configuration) ? this.gradleProject.getMavenPluginRepositories() : this.gradleProject.getMavenRepositories();
    }

    public DependencyVersionSelector(@Nullable MavenMetadataFailures metadataFailures, @Nullable GradleProject gradleProject, @Nullable GradleSettings gradleSettings) {
        this.metadataFailures = metadataFailures;
        this.gradleProject = gradleProject;
        this.gradleSettings = gradleSettings;
    }

    @Nullable
    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    @Nullable
    public GradleProject getGradleProject() {
        return this.gradleProject;
    }

    @Nullable
    public GradleSettings getGradleSettings() {
        return this.gradleSettings;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependencyVersionSelector)) {
            return false;
        }
        DependencyVersionSelector other = (DependencyVersionSelector)o;
        MavenMetadataFailures this$metadataFailures = this.getMetadataFailures();
        MavenMetadataFailures other$metadataFailures = other.getMetadataFailures();
        if (this$metadataFailures == null ? other$metadataFailures != null : !this$metadataFailures.equals(other$metadataFailures)) {
            return false;
        }
        GradleProject this$gradleProject = this.getGradleProject();
        GradleProject other$gradleProject = other.getGradleProject();
        if (this$gradleProject == null ? other$gradleProject != null : !((Object)this$gradleProject).equals(other$gradleProject)) {
            return false;
        }
        GradleSettings this$gradleSettings = this.getGradleSettings();
        GradleSettings other$gradleSettings = other.getGradleSettings();
        return !(this$gradleSettings == null ? other$gradleSettings != null : !((Object)this$gradleSettings).equals(other$gradleSettings));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MavenMetadataFailures $metadataFailures = this.getMetadataFailures();
        result = result * 59 + ($metadataFailures == null ? 43 : $metadataFailures.hashCode());
        GradleProject $gradleProject = this.getGradleProject();
        result = result * 59 + ($gradleProject == null ? 43 : ((Object)$gradleProject).hashCode());
        GradleSettings $gradleSettings = this.getGradleSettings();
        result = result * 59 + ($gradleSettings == null ? 43 : ((Object)$gradleSettings).hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "DependencyVersionSelector(metadataFailures=" + this.getMetadataFailures() + ", gradleProject=" + this.getGradleProject() + ", gradleSettings=" + this.getGradleSettings() + ")";
    }
}

