/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.util;

import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.tree.GroupArtifactVersion;

public final class Dependency {
    private final String groupId;
    private final String artifactId;
    @Nullable
    private final String version;
    @Nullable
    private final String classifier;
    @Nullable
    private final String ext;

    public GroupArtifactVersion getGav() {
        return new GroupArtifactVersion(this.groupId, this.artifactId, this.version);
    }

    public String toStringNotation() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.groupId).append(':').append(this.artifactId);
        if (this.version != null) {
            builder.append(':').append(this.version);
            if (this.classifier != null) {
                builder.append(':').append(this.classifier);
            }
        }
        if (this.ext != null) {
            builder.append('@').append(this.ext);
        }
        return builder.toString();
    }

    public Dependency(String groupId, String artifactId, @Nullable String version, @Nullable String classifier, @Nullable String ext) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
        this.ext = ext;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    @Nullable
    public String getExt() {
        return this.ext;
    }

    @NonNull
    public String toString() {
        return "Dependency(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", classifier=" + this.getClassifier() + ", ext=" + this.getExt() + ")";
    }

    @NonNull
    public Dependency withGroupId(String groupId) {
        return this.groupId == groupId ? this : new Dependency(groupId, this.artifactId, this.version, this.classifier, this.ext);
    }

    @NonNull
    public Dependency withArtifactId(String artifactId) {
        return this.artifactId == artifactId ? this : new Dependency(this.groupId, artifactId, this.version, this.classifier, this.ext);
    }

    @NonNull
    public Dependency withVersion(@Nullable String version) {
        return this.version == version ? this : new Dependency(this.groupId, this.artifactId, version, this.classifier, this.ext);
    }

    @NonNull
    public Dependency withClassifier(@Nullable String classifier) {
        return this.classifier == classifier ? this : new Dependency(this.groupId, this.artifactId, this.version, classifier, this.ext);
    }

    @NonNull
    public Dependency withExt(@Nullable String ext) {
        return this.ext == ext ? this : new Dependency(this.groupId, this.artifactId, this.version, this.classifier, ext);
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dependency)) {
            return false;
        }
        Dependency other = (Dependency)o;
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$classifier = this.getClassifier();
        String other$classifier = other.getClassifier();
        if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
            return false;
        }
        String this$ext = this.getExt();
        String other$ext = other.getExt();
        return !(this$ext == null ? other$ext != null : !this$ext.equals(other$ext));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $classifier = this.getClassifier();
        result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
        String $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : $ext.hashCode());
        return result;
    }
}

