/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.plugins;

import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.plugins.AddPluginVisitor;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.semver.Semver;

public final class AddBuildPlugin
extends Recipe {
    @Option(displayName="Plugin id", description="The plugin id to apply.", example="com.jfrog.bintray")
    private final String pluginId;
    @Option(displayName="Plugin version", description="An exact version number or node-style semver selector used to select the version number. You can also use `latest.release` for the latest available version and `latest.patch` if the current version is a valid semantic version. For more details, you can look at the documentation page of [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors).", example="3.x", required=false)
    @Nullable
    private final String version;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;

    public String getDisplayName() {
        return "Add Gradle plugin";
    }

    public String getDescription() {
        return "Add a build plugin to a Gradle build file's `plugins` block.";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.version != null) {
            validated = validated.and(Semver.validate((String)this.version, (String)this.versionPattern));
        }
        return validated;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new IsBuildGradle(), (TreeVisitor)new GroovyIsoVisitor<ExecutionContext>(){

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                Optional maybeGradleProject = cu.getMarkers().findFirst(GradleProject.class);
                if (!maybeGradleProject.isPresent()) {
                    return cu;
                }
                GradleProject gradleProject = (GradleProject)maybeGradleProject.get();
                return (G.CompilationUnit)new AddPluginVisitor(AddBuildPlugin.this.pluginId, AddBuildPlugin.this.version, AddBuildPlugin.this.versionPattern, gradleProject.getMavenPluginRepositories()).visitNonNull((Tree)cu, ctx);
            }
        });
    }

    public AddBuildPlugin(String pluginId, @Nullable String version, @Nullable String versionPattern) {
        this.pluginId = pluginId;
        this.version = version;
        this.versionPattern = versionPattern;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @NonNull
    public String toString() {
        return "AddBuildPlugin(pluginId=" + this.getPluginId() + ", version=" + this.getVersion() + ", versionPattern=" + this.getVersionPattern() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddBuildPlugin)) {
            return false;
        }
        AddBuildPlugin other = (AddBuildPlugin)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddBuildPlugin;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }
}

