/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.marker;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.ResolvedDependency;

public final class GradleDependencyConfiguration
implements Serializable {
    private final String name;
    @Nullable
    private final String description;
    private final boolean isTransitive;
    private final boolean isCanBeResolved;
    private final boolean isCanBeConsumed;
    private List<GradleDependencyConfiguration> extendsFrom;
    private final List<Dependency> requested;
    private final List<ResolvedDependency> directResolved;
    @Nullable
    private final String exceptionType;
    @Nullable
    private final String message;

    public List<ResolvedDependency> getDirectResolved() {
        return this.directResolved == null ? Collections.emptyList() : this.directResolved;
    }

    public List<ResolvedDependency> getResolved() {
        ArrayList<ResolvedDependency> resolved = new ArrayList<ResolvedDependency>(this.getDirectResolved());
        HashSet<ResolvedDependency> alreadyResolved = new HashSet<ResolvedDependency>();
        return GradleDependencyConfiguration.resolveTransitiveDependencies(resolved, alreadyResolved);
    }

    public List<GradleDependencyConfiguration> allExtendsFrom() {
        LinkedHashSet<GradleDependencyConfiguration> result = new LinkedHashSet<GradleDependencyConfiguration>();
        for (GradleDependencyConfiguration parentConfiguration : this.getExtendsFrom()) {
            result.add(parentConfiguration);
            result.addAll(parentConfiguration.allExtendsFrom());
        }
        return new ArrayList<GradleDependencyConfiguration>(result);
    }

    @Nullable
    public Dependency findRequestedDependency(String groupId, String artifactId) {
        for (Dependency d : this.requested) {
            if (!StringUtils.matchesGlob((String)d.getGav().getGroupId(), (String)groupId) || !StringUtils.matchesGlob((String)d.getGav().getArtifactId(), (String)artifactId)) continue;
            return d;
        }
        return null;
    }

    @Nullable
    public ResolvedDependency findResolvedDependency(String groupId, String artifactId) {
        for (ResolvedDependency d : this.directResolved) {
            ResolvedDependency dependency = d.findDependency(groupId, artifactId);
            if (dependency == null) continue;
            return dependency;
        }
        return null;
    }

    public void unsafeSetExtendsFrom(List<GradleDependencyConfiguration> extendsFrom) {
        this.extendsFrom = extendsFrom;
    }

    private static List<ResolvedDependency> resolveTransitiveDependencies(List<ResolvedDependency> resolved, Set<ResolvedDependency> alreadyResolved) {
        for (ResolvedDependency dependency : resolved) {
            if (!alreadyResolved.add(dependency)) continue;
            alreadyResolved.addAll(GradleDependencyConfiguration.resolveTransitiveDependencies(dependency.getDependencies(), alreadyResolved));
        }
        return new ArrayList<ResolvedDependency>(alreadyResolved);
    }

    public GradleDependencyConfiguration(String name, @Nullable String description, boolean isTransitive, boolean isCanBeResolved, boolean isCanBeConsumed, List<GradleDependencyConfiguration> extendsFrom, List<Dependency> requested, List<ResolvedDependency> directResolved, @Nullable String exceptionType, @Nullable String message) {
        this.name = name;
        this.description = description;
        this.isTransitive = isTransitive;
        this.isCanBeResolved = isCanBeResolved;
        this.isCanBeConsumed = isCanBeConsumed;
        this.extendsFrom = extendsFrom;
        this.requested = requested;
        this.directResolved = directResolved;
        this.exceptionType = exceptionType;
        this.message = message;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isTransitive() {
        return this.isTransitive;
    }

    public boolean isCanBeResolved() {
        return this.isCanBeResolved;
    }

    public boolean isCanBeConsumed() {
        return this.isCanBeConsumed;
    }

    public List<GradleDependencyConfiguration> getExtendsFrom() {
        return this.extendsFrom;
    }

    public List<Dependency> getRequested() {
        return this.requested;
    }

    @Nullable
    public String getExceptionType() {
        return this.exceptionType;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GradleDependencyConfiguration)) {
            return false;
        }
        GradleDependencyConfiguration other = (GradleDependencyConfiguration)o;
        if (this.isTransitive() != other.isTransitive()) {
            return false;
        }
        if (this.isCanBeResolved() != other.isCanBeResolved()) {
            return false;
        }
        if (this.isCanBeConsumed() != other.isCanBeConsumed()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<GradleDependencyConfiguration> this$extendsFrom = this.getExtendsFrom();
        List<GradleDependencyConfiguration> other$extendsFrom = other.getExtendsFrom();
        if (this$extendsFrom == null ? other$extendsFrom != null : !((Object)this$extendsFrom).equals(other$extendsFrom)) {
            return false;
        }
        List<Dependency> this$requested = this.getRequested();
        List<Dependency> other$requested = other.getRequested();
        if (this$requested == null ? other$requested != null : !((Object)this$requested).equals(other$requested)) {
            return false;
        }
        List<ResolvedDependency> this$directResolved = this.getDirectResolved();
        List<ResolvedDependency> other$directResolved = other.getDirectResolved();
        if (this$directResolved == null ? other$directResolved != null : !((Object)this$directResolved).equals(other$directResolved)) {
            return false;
        }
        String this$exceptionType = this.getExceptionType();
        String other$exceptionType = other.getExceptionType();
        if (this$exceptionType == null ? other$exceptionType != null : !this$exceptionType.equals(other$exceptionType)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTransitive() ? 79 : 97);
        result = result * 59 + (this.isCanBeResolved() ? 79 : 97);
        result = result * 59 + (this.isCanBeConsumed() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<GradleDependencyConfiguration> $extendsFrom = this.getExtendsFrom();
        result = result * 59 + ($extendsFrom == null ? 43 : ((Object)$extendsFrom).hashCode());
        List<Dependency> $requested = this.getRequested();
        result = result * 59 + ($requested == null ? 43 : ((Object)$requested).hashCode());
        List<ResolvedDependency> $directResolved = this.getDirectResolved();
        result = result * 59 + ($directResolved == null ? 43 : ((Object)$directResolved).hashCode());
        String $exceptionType = this.getExceptionType();
        result = result * 59 + ($exceptionType == null ? 43 : $exceptionType.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "GradleDependencyConfiguration(name=" + this.getName() + ", description=" + this.getDescription() + ", isTransitive=" + this.isTransitive() + ", isCanBeResolved=" + this.isCanBeResolved() + ", isCanBeConsumed=" + this.isCanBeConsumed() + ", extendsFrom=" + this.getExtendsFrom() + ", requested=" + this.getRequested() + ", directResolved=" + this.getDirectResolved() + ", exceptionType=" + this.getExceptionType() + ", message=" + this.getMessage() + ")";
    }

    @NonNull
    public GradleDependencyConfiguration withName(String name) {
        return this.name == name ? this : new GradleDependencyConfiguration(name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.extendsFrom, this.requested, this.directResolved, this.exceptionType, this.message);
    }

    @NonNull
    public GradleDependencyConfiguration withDescription(@Nullable String description) {
        return this.description == description ? this : new GradleDependencyConfiguration(this.name, description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.extendsFrom, this.requested, this.directResolved, this.exceptionType, this.message);
    }

    @NonNull
    public GradleDependencyConfiguration withTransitive(boolean isTransitive) {
        return this.isTransitive == isTransitive ? this : new GradleDependencyConfiguration(this.name, this.description, isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.extendsFrom, this.requested, this.directResolved, this.exceptionType, this.message);
    }

    @NonNull
    public GradleDependencyConfiguration withCanBeResolved(boolean isCanBeResolved) {
        return this.isCanBeResolved == isCanBeResolved ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, isCanBeResolved, this.isCanBeConsumed, this.extendsFrom, this.requested, this.directResolved, this.exceptionType, this.message);
    }

    @NonNull
    public GradleDependencyConfiguration withCanBeConsumed(boolean isCanBeConsumed) {
        return this.isCanBeConsumed == isCanBeConsumed ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, isCanBeConsumed, this.extendsFrom, this.requested, this.directResolved, this.exceptionType, this.message);
    }

    @NonNull
    public GradleDependencyConfiguration withExtendsFrom(List<GradleDependencyConfiguration> extendsFrom) {
        return this.extendsFrom == extendsFrom ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, extendsFrom, this.requested, this.directResolved, this.exceptionType, this.message);
    }

    @NonNull
    public GradleDependencyConfiguration withRequested(List<Dependency> requested) {
        return this.requested == requested ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.extendsFrom, requested, this.directResolved, this.exceptionType, this.message);
    }

    @NonNull
    public GradleDependencyConfiguration withDirectResolved(List<ResolvedDependency> directResolved) {
        return this.directResolved == directResolved ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.extendsFrom, this.requested, directResolved, this.exceptionType, this.message);
    }

    @NonNull
    public GradleDependencyConfiguration withExceptionType(@Nullable String exceptionType) {
        return this.exceptionType == exceptionType ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.extendsFrom, this.requested, this.directResolved, exceptionType, this.message);
    }

    @NonNull
    public GradleDependencyConfiguration withMessage(@Nullable String message) {
        return this.message == message ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.extendsFrom, this.requested, this.directResolved, this.exceptionType, message);
    }
}

