/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.plugins;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsSettingsGradle;
import org.openrewrite.gradle.plugins.AddPluginVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class AddSettingsPlugin
extends Recipe {
    @Option(displayName="Plugin id", description="The plugin id to apply.", example="com.jfrog.bintray")
    private final String pluginId;
    @Option(displayName="Plugin version", description="An exact version number or node-style semver selector used to select the version number.", example="3.x")
    private final String version;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;

    public String getDisplayName() {
        return "Add a Gradle settings plugin";
    }

    public String getDescription() {
        return "Add a Gradle settings plugin to `settings.gradle(.kts)`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new IsSettingsGradle(), (TreeVisitor)new AddPluginVisitor(this.pluginId, this.version, this.versionPattern));
    }

    public AddSettingsPlugin(String pluginId, String version, @Nullable String versionPattern) {
        this.pluginId = pluginId;
        this.version = version;
        this.versionPattern = versionPattern;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @NonNull
    public String toString() {
        return "AddSettingsPlugin(pluginId=" + this.getPluginId() + ", version=" + this.getVersion() + ", versionPattern=" + this.getVersionPattern() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddSettingsPlugin)) {
            return false;
        }
        AddSettingsPlugin other = (AddSettingsPlugin)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddSettingsPlugin;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }
}

