/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.search;

import org.openrewrite.Applicability;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.IsSettingsGradle;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.GroovyPrinter;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.SearchResult;

public final class FindRepository
extends Recipe {
    @Option(displayName="Type", description="The type of the artifact repository", example="maven", required=false)
    @Nullable
    private final String type;
    @Option(displayName="URL", description="The url of the artifact repository", example="https://repo.spring.io", required=false)
    @Nullable
    private final String url;
    @Option(displayName="Purpose", description="The purpose of this repository in terms of resolving project or plugin dependencies", valid={"Project", "Plugin"}, required=false)
    @Nullable
    private final Purpose purpose;

    public String getDisplayName() {
        return "Find Gradle repository";
    }

    public String getDescription() {
        return "Find a Gradle repository by url.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return Applicability.or((TreeVisitor[])new TreeVisitor[]{new IsBuildGradle(), new IsSettingsGradle()});
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher pluginManagementMatcher = new MethodMatcher("RewriteSettings pluginManagement(..)");
        final MethodMatcher buildscriptMatcher = new MethodMatcher("RewriteGradleProject buildscript(..)");
        return new GroovyIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                boolean isPluginBlock;
                if (FindRepository.this.purpose == null) {
                    return new RepositoryVisitor().visitMethodInvocation(method, ctx);
                }
                boolean bl = isPluginBlock = pluginManagementMatcher.matches(method) || buildscriptMatcher.matches(method);
                if (FindRepository.this.purpose == Purpose.Project && !isPluginBlock || FindRepository.this.purpose == Purpose.Plugin && isPluginBlock) {
                    return new RepositoryVisitor().visitMethodInvocation(method, ctx);
                }
                return method;
            }
        };
    }

    public FindRepository(@Nullable String type, @Nullable String url, @Nullable Purpose purpose) {
        this.type = type;
        this.url = url;
        this.purpose = purpose;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    @Nullable
    public Purpose getPurpose() {
        return this.purpose;
    }

    @NonNull
    public String toString() {
        return "FindRepository(type=" + this.getType() + ", url=" + this.getUrl() + ", purpose=" + (Object)((Object)this.getPurpose()) + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindRepository)) {
            return false;
        }
        FindRepository other = (FindRepository)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        Purpose this$purpose = this.getPurpose();
        Purpose other$purpose = other.getPurpose();
        return !(this$purpose == null ? other$purpose != null : !((Object)((Object)this$purpose)).equals((Object)other$purpose));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindRepository;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        Purpose $purpose = this.getPurpose();
        result = result * 59 + ($purpose == null ? 43 : ((Object)((Object)$purpose)).hashCode());
        return result;
    }

    public static enum Purpose {
        Project,
        Plugin;

    }

    private class RepositoryVisitor
    extends GroovyIsoVisitor<ExecutionContext> {
        private final MethodMatcher repositoryMatcher = new MethodMatcher("org.gradle.api.artifacts.dsl.RepositoryHandler *(..)", true);

        private RepositoryVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            if (!this.repositoryMatcher.matches(m)) {
                return m;
            }
            boolean match = true;
            if (FindRepository.this.type != null && !m.getSimpleName().equals(FindRepository.this.type)) {
                match = false;
            }
            if (FindRepository.this.url != null && !this.urlMatches(m, FindRepository.this.url)) {
                match = false;
            }
            if (!match) {
                return m;
            }
            return (J.MethodInvocation)SearchResult.found((Tree)m);
        }

        private boolean urlMatches(J.MethodInvocation m, String url) {
            if (!(m.getArguments().get(0) instanceof J.Lambda)) {
                return false;
            }
            J.Lambda lambda = (J.Lambda)m.getArguments().get(0);
            if (!(lambda.getBody() instanceof J.Block)) {
                return false;
            }
            J.Block block = (J.Block)lambda.getBody();
            for (Statement statement : block.getStatements()) {
                J.MethodInvocation m1;
                if (statement instanceof J.Assignment || statement instanceof J.Return && ((J.Return)statement).getExpression() instanceof J.Assignment) {
                    J.Assignment assignment = (J.Assignment)(statement instanceof J.Return ? ((J.Return)statement).getExpression() : statement);
                    if (!(assignment.getVariable() instanceof J.Identifier) || !"url".equals(((J.Identifier)assignment.getVariable()).getSimpleName())) continue;
                    if (assignment.getAssignment() instanceof J.Literal && url.equals(((J.Literal)assignment.getAssignment()).getValue())) {
                        return true;
                    }
                    if (assignment.getAssignment() instanceof J.MethodInvocation && ((J.MethodInvocation)assignment.getAssignment()).getSimpleName().equals("uri") && ((J.MethodInvocation)assignment.getAssignment()).getArguments().get(0) instanceof J.Literal && url.equals(((J.Literal)((J.MethodInvocation)assignment.getAssignment()).getArguments().get(0)).getValue())) {
                        return true;
                    }
                    if (!(assignment.getAssignment() instanceof G.GString)) continue;
                    String valueSource = assignment.getAssignment().withPrefix(Space.EMPTY).printTrimmed((TreeVisitor)new GroovyPrinter());
                    String testSource = ((G.GString)assignment.getAssignment()).getDelimiter() + url + ((G.GString)assignment.getAssignment()).getDelimiter();
                    return testSource.equals(valueSource);
                }
                if (!(statement instanceof J.MethodInvocation) && (!(statement instanceof J.Return) || !(((J.Return)statement).getExpression() instanceof J.MethodInvocation)) || !(m1 = (J.MethodInvocation)(statement instanceof J.Return ? ((J.Return)statement).getExpression() : statement)).getSimpleName().equals("setUrl") && !m1.getSimpleName().equals("url")) continue;
                if (m1.getArguments().get(0) instanceof J.Literal && url.equals(((J.Literal)m1.getArguments().get(0)).getValue())) {
                    return true;
                }
                if (m1.getArguments().get(0) instanceof J.MethodInvocation && ((J.MethodInvocation)m1.getArguments().get(0)).getSimpleName().equals("uri") && ((J.MethodInvocation)m1.getArguments().get(0)).getArguments().get(0) instanceof J.Literal && url.equals(((J.Literal)((J.MethodInvocation)m1.getArguments().get(0)).getArguments().get(0)).getValue())) {
                    return true;
                }
                if (!(m1.getArguments().get(0) instanceof G.GString)) continue;
                G.GString value = (G.GString)m1.getArguments().get(0);
                String valueSource = value.withPrefix(Space.EMPTY).printTrimmed((TreeVisitor)new GroovyPrinter());
                String testSource = value.getDelimiter() + url + value.getDelimiter();
                return testSource.equals(valueSource);
            }
            return false;
        }
    }
}

