/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.List;
import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.util.Dependency;
import org.openrewrite.gradle.util.DependencyStringNotationConverter;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.semver.DependencyMatcher;

final class RemoveGradleDependency
extends Recipe {
    @Option(displayName="The dependency configuration", description="The dependency configuration to remove from.", example="api", required=false)
    @Nullable
    private final String configuration;
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="com.fasterxml.jackson*")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="jackson-module*")
    private final String artifactId;

    public String getDisplayName() {
        return "Remove a Gradle dependency";
    }

    public String getDescription() {
        return "Removes a single dependency from the dependencies section of the `build.gradle`.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new IsBuildGradle();
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new GroovyVisitor<ExecutionContext>(){
            final DependencyMatcher depMatcher;
            final MethodMatcher dependencyDsl;
            {
                this.depMatcher = Objects.requireNonNull((DependencyMatcher)DependencyMatcher.build((String)(RemoveGradleDependency.this.groupId + ":" + RemoveGradleDependency.this.artifactId)).getValue());
                this.dependencyDsl = new MethodMatcher("DependencyHandlerSpec *(..)");
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation decl = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (this.dependencyDsl.matches(decl) && RemoveGradleDependency.this.configuration != null && !RemoveGradleDependency.this.configuration.isEmpty() && decl.getSimpleName().equals(RemoveGradleDependency.this.configuration)) {
                    List declArguments = decl.getArguments();
                    if (declArguments.get(0) instanceof J.Literal) {
                        J.Literal stringLiteralArgument = (J.Literal)declArguments.get(0);
                        String argumentValue = (String)stringLiteralArgument.getValue();
                        Dependency dependency = DependencyStringNotationConverter.parse(argumentValue);
                        if (this.depMatcher.matches(dependency.getGroupId(), dependency.getArtifactId())) {
                            return null;
                        }
                    } else if (declArguments.get(0) instanceof G.MapEntry) {
                        String groupId = null;
                        String artifactId = null;
                        String version = null;
                        for (Expression e : declArguments) {
                            G.MapEntry arg;
                            if (!(e instanceof G.MapEntry) || !((arg = (G.MapEntry)e).getKey() instanceof J.Literal) || !(arg.getValue() instanceof J.Literal)) continue;
                            J.Literal key = (J.Literal)arg.getKey();
                            J.Literal value = (J.Literal)arg.getValue();
                            if (!(key.getValue() instanceof String) || !(value.getValue() instanceof String)) continue;
                            String keyValue = (String)key.getValue();
                            String valueValue = (String)value.getValue();
                            if ("group".equals(keyValue)) {
                                groupId = valueValue;
                                continue;
                            }
                            if ("name".equals(keyValue)) {
                                artifactId = valueValue;
                                continue;
                            }
                            if (!"version".equals(keyValue)) continue;
                            version = valueValue;
                        }
                        if (groupId == null || artifactId == null || version == null && !this.depMatcher.matches(groupId, artifactId) || version != null && !this.depMatcher.matches(groupId, artifactId, version)) {
                            return decl;
                        }
                        return null;
                    }
                }
                return decl;
            }
        };
    }

    public RemoveGradleDependency(@Nullable String configuration, String groupId, String artifactId) {
        this.configuration = configuration;
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    @Nullable
    public String getConfiguration() {
        return this.configuration;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @NonNull
    public String toString() {
        return "RemoveGradleDependency(configuration=" + this.getConfiguration() + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveGradleDependency)) {
            return false;
        }
        RemoveGradleDependency other = (RemoveGradleDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        return !(this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveGradleDependency;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        return result;
    }
}

