/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.search;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.search.FindGradleProject;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.table.DependenciesInUse;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.xml.tree.Xml;

public final class DependencyInsight
extends Recipe {
    private final transient DependenciesInUse dependenciesInUse = new DependenciesInUse((Recipe)this);
    private static final MethodMatcher DEPENDENCY_CONFIGURATION_MATCHER = new MethodMatcher("DependencyHandlerSpec *(..)");
    @Option(displayName="Group pattern", description="Group glob pattern used to match dependencies.", example="com.fasterxml.jackson.module")
    private final String groupIdPattern;
    @Option(displayName="Artifact pattern", description="Artifact glob pattern used to match dependencies.", example="jackson-module-*")
    private final String artifactIdPattern;
    @Option(displayName="Scope", description="Match dependencies with the specified scope. If not specified, all configurations will be searched.", example="compileClasspath", required=false)
    @Nullable
    private final String configuration;

    public String getDisplayName() {
        return "Gradle dependency insight";
    }

    public String getDescription() {
        return "Find direct and transitive dependencies matching a group, artifact, and optionally a configuration name. Results include dependencies that either directly match or transitively include a matching dependency.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new FindGradleProject(FindGradleProject.SearchCriteria.Marker).getVisitor();
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new GroovyIsoVisitor<ExecutionContext>(){
            Map<String, List<ResolvedDependency>> configToMatchingDependencies;

            public JavaSourceFile visitJavaSourceFile(JavaSourceFile compilationUnit, ExecutionContext executionContext) {
                GradleProject gp = compilationUnit.getMarkers().findFirst(GradleProject.class).orElse(null);
                if (gp == null) {
                    return compilationUnit;
                }
                this.configToMatchingDependencies = gp.getConfigurations().stream().filter(c -> DependencyInsight.this.configuration == null || c.getName().equals(DependencyInsight.this.configuration)).collect(Collectors.toMap(GradleDependencyConfiguration::getName, c -> c.getResolved().stream().filter(resolvedDependency -> resolvedDependency.findDependency(DependencyInsight.this.groupIdPattern, DependencyInsight.this.artifactIdPattern) != null).collect(Collectors.toList())));
                if (this.configToMatchingDependencies.isEmpty()) {
                    return compilationUnit;
                }
                return super.visitJavaSourceFile(compilationUnit, (Object)executionContext);
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (!DEPENDENCY_CONFIGURATION_MATCHER.matches(m) || !this.configToMatchingDependencies.containsKey(m.getSimpleName()) || m.getArguments().isEmpty()) {
                    return m;
                }
                Expression arg = (Expression)m.getArguments().get(0);
                if (arg instanceof J.Literal && ((J.Literal)arg).getValue() instanceof String) {
                    String[] gav = ((String)((J.Literal)arg).getValue()).split(":");
                    if (gav.length < 2) {
                        return m;
                    }
                    String groupId = gav[0];
                    String artifactId = gav[1];
                    Optional<ResolvedDependency> maybeMatch = this.configToMatchingDependencies.get(m.getSimpleName()).stream().filter(dep -> Objects.equals(dep.getGroupId(), groupId) && Objects.equals(dep.getArtifactId(), artifactId)).findAny();
                    if (!maybeMatch.isPresent()) {
                        return m;
                    }
                    ResolvedDependency match = maybeMatch.get().findDependency(DependencyInsight.this.groupIdPattern, DependencyInsight.this.artifactIdPattern);
                    if (match != null) {
                        return (J.MethodInvocation)SearchResult.found((Tree)m, (String)(match.getGroupId() + ":" + match.getArtifactId() + ":" + match.getVersion()));
                    }
                } else if (arg instanceof G.MapEntry) {
                    String groupId = null;
                    String artifactId = null;
                    for (Expression argExp : m.getArguments()) {
                        G.MapEntry gavPart;
                        if (!(argExp instanceof G.MapEntry) || !((gavPart = (G.MapEntry)argExp).getKey() instanceof J.Literal)) continue;
                        String key = (String)((J.Literal)gavPart.getKey()).getValue();
                        if ("group".equals(key)) {
                            groupId = (String)((J.Literal)gavPart.getValue()).getValue();
                        } else if ("name".equals(key)) {
                            artifactId = (String)((J.Literal)gavPart.getValue()).getValue();
                        }
                        if (groupId == null || artifactId == null) continue;
                        break;
                    }
                    String finalGroupId = groupId;
                    String finalArtifactId = artifactId;
                    Optional<ResolvedDependency> maybeMatch = this.configToMatchingDependencies.get(m.getSimpleName()).stream().filter(dep -> Objects.equals(dep.getGroupId(), finalGroupId) && Objects.equals(dep.getArtifactId(), finalArtifactId)).findAny();
                    if (!maybeMatch.isPresent()) {
                        return m;
                    }
                    ResolvedDependency match = maybeMatch.get().findDependency(DependencyInsight.this.groupIdPattern, DependencyInsight.this.artifactIdPattern);
                    if (match != null) {
                        Optional javaProject = ((Xml.Document)this.getCursor().firstEnclosingOrThrow(Xml.Document.class)).getMarkers().findFirst(JavaProject.class);
                        Optional javaSourceSet = ((Xml.Document)this.getCursor().firstEnclosingOrThrow(Xml.Document.class)).getMarkers().findFirst(JavaSourceSet.class);
                        DependencyInsight.this.dependenciesInUse.insertRow(ctx, (Object)new DependenciesInUse.Row(javaProject.map(JavaProject::getProjectName).orElse(""), javaSourceSet.map(JavaSourceSet::getName).orElse("main"), match.getGroupId(), match.getArtifactId(), match.getVersion(), match.getDatedSnapshotVersion(), StringUtils.isBlank((String)match.getRequested().getScope()) ? "compile" : match.getRequested().getScope(), Integer.valueOf(match.getDepth())));
                        return (J.MethodInvocation)SearchResult.found((Tree)m, (String)(match.getGroupId() + ":" + match.getArtifactId() + ":" + match.getVersion()));
                    }
                }
                return m;
            }
        };
    }

    public DependencyInsight(String groupIdPattern, String artifactIdPattern, @Nullable String configuration) {
        this.groupIdPattern = groupIdPattern;
        this.artifactIdPattern = artifactIdPattern;
        this.configuration = configuration;
    }

    public DependenciesInUse getDependenciesInUse() {
        return this.dependenciesInUse;
    }

    public String getGroupIdPattern() {
        return this.groupIdPattern;
    }

    public String getArtifactIdPattern() {
        return this.artifactIdPattern;
    }

    @Nullable
    public String getConfiguration() {
        return this.configuration;
    }

    @NonNull
    public String toString() {
        return "DependencyInsight(dependenciesInUse=" + this.getDependenciesInUse() + ", groupIdPattern=" + this.getGroupIdPattern() + ", artifactIdPattern=" + this.getArtifactIdPattern() + ", configuration=" + this.getConfiguration() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependencyInsight)) {
            return false;
        }
        DependencyInsight other = (DependencyInsight)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groupIdPattern = this.getGroupIdPattern();
        String other$groupIdPattern = other.getGroupIdPattern();
        if (this$groupIdPattern == null ? other$groupIdPattern != null : !this$groupIdPattern.equals(other$groupIdPattern)) {
            return false;
        }
        String this$artifactIdPattern = this.getArtifactIdPattern();
        String other$artifactIdPattern = other.getArtifactIdPattern();
        if (this$artifactIdPattern == null ? other$artifactIdPattern != null : !this$artifactIdPattern.equals(other$artifactIdPattern)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DependencyInsight;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groupIdPattern = this.getGroupIdPattern();
        result = result * 59 + ($groupIdPattern == null ? 43 : $groupIdPattern.hashCode());
        String $artifactIdPattern = this.getArtifactIdPattern();
        result = result * 59 + ($artifactIdPattern == null ? 43 : $artifactIdPattern.hashCode());
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        return result;
    }
}

