/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.intellij.lang.annotations.Language;
import org.openrewrite.Checksum;
import org.openrewrite.FileAttributes;
import org.openrewrite.Tree;
import org.openrewrite.gradle.util.GradleWrapper;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.ipc.http.HttpSender;
import org.openrewrite.marker.Markers;
import org.openrewrite.remote.Remote;

public final class GradleWrapperJar
implements Remote {
    private final UUID id;
    private final Path sourcePath;
    private final Markers markers;
    private final URI uri;
    private final boolean charsetBomMarked;
    @Nullable
    private final FileAttributes fileAttributes;
    @Nullable
    private final Charset charset;
    @Language(value="markdown")
    private final String description;
    private final String version;
    private final Checksum checksum;

    public GradleWrapperJar(URI uri, String version, Checksum checksum) {
        this.uri = uri;
        this.version = version;
        this.checksum = checksum;
        this.description = "gradle-wrapper.jar is part of the gradle wrapper";
        this.sourcePath = GradleWrapper.WRAPPER_JAR_LOCATION;
        this.charset = null;
        this.charsetBomMarked = false;
        this.fileAttributes = GradleWrapper.WRAPPER_JAR_FILE_ATTRIBUTES;
        this.markers = Markers.EMPTY;
        this.id = Tree.randomId();
    }

    public InputStream getInputStream(HttpSender httpSender) {
        HttpSender.Response response = httpSender.send(httpSender.get(this.uri.toString()).build());
        InputStream body = response.getBody();
        return this.readIntoArchive(body, "gradle-" + this.version + "/**/gradle-wrapper-*.jar!gradle-wrapper.jar");
    }

    private InputStream readIntoArchive(InputStream body, String pathPattern) {
        String pathBeforeBang;
        String pathAfterBang = null;
        int bangIndex = pathPattern.indexOf(33);
        if (bangIndex == -1) {
            pathBeforeBang = pathPattern;
        } else {
            pathBeforeBang = pathPattern.substring(0, bangIndex);
            pathAfterBang = pathPattern.substring(bangIndex + 1);
        }
        final ZipInputStream zis = new ZipInputStream(body);
        try {
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (!StringUtils.matchesGlob((String)entry.getName(), (String)pathBeforeBang) || entry.getName().contains("gradle-wrapper-shared")) continue;
                if (pathAfterBang == null) {
                    return new InputStream(){

                        @Override
                        public int read() throws IOException {
                            return zis.read();
                        }

                        @Override
                        public void close() throws IOException {
                            zis.closeEntry();
                            zis.close();
                        }
                    };
                }
                return this.readIntoArchive(zis, pathAfterBang);
            }
        }
        catch (IOException e2) {
            throw new IllegalArgumentException("Unable to load path " + pathPattern + " in zip file " + this.uri, e2);
        }
        throw new IllegalArgumentException("Unable to find path " + pathPattern + " in zip file " + this.uri);
    }

    public GradleWrapperJar(UUID id, Path sourcePath, Markers markers, URI uri, boolean charsetBomMarked, @Nullable FileAttributes fileAttributes, @Nullable Charset charset, @Language(value="markdown") String description, String version, Checksum checksum) {
        this.id = id;
        this.sourcePath = sourcePath;
        this.markers = markers;
        this.uri = uri;
        this.charsetBomMarked = charsetBomMarked;
        this.fileAttributes = fileAttributes;
        this.charset = charset;
        this.description = description;
        this.version = version;
        this.checksum = checksum;
    }

    public UUID getId() {
        return this.id;
    }

    public Path getSourcePath() {
        return this.sourcePath;
    }

    public Markers getMarkers() {
        return this.markers;
    }

    public URI getUri() {
        return this.uri;
    }

    public boolean isCharsetBomMarked() {
        return this.charsetBomMarked;
    }

    @Nullable
    public FileAttributes getFileAttributes() {
        return this.fileAttributes;
    }

    @Nullable
    public Charset getCharset() {
        return this.charset;
    }

    @Language(value="markdown")
    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public Checksum getChecksum() {
        return this.checksum;
    }

    @NonNull
    public String toString() {
        return "GradleWrapperJar(id=" + this.getId() + ", sourcePath=" + this.getSourcePath() + ", markers=" + this.getMarkers() + ", uri=" + this.getUri() + ", charsetBomMarked=" + this.isCharsetBomMarked() + ", fileAttributes=" + this.getFileAttributes() + ", charset=" + this.getCharset() + ", description=" + this.getDescription() + ", version=" + this.getVersion() + ", checksum=" + this.getChecksum() + ")";
    }

    public boolean equals(@Nullable Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof GradleWrapperJar)) {
            return false;
        }
        GradleWrapperJar other = (GradleWrapperJar)o2;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @NonNull
    public GradleWrapperJar withId(UUID id) {
        return this.id == id ? this : new GradleWrapperJar(id, this.sourcePath, this.markers, this.uri, this.charsetBomMarked, this.fileAttributes, this.charset, this.description, this.version, this.checksum);
    }

    @NonNull
    public GradleWrapperJar withSourcePath(Path sourcePath) {
        return this.sourcePath == sourcePath ? this : new GradleWrapperJar(this.id, sourcePath, this.markers, this.uri, this.charsetBomMarked, this.fileAttributes, this.charset, this.description, this.version, this.checksum);
    }

    @NonNull
    public GradleWrapperJar withMarkers(Markers markers) {
        return this.markers == markers ? this : new GradleWrapperJar(this.id, this.sourcePath, markers, this.uri, this.charsetBomMarked, this.fileAttributes, this.charset, this.description, this.version, this.checksum);
    }

    @NonNull
    public GradleWrapperJar withUri(URI uri) {
        return this.uri == uri ? this : new GradleWrapperJar(this.id, this.sourcePath, this.markers, uri, this.charsetBomMarked, this.fileAttributes, this.charset, this.description, this.version, this.checksum);
    }

    @NonNull
    public GradleWrapperJar withCharsetBomMarked(boolean charsetBomMarked) {
        return this.charsetBomMarked == charsetBomMarked ? this : new GradleWrapperJar(this.id, this.sourcePath, this.markers, this.uri, charsetBomMarked, this.fileAttributes, this.charset, this.description, this.version, this.checksum);
    }

    @NonNull
    public GradleWrapperJar withFileAttributes(@Nullable FileAttributes fileAttributes) {
        return this.fileAttributes == fileAttributes ? this : new GradleWrapperJar(this.id, this.sourcePath, this.markers, this.uri, this.charsetBomMarked, fileAttributes, this.charset, this.description, this.version, this.checksum);
    }

    @NonNull
    public GradleWrapperJar withCharset(@Nullable Charset charset) {
        return this.charset == charset ? this : new GradleWrapperJar(this.id, this.sourcePath, this.markers, this.uri, this.charsetBomMarked, this.fileAttributes, charset, this.description, this.version, this.checksum);
    }

    @NonNull
    public GradleWrapperJar withDescription(@Language(value="markdown") String description) {
        return this.description == description ? this : new GradleWrapperJar(this.id, this.sourcePath, this.markers, this.uri, this.charsetBomMarked, this.fileAttributes, this.charset, description, this.version, this.checksum);
    }

    @NonNull
    public GradleWrapperJar withVersion(String version) {
        return this.version == version ? this : new GradleWrapperJar(this.id, this.sourcePath, this.markers, this.uri, this.charsetBomMarked, this.fileAttributes, this.charset, this.description, version, this.checksum);
    }

    @NonNull
    public GradleWrapperJar withChecksum(Checksum checksum) {
        return this.checksum == checksum ? this : new GradleWrapperJar(this.id, this.sourcePath, this.markers, this.uri, this.charsetBomMarked, this.fileAttributes, this.charset, this.description, this.version, checksum);
    }
}

