/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.tree.GradlePlugin;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.SearchResult;

public final class FindPlugins
extends Recipe {
    @Option(displayName="Plugin id", description="The `ID` part of `plugin { ID }`.", example="`com.jfrog.bintray`")
    private final String pluginId;

    public String getDisplayName() {
        return "Find Gradle plugin";
    }

    public String getDescription() {
        return "Find a Gradle plugin by id.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new IsBuildGradle();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher pluginMatcher = new MethodMatcher("PluginSpec id(..)", false);
        return new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (pluginMatcher.matches(method) && method.getArguments().get(0) instanceof J.Literal && FindPlugins.this.pluginId.equals(((J.Literal)method.getArguments().get(0)).getValue())) {
                    return (J)SearchResult.found((Tree)method);
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        };
    }

    public static List<GradlePlugin> find(J j2, String pluginIdPattern) {
        List plugins = (List)TreeVisitor.collect(new FindPlugins(pluginIdPattern).getVisitor(), (Tree)j2, new ArrayList(), J.MethodInvocation.class, Function.identity());
        MethodMatcher versionMatcher = new MethodMatcher("Plugin version(..)", false);
        MethodMatcher idMatcher = new MethodMatcher("PluginSpec id(..)", false);
        return plugins.stream().flatMap(plugin -> {
            if (versionMatcher.matches(plugin) && idMatcher.matches(plugin.getSelect())) {
                return Stream.of(new GradlePlugin((J.MethodInvocation)plugin, Objects.requireNonNull(((J.Literal)Objects.requireNonNull((J.MethodInvocation)plugin.getSelect()).getArguments().get(0)).getValue()).toString(), Objects.requireNonNull(((J.Literal)plugin.getArguments().get(0)).getValue()).toString()));
            }
            return Stream.empty();
        }).collect(Collectors.toList());
    }

    public FindPlugins(String pluginId) {
        this.pluginId = pluginId;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    @NonNull
    public String toString() {
        return "FindPlugins(pluginId=" + this.getPluginId() + ")";
    }

    public boolean equals(@Nullable Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof FindPlugins)) {
            return false;
        }
        FindPlugins other = (FindPlugins)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        return !(this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindPlugins;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        return result;
    }
}

