/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.plugins;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Disabled;
import org.openrewrite.Applicability;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.IsSettingsGradle;
import org.openrewrite.gradle.plugins.GradlePluginUtils;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.semver.ExactVersion;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

@Disabled(value="Gradle plugin portal is down on August 23, 2022")
public final class UpgradePluginVersion
extends Recipe {
    @Option(displayName="Plugin id", description="The `ID` part of `plugin { ID }`, as a glob expression.", example="com.jfrog.bintray")
    private final String pluginIdPattern;
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number.", example="29.X")
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;

    public String getDisplayName() {
        return "Update a Gradle plugin by id";
    }

    public String getDescription() {
        return "Update a Gradle plugin by id to a later version.";
    }

    public Validated validate() {
        return super.validate().and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return Applicability.or((TreeVisitor[])new TreeVisitor[]{new IsBuildGradle(), new IsSettingsGradle()});
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final VersionComparator versionComparator = (VersionComparator)Semver.validate((String)this.newVersion, (String)this.versionPattern).getValue();
        assert (versionComparator != null);
        final MethodMatcher pluginMatcher = new MethodMatcher("PluginSpec id(..)", false);
        final MethodMatcher versionMatcher = new MethodMatcher("Plugin version(..)", false);
        return new GroovyVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m2 = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (!(versionMatcher.matches(m2) && m2.getSelect() instanceof J.MethodInvocation && pluginMatcher.matches(m2.getSelect()))) {
                    return m2;
                }
                List pluginArgs = ((J.MethodInvocation)m2.getSelect()).getArguments();
                if (!(pluginArgs.get(0) instanceof J.Literal)) {
                    return m2;
                }
                String pluginId = (String)((J.Literal)pluginArgs.get(0)).getValue();
                if (pluginId == null || !StringUtils.matchesGlob((String)pluginId, (String)UpgradePluginVersion.this.pluginIdPattern)) {
                    return m2;
                }
                List versionArgs = m2.getArguments();
                if (!(versionArgs.get(0) instanceof J.Literal)) {
                    return m2;
                }
                String currentVersion = (String)((J.Literal)versionArgs.get(0)).getValue();
                if (currentVersion == null) {
                    return m2;
                }
                Optional version = versionComparator instanceof ExactVersion ? versionComparator.upgrade(currentVersion, Collections.singletonList(UpgradePluginVersion.this.newVersion)) : versionComparator.upgrade(currentVersion, GradlePluginUtils.availablePluginVersions(pluginId, ctx));
                J.MethodInvocation finalM = m2;
                m2 = version.map(upgradeVersion -> finalM.withArguments(ListUtils.map((List)versionArgs, v2 -> {
                    J.Literal versionLiteral = (J.Literal)v2;
                    assert (versionLiteral.getValueSource() != null);
                    return versionLiteral.withValue(upgradeVersion).withValueSource(versionLiteral.getValueSource().replace(currentVersion, (CharSequence)upgradeVersion));
                }))).orElse(m2);
                return m2;
            }
        };
    }

    public UpgradePluginVersion(String pluginIdPattern, String newVersion, @Nullable String versionPattern) {
        this.pluginIdPattern = pluginIdPattern;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
    }

    public String getPluginIdPattern() {
        return this.pluginIdPattern;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @NonNull
    public String toString() {
        return "UpgradePluginVersion(pluginIdPattern=" + this.getPluginIdPattern() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ")";
    }

    public boolean equals(@Nullable Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof UpgradePluginVersion)) {
            return false;
        }
        UpgradePluginVersion other = (UpgradePluginVersion)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        String this$pluginIdPattern = this.getPluginIdPattern();
        String other$pluginIdPattern = other.getPluginIdPattern();
        if (this$pluginIdPattern == null ? other$pluginIdPattern != null : !this$pluginIdPattern.equals(other$pluginIdPattern)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradePluginVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $pluginIdPattern = this.getPluginIdPattern();
        result = result * 59 + ($pluginIdPattern == null ? 43 : $pluginIdPattern.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }
}

