/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.plugins;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Parser;
import org.openrewrite.gradle.GradleParser;
import org.openrewrite.gradle.plugins.GradlePluginUtils;
import org.openrewrite.gradle.search.FindPlugins;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.FindMethods;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.semver.ExactVersion;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.template.SourceTemplate;

@Incubating(since="7.33.0")
public final class AddPluginVisitor
extends GroovyIsoVisitor<ExecutionContext> {
    private final String pluginIdPattern;
    private final String newVersion;
    @Nullable
    private final String versionPattern;

    public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu2, ExecutionContext ctx) {
        Optional version;
        VersionComparator versionComparator = (VersionComparator)Semver.validate((String)this.newVersion, (String)this.versionPattern).getValue();
        assert (versionComparator != null);
        if (FindPlugins.find((J)cu2, this.pluginIdPattern).isEmpty() && (version = versionComparator instanceof ExactVersion ? versionComparator.upgrade("0", Collections.singletonList(this.newVersion)) : versionComparator.upgrade("0", GradlePluginUtils.availablePluginVersions(this.pluginIdPattern, ctx))).isPresent()) {
            List statements = GradleParser.builder().build().parseInputs(Collections.singletonList(Parser.Input.fromString((Path)Paths.get("settings.gradle", new String[0]), (String)("plugins {\n    id '" + this.pluginIdPattern + "' version '" + (String)version.get() + "'\n}"))), null, ctx).get(0).getStatements();
            if (FindMethods.find((J)cu2, (String)"RewriteSettings plugins(..)").isEmpty()) {
                Space leadingSpace = Space.firstPrefix((List)cu2.getStatements());
                return cu2.withStatements(ListUtils.concatAll((List)statements, (List)Space.formatFirstPrefix((List)cu2.getStatements(), (Space)leadingSpace.withWhitespace("\n\n" + leadingSpace.getWhitespace()))));
            }
            MethodMatcher settingsPluginsMatcher = new MethodMatcher("RewriteSettings plugins(groovy.lang.Closure)");
            MethodMatcher buildPluginsMatcher = new MethodMatcher("RewriteGradleProject plugins(groovy.lang.Closure)");
            return cu2.withStatements(ListUtils.map((List)cu2.getStatements(), stat -> {
                J.MethodInvocation m2;
                JavaTemplate addPlugin = JavaTemplate.builder(() -> ((AddPluginVisitor)this).getCursor(), (String)"#{any(Plugin)}").build();
                if (stat instanceof J.MethodInvocation && (settingsPluginsMatcher.matches(m2 = (J.MethodInvocation)stat) || buildPluginsMatcher.matches(m2))) {
                    Set pluginDef = FindMethods.find((J)((J)statements.get(0)), (String)"Plugin version(..)");
                    m2 = (J.MethodInvocation)m2.withTemplate((SourceTemplate)addPlugin, ((J.Block)((J.Lambda)m2.getArguments().get(0)).getBody()).getCoordinates().firstStatement(), new Object[]{pluginDef.iterator().next()});
                    return m2;
                }
                return stat;
            }));
        }
        return super.visitCompilationUnit(cu2, (Object)ctx);
    }

    public AddPluginVisitor(String pluginIdPattern, String newVersion, @Nullable String versionPattern) {
        this.pluginIdPattern = pluginIdPattern;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
    }

    public String getPluginIdPattern() {
        return this.pluginIdPattern;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @NonNull
    public String toString() {
        return "AddPluginVisitor(pluginIdPattern=" + this.getPluginIdPattern() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ")";
    }

    public boolean equals(@Nullable Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof AddPluginVisitor)) {
            return false;
        }
        AddPluginVisitor other = (AddPluginVisitor)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$pluginIdPattern = this.getPluginIdPattern();
        String other$pluginIdPattern = other.getPluginIdPattern();
        if (this$pluginIdPattern == null ? other$pluginIdPattern != null : !this$pluginIdPattern.equals(other$pluginIdPattern)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddPluginVisitor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pluginIdPattern = this.getPluginIdPattern();
        result = result * 59 + ($pluginIdPattern == null ? 43 : $pluginIdPattern.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }
}

