/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.gradle.internal.SystemProperties;

public class TextUtil {
    private static final Pattern WHITESPACE = Pattern.compile("\\s*");
    private static final Pattern UPPER_CASE = Pattern.compile("(?=\\p{Upper})");
    private static final Joiner KEBAB_JOINER = Joiner.on((String)"-");
    private static final Function<String, String> TO_LOWERCASE = new Function<String, String>(){

        public String apply(String input) {
            return input.toLowerCase();
        }
    };

    public static String getWindowsLineSeparator() {
        return "\r\n";
    }

    public static String getUnixLineSeparator() {
        return "\n";
    }

    public static String getPlatformLineSeparator() {
        return SystemProperties.getInstance().getLineSeparator();
    }

    public static String convertLineSeparators(String str, String sep) {
        return str == null ? null : str.replaceAll("\r\n|\r|\n", sep);
    }

    public static String toPlatformLineSeparators(String str) {
        return str == null ? null : TextUtil.convertLineSeparators(str, TextUtil.getPlatformLineSeparator());
    }

    public static String normaliseLineSeparators(String str) {
        return str == null ? null : TextUtil.convertLineSeparators(str, "\n");
    }

    public static String normaliseFileSeparators(String path) {
        return path.replace(File.separatorChar, '/');
    }

    public static String escapeString(Object obj) {
        return obj == null ? null : StringEscapeUtils.escapeJava((String)obj.toString());
    }

    public static boolean containsWhitespace(String str) {
        for (int i2 = 0; i2 < str.length(); ++i2) {
            if (!Character.isWhitespace(str.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    public static String indent(String text, String indent) {
        StringBuilder builder = new StringBuilder();
        String[] lines = text.split("\n");
        for (int i2 = 0; i2 < lines.length; ++i2) {
            String line = lines[i2];
            if (!WHITESPACE.matcher(line).matches()) {
                builder.append(indent);
            }
            builder.append(line);
            if (i2 >= lines.length - 1) continue;
            builder.append('\n');
        }
        return builder.toString();
    }

    public static String shorterOf(String s1, String s2) {
        if (s2.length() >= s1.length()) {
            return s1;
        }
        return s2;
    }

    public static String minus(String originalString, String removeString) {
        String s2 = originalString.toString();
        int index = s2.indexOf(removeString);
        if (index == -1) {
            return s2;
        }
        int end = index + removeString.length();
        if (s2.length() > end) {
            return s2.substring(0, index) + s2.substring(end);
        }
        return s2.substring(0, index);
    }

    public static String normaliseFileAndLineSeparators(String in) {
        return TextUtil.normaliseLineSeparators(TextUtil.normaliseFileSeparators(in));
    }

    public static String camelToKebabCase(String camelCase) {
        return KEBAB_JOINER.join(Iterables.transform(Arrays.asList(UPPER_CASE.split(camelCase)), TO_LOWERCASE));
    }
}

