/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.util;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;

public class Alignment<T> {
    private final T previousValue;
    private final T currentValue;
    private final Kind kind;

    private Alignment(T previous, T current) {
        this.previousValue = previous;
        this.currentValue = current;
        this.kind = Alignment.kindOf(previous, current);
    }

    public T getPreviousValue() {
        return this.previousValue;
    }

    public T getCurrentValue() {
        return this.currentValue;
    }

    public Kind getKind() {
        return this.kind;
    }

    private static <T> Kind kindOf(T previous, T current) {
        if (previous == current) {
            return Kind.identical;
        }
        if (previous == null) {
            return Kind.added;
        }
        if (current == null) {
            return Kind.removed;
        }
        if (current.equals(previous)) {
            return Kind.identical;
        }
        return Kind.transformed;
    }

    public String toString() {
        switch (this.kind) {
            case added: {
                return "+" + this.currentValue;
            }
            case removed: {
                return "-" + this.previousValue;
            }
            case transformed: {
                return this.previousValue + " -> " + this.currentValue;
            }
            case identical: {
                return this.previousValue.toString();
            }
        }
        throw new IllegalStateException();
    }

    public static <T> List<Alignment<T>> align(T[] current, T[] previous) {
        int currentLen = current.length;
        int previousLen = previous.length;
        int[][] costs = new int[currentLen + 1][previousLen + 1];
        for (int j2 = 0; j2 <= previousLen; ++j2) {
            costs[0][j2] = j2;
        }
        for (int i2 = 1; i2 <= currentLen; ++i2) {
            costs[i2][0] = i2;
            for (int j3 = 1; j3 <= previousLen; ++j3) {
                costs[i2][j3] = Math.min(Math.min(costs[i2 - 1][j3], costs[i2][j3 - 1]) + 1, current[i2 - 1].equals(previous[j3 - 1]) ? costs[i2 - 1][j3 - 1] : costs[i2 - 1][j3 - 1] + 1);
            }
        }
        LinkedList result = Lists.newLinkedList();
        int i3 = currentLen;
        int j4 = previousLen;
        while (i3 > 0 || j4 > 0) {
            int cost = costs[i3][j4];
            if (i3 > 0 && j4 > 0 && cost == (current[i3 - 1].equals(previous[j4 - 1]) ? costs[i3 - 1][j4 - 1] : costs[i3 - 1][j4 - 1] + 1)) {
                T b2;
                T a2;
                if ((a2 = current[--i3]).equals(b2 = previous[--j4])) {
                    result.add(0, new Alignment<T>(b2, a2));
                    continue;
                }
                result.add(0, new Alignment<T>(b2, a2));
                continue;
            }
            if (i3 > 0 && cost == 1 + costs[i3 - 1][j4]) {
                result.add(0, new Alignment<Object>(null, current[--i3]));
                continue;
            }
            if (j4 > 0 && cost == 1 + costs[i3][j4 - 1]) {
                result.add(0, new Alignment<Object>(previous[--j4], null));
                continue;
            }
            throw new IllegalStateException("Unexpected cost matrix");
        }
        return result;
    }

    public static enum Kind {
        added,
        removed,
        transformed,
        identical;

    }
}

