/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import java.util.List;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.TypeConversionException;

public class CompositeNotationConverter<N, T>
implements NotationConverter<N, T> {
    private final List<NotationConverter<? super N, ? extends T>> converters;

    public CompositeNotationConverter(List<NotationConverter<? super N, ? extends T>> converters) {
        this.converters = converters;
    }

    @Override
    public void convert(N notation, NotationConvertResult<? super T> result) throws TypeConversionException {
        for (int i2 = 0; !result.hasResult() && i2 < this.converters.size(); ++i2) {
            NotationConverter<N, T> converter = this.converters.get(i2);
            converter.convert(notation, result);
        }
    }

    @Override
    public void describe(DiagnosticsVisitor visitor) {
        for (NotationConverter<N, T> converter : this.converters) {
            converter.describe(visitor);
        }
    }
}

