/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service;

import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.api.Action;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.service.ContainsServices;
import org.gradle.internal.service.RelevantMethods;
import org.gradle.internal.service.Service;
import org.gradle.internal.service.ServiceCreationException;
import org.gradle.internal.service.ServiceLookupException;
import org.gradle.internal.service.ServiceMethod;
import org.gradle.internal.service.ServiceProvider;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceValidationException;
import org.gradle.internal.service.UnknownServiceException;

public class DefaultServiceRegistry
implements ServiceRegistry,
Closeable,
ContainsServices {
    private static final ServiceRegistry[] NO_PARENTS = new ServiceRegistry[0];
    private static final Service[] NO_DEPENDENTS = new Service[0];
    private static final Object[] NO_PARAMS = new Object[0];
    private final OwnServices ownServices;
    private final ServiceProvider allServices;
    private final ServiceProvider parentServices;
    private final String displayName;
    private final ServiceProvider thisAsServiceProvider;
    private AtomicReference<State> state = new AtomicReference<State>(State.INIT);

    public DefaultServiceRegistry() {
        this((String)null, NO_PARENTS);
    }

    public DefaultServiceRegistry(String displayName) {
        this(displayName, NO_PARENTS);
    }

    public DefaultServiceRegistry(ServiceRegistry ... parents) {
        this((String)null, parents);
    }

    public DefaultServiceRegistry(String displayName, ServiceRegistry ... parents) {
        this.displayName = displayName;
        this.ownServices = new OwnServices();
        if (parents.length == 0) {
            this.parentServices = null;
            this.allServices = this.ownServices;
        } else {
            this.parentServices = DefaultServiceRegistry.setupParentServices(parents);
            this.allServices = new CompositeServiceProvider(new ServiceProvider[]{this.ownServices, this.parentServices});
        }
        this.thisAsServiceProvider = this.allServices;
        this.findProviderMethods(this);
    }

    private static ServiceProvider setupParentServices(ServiceRegistry[] parents) {
        ServiceProvider parentServices;
        if (parents.length == 1) {
            parentServices = DefaultServiceRegistry.toParentServices(parents[0]);
        } else {
            ServiceProvider[] parentServiceProviders = new ServiceProvider[parents.length];
            for (int i2 = 0; i2 < parents.length; ++i2) {
                parentServiceProviders[i2] = DefaultServiceRegistry.toParentServices(parents[i2]);
            }
            parentServices = new CompositeServiceProvider(parentServiceProviders);
        }
        return parentServices;
    }

    @Override
    public ServiceProvider asProvider() {
        return this.thisAsServiceProvider;
    }

    private static ServiceProvider toParentServices(ServiceRegistry serviceRegistry) {
        if (serviceRegistry instanceof ContainsServices) {
            return new ParentServices(((ContainsServices)((Object)serviceRegistry)).asProvider());
        }
        throw new IllegalArgumentException(String.format("Service registry %s cannot be used as a parent for another service registry.", serviceRegistry));
    }

    public static ServiceRegistry create(Object ... providers) {
        DefaultServiceRegistry registry = new DefaultServiceRegistry();
        for (Object provider : providers) {
            registry.addProvider(provider);
        }
        return registry;
    }

    private String getDisplayName() {
        return this.displayName == null ? this.getClass().getSimpleName() : this.displayName;
    }

    public String toString() {
        return this.getDisplayName();
    }

    private void findProviderMethods(Object target) {
        Class<?> type = target.getClass();
        RelevantMethods methods = RelevantMethods.getMethods(type);
        for (ServiceMethod method : methods.decorators) {
            if (this.parentServices == null) {
                throw new ServiceLookupException(String.format("Cannot use decorator method %s.%s() when no parent registry is provided.", type.getSimpleName(), method.getName()));
            }
            this.ownServices.add(new FactoryMethodService(this, target, method));
        }
        for (ServiceMethod method : methods.factories) {
            this.ownServices.add(new FactoryMethodService(this, target, method));
        }
        for (ServiceMethod method : methods.configurers) {
            this.applyConfigureMethod(method, target);
        }
    }

    private void applyConfigureMethod(ServiceMethod method, Object target) {
        Object[] params = new Object[method.getParameterTypes().length];
        for (int i2 = 0; i2 < method.getParameterTypes().length; ++i2) {
            Type paramType = method.getParameterTypes()[i2];
            if (paramType.equals(ServiceRegistration.class)) {
                params[i2] = this.newRegistration();
                continue;
            }
            Service paramProvider = DefaultServiceRegistry.find(paramType, this.allServices);
            if (paramProvider == null) {
                throw new ServiceLookupException(String.format("Cannot configure services using %s.%s() as required service of type %s is not available.", method.getOwner().getSimpleName(), method.getName(), DefaultServiceRegistry.format(paramType)));
            }
            params[i2] = paramProvider.get();
        }
        try {
            method.invoke(target, params);
        }
        catch (Exception e2) {
            throw new ServiceLookupException(String.format("Could not configure services using %s.%s().", method.getOwner().getSimpleName(), method.getName()), e2);
        }
    }

    public void register(Action<? super ServiceRegistration> action) {
        this.assertMutable();
        action.execute(this.newRegistration());
    }

    private void assertMutable() {
        if (this.state.get() != State.INIT) {
            throw new IllegalStateException("Cannot add services to service registry " + this + " as it is no longer mutable");
        }
    }

    private ServiceRegistration newRegistration() {
        return new ServiceRegistration(){

            @Override
            public <T> void add(Class<T> serviceType, T serviceInstance) {
                DefaultServiceRegistry.this.add(serviceType, serviceInstance);
            }

            @Override
            public void add(Class<?> serviceType) {
                DefaultServiceRegistry.this.ownServices.add(new ConstructorService(DefaultServiceRegistry.this, serviceType));
            }

            @Override
            public void addProvider(Object provider) {
                DefaultServiceRegistry.this.addProvider(provider);
            }
        };
    }

    public <T> DefaultServiceRegistry add(Class<T> serviceType, T serviceInstance) {
        this.assertMutable();
        this.ownServices.add(new FixedInstanceService<T>(this, serviceType, serviceInstance));
        return this;
    }

    public DefaultServiceRegistry addProvider(Object provider) {
        this.assertMutable();
        this.findProviderMethods(provider);
        return this;
    }

    @Override
    public void close() {
        this.noLongerMutable();
        if (this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            CompositeStoppable.stoppable(this.allServices).stop();
        }
    }

    private void serviceRequested() {
        this.noLongerMutable();
        if (this.state.get() == State.CLOSED) {
            throw new IllegalStateException(String.format("%s has been closed.", this.getDisplayName()));
        }
    }

    private void noLongerMutable() {
        if (this.state.compareAndSet(State.INIT, State.STARTED)) {
            this.ownServices.noLongerMutable();
        }
    }

    public boolean isClosed() {
        return this.state.get() == State.CLOSED;
    }

    @Override
    public <T> T get(Class<T> serviceType) throws UnknownServiceException, ServiceLookupException {
        return serviceType.cast(this.get((Type)serviceType));
    }

    @Override
    public Object get(Type serviceType) throws UnknownServiceException, ServiceLookupException {
        Object instance = this.find(serviceType);
        if (instance == null) {
            throw new UnknownServiceException(serviceType, String.format("No service of type %s available in %s.", DefaultServiceRegistry.format(serviceType), this.getDisplayName()));
        }
        return instance;
    }

    @Override
    public Object get(Type serviceType, Class<? extends Annotation> annotatedWith) throws UnknownServiceException, ServiceLookupException {
        throw new UnknownServiceException(serviceType, String.format("No service of type %s annotated with @%s available in %s.", DefaultServiceRegistry.format(serviceType), annotatedWith.getSimpleName(), this.getDisplayName()));
    }

    @Override
    public Object find(Type serviceType) throws ServiceLookupException {
        DefaultServiceRegistry.assertValidServiceType(DefaultServiceRegistry.unwrap(serviceType));
        Service provider = this.getService(serviceType);
        return provider == null ? null : provider.get();
    }

    private Service getService(Type serviceType) {
        this.serviceRequested();
        return DefaultServiceRegistry.find(serviceType, this.allServices);
    }

    @Override
    public <T> Factory<T> getFactory(Class<T> type) {
        Factory factory;
        DefaultServiceRegistry.assertValidServiceType(type);
        Service provider = this.getFactoryService(type);
        Factory factory2 = factory = provider == null ? null : (Factory)provider.get();
        if (factory == null) {
            throw new UnknownServiceException(type, String.format("No factory for objects of type %s available in %s.", DefaultServiceRegistry.format(type), this.getDisplayName()));
        }
        return factory;
    }

    private Service getFactoryService(Class<?> serviceType) {
        this.serviceRequested();
        return this.allServices.getFactory(serviceType);
    }

    @Override
    public <T> List<T> getAll(Class<T> serviceType) throws ServiceLookupException {
        DefaultServiceRegistry.assertValidServiceType(serviceType);
        ArrayList services = new ArrayList();
        this.serviceRequested();
        this.allServices.getAll(serviceType, new InstanceUnpackingVisitor(serviceType, services));
        return services;
    }

    @Override
    public <T> T newInstance(Class<T> type) {
        return this.getFactory(type).create();
    }

    private static Class<?> unwrap(Type type) {
        WildcardType wildcardType;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof WildcardType && (wildcardType = (WildcardType)type).getUpperBounds()[0] instanceof Class && wildcardType.getLowerBounds().length == 0) {
            return (Class)wildcardType.getUpperBounds()[0];
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        return (Class)parameterizedType.getRawType();
    }

    private static Service find(Type serviceType, ServiceProvider serviceProvider) {
        if (serviceType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)serviceType;
            Type rawType = parameterizedType.getRawType();
            if (rawType.equals(Factory.class)) {
                Type typeArg = parameterizedType.getActualTypeArguments()[0];
                return DefaultServiceRegistry.getFactoryService(typeArg, serviceProvider);
            }
            if (rawType instanceof Class) {
                if (((Class)rawType).isAssignableFrom(List.class)) {
                    Type typeArg = parameterizedType.getActualTypeArguments()[0];
                    return DefaultServiceRegistry.getCollectionService(typeArg, serviceProvider);
                }
                DefaultServiceRegistry.assertValidServiceType((Class)rawType);
                return serviceProvider.getService(serviceType);
            }
        }
        if (serviceType instanceof Class) {
            DefaultServiceRegistry.assertValidServiceType((Class)serviceType);
            return serviceProvider.getService(serviceType);
        }
        throw new ServiceValidationException(String.format("Locating services with type %s is not supported.", DefaultServiceRegistry.format(serviceType)));
    }

    private static Service getFactoryService(Type type, ServiceProvider serviceProvider) {
        if (type instanceof Class) {
            return serviceProvider.getFactory((Class)type);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            if (wildcardType.getLowerBounds().length == 1 && wildcardType.getUpperBounds().length == 1 && wildcardType.getLowerBounds()[0] instanceof Class && wildcardType.getUpperBounds()[0].equals(Object.class)) {
                return serviceProvider.getFactory((Class)wildcardType.getLowerBounds()[0]);
            }
            if (wildcardType.getLowerBounds().length == 0 && wildcardType.getUpperBounds().length == 1 && wildcardType.getUpperBounds()[0] instanceof Class) {
                return serviceProvider.getFactory((Class)wildcardType.getUpperBounds()[0]);
            }
        }
        throw new ServiceValidationException(String.format("Locating services with type %s is not supported.", DefaultServiceRegistry.format(type)));
    }

    private static Service getCollectionService(Type elementType, ServiceProvider serviceProvider) {
        WildcardType wildcardType;
        if (elementType instanceof Class) {
            Class elementClass = (Class)elementType;
            return DefaultServiceRegistry.getCollectionService(elementClass, serviceProvider);
        }
        if (elementType instanceof WildcardType && (wildcardType = (WildcardType)elementType).getUpperBounds()[0] instanceof Class && wildcardType.getLowerBounds().length == 0) {
            Class elementClass = (Class)wildcardType.getUpperBounds()[0];
            return DefaultServiceRegistry.getCollectionService(elementClass, serviceProvider);
        }
        throw new ServiceValidationException(String.format("Locating services with type %s is not supported.", DefaultServiceRegistry.format(elementType)));
    }

    private static Service getCollectionService(Class<?> elementClass, ServiceProvider serviceProvider) {
        DefaultServiceRegistry.assertValidServiceType(elementClass);
        ArrayList<Service> providers = new ArrayList<Service>();
        serviceProvider.getAll(elementClass, new CollectingVisitor(providers));
        ArrayList<Object> services = new ArrayList<Object>(providers.size());
        for (Service service : providers) {
            services.add(service.get());
        }
        return new CollectionService(elementClass, services, providers);
    }

    private static boolean isSatisfiedBy(Type expected, Type actual) {
        if (expected.equals(actual)) {
            return true;
        }
        if (expected instanceof Class) {
            return DefaultServiceRegistry.isSatisfiedBy((Class)expected, actual);
        }
        if (expected instanceof ParameterizedType) {
            return DefaultServiceRegistry.isSatisfiedBy((ParameterizedType)expected, actual);
        }
        return false;
    }

    private static boolean isSatisfiedBy(Class<?> expectedClass, Type actual) {
        if (actual instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)actual;
            if (parameterizedType.getRawType() instanceof Class) {
                return expectedClass.isAssignableFrom((Class)parameterizedType.getRawType());
            }
        } else if (actual instanceof Class) {
            Class other = (Class)actual;
            return expectedClass.isAssignableFrom(other);
        }
        return false;
    }

    private static boolean isSatisfiedBy(ParameterizedType expectedParameterizedType, Type actual) {
        Type expectedRawType = expectedParameterizedType.getRawType();
        if (actual instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)actual;
            if (!DefaultServiceRegistry.isSatisfiedBy(expectedRawType, parameterizedType.getRawType())) {
                return false;
            }
            Type[] expectedTypeArguments = expectedParameterizedType.getActualTypeArguments();
            for (int i2 = 0; i2 < parameterizedType.getActualTypeArguments().length; ++i2) {
                Type type = parameterizedType.getActualTypeArguments()[i2];
                if (DefaultServiceRegistry.isSatisfiedBy(expectedTypeArguments[i2], type)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static void assertValidServiceType(Class<?> serviceClass) {
        if (serviceClass.isArray()) {
            throw new ServiceValidationException("Locating services with array type is not supported.");
        }
        if (serviceClass.isAnnotation()) {
            throw new ServiceValidationException("Locating services with annotation type is not supported.");
        }
        if (serviceClass == Object.class) {
            throw new ServiceValidationException("Locating services with type Object is not supported.");
        }
    }

    private static String format(Type type) {
        if (type instanceof Class) {
            Class aClass = (Class)type;
            Class<?> enclosingClass = aClass.getEnclosingClass();
            if (enclosingClass != null) {
                return DefaultServiceRegistry.format(enclosingClass) + "$" + aClass.getSimpleName();
            }
            return aClass.getSimpleName();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            StringBuilder builder = new StringBuilder();
            builder.append(DefaultServiceRegistry.format(parameterizedType.getRawType()));
            builder.append("<");
            for (int i2 = 0; i2 < parameterizedType.getActualTypeArguments().length; ++i2) {
                Type typeParam = parameterizedType.getActualTypeArguments()[i2];
                if (i2 > 0) {
                    builder.append(", ");
                }
                builder.append(DefaultServiceRegistry.format(typeParam));
            }
            builder.append(">");
            return builder.toString();
        }
        return type.toString();
    }

    private class ThisAsService
    implements ServiceProvider,
    Service {
        private ThisAsService() {
        }

        @Override
        public Service getService(Type serviceType) {
            if (serviceType.equals(ServiceRegistry.class)) {
                return this;
            }
            return null;
        }

        @Override
        public Service getFactory(Class<?> type) {
            return null;
        }

        @Override
        public ServiceProvider.Visitor getAll(Class<?> serviceType, ServiceProvider.Visitor visitor) {
            if (serviceType.equals(ServiceRegistry.class)) {
                visitor.visit(this);
            }
            return visitor;
        }

        @Override
        public void stop() {
        }

        @Override
        public String getDisplayName() {
            return "ServiceRegistry " + DefaultServiceRegistry.this.getDisplayName();
        }

        @Override
        public Object get() {
            return DefaultServiceRegistry.this;
        }

        @Override
        public void requiredBy(ServiceProvider serviceProvider) {
        }
    }

    private static class CollectionService
    implements Service {
        private final Type typeArg;
        private final List<Object> services;
        private final List<Service> providers;

        public CollectionService(Type typeArg, List<Object> services, List<Service> providers) {
            this.typeArg = typeArg;
            this.services = services;
            this.providers = providers;
        }

        @Override
        public String getDisplayName() {
            return "services with type " + this.typeArg;
        }

        @Override
        public Object get() {
            return this.services;
        }

        @Override
        public void requiredBy(ServiceProvider serviceProvider) {
            for (Service service : this.providers) {
                service.requiredBy(serviceProvider);
            }
        }
    }

    private static class ParentServices
    implements ServiceProvider {
        private final ServiceProvider parent;

        private ParentServices(ServiceProvider parent) {
            this.parent = parent;
        }

        @Override
        public Service getFactory(Class<?> serviceType) {
            return this.parent.getFactory(serviceType);
        }

        @Override
        public Service getService(Type serviceType) {
            return this.parent.getService(serviceType);
        }

        @Override
        public ServiceProvider.Visitor getAll(Class<?> serviceType, ServiceProvider.Visitor visitor) {
            return this.parent.getAll(serviceType, visitor);
        }

        @Override
        public void stop() {
        }
    }

    private static class CompositeServiceProvider
    implements ServiceProvider {
        private final ServiceProvider[] serviceProviders;

        private CompositeServiceProvider(ServiceProvider ... serviceProviders) {
            this.serviceProviders = serviceProviders;
        }

        @Override
        public Service getService(Type serviceType) {
            for (ServiceProvider serviceProvider : this.serviceProviders) {
                Service service = serviceProvider.getService(serviceType);
                if (service == null) continue;
                return service;
            }
            return null;
        }

        @Override
        public Service getFactory(Class<?> type) {
            for (ServiceProvider serviceProvider : this.serviceProviders) {
                Service factory = serviceProvider.getFactory(type);
                if (factory == null) continue;
                return factory;
            }
            return null;
        }

        @Override
        public ServiceProvider.Visitor getAll(Class<?> serviceType, ServiceProvider.Visitor visitor) {
            for (ServiceProvider serviceProvider : this.serviceProviders) {
                visitor = serviceProvider.getAll(serviceType, visitor);
            }
            return visitor;
        }

        @Override
        public void stop() {
            try {
                CompositeStoppable.stoppable(Arrays.asList(this.serviceProviders)).stop();
            }
            finally {
                Arrays.fill(this.serviceProviders, null);
            }
        }
    }

    private static class ConstructorService
    extends FactoryService {
        private final Constructor<?> constructor;

        private ConstructorService(DefaultServiceRegistry owner, Class<?> serviceType) {
            super(owner, serviceType);
            Constructor<?>[] constructors = serviceType.getDeclaredConstructors();
            Constructor<?> match = null;
            for (Constructor<?> constructor : constructors) {
                if (Modifier.isPrivate(constructor.getModifiers())) continue;
                if (match != null) {
                    throw new ServiceValidationException(String.format("Expected a single non-private constructor for %s.", DefaultServiceRegistry.format(serviceType)));
                }
                match = constructor;
            }
            if (match == null) {
                throw new ServiceValidationException(String.format("Expected a single non-private constructor for %s.", DefaultServiceRegistry.format(serviceType)));
            }
            this.constructor = match;
        }

        @Override
        protected Type[] getParameterTypes() {
            return this.constructor.getGenericParameterTypes();
        }

        @Override
        protected Member getFactory() {
            return this.constructor;
        }

        @Override
        protected Object invokeMethod(Object[] params) {
            try {
                return this.constructor.newInstance(params);
            }
            catch (InvocationTargetException e2) {
                throw new ServiceCreationException(String.format("Could not create service of type %s.", DefaultServiceRegistry.format(this.serviceType)), e2.getCause());
            }
            catch (Exception e3) {
                throw new ServiceCreationException(String.format("Could not create service of type %s.", DefaultServiceRegistry.format(this.serviceType)), e3);
            }
        }

        @Override
        public String getDisplayName() {
            return "Service " + DefaultServiceRegistry.format(this.serviceType);
        }
    }

    private static class FixedInstanceService<T>
    extends SingletonService {
        public FixedInstanceService(DefaultServiceRegistry owner, Class<T> serviceType, T serviceInstance) {
            super(owner, serviceType);
            this.setInstance(serviceInstance);
        }

        @Override
        public String getDisplayName() {
            return "Service " + DefaultServiceRegistry.format(this.serviceType) + " with implementation " + this.getInstance();
        }

        @Override
        protected Object create() {
            throw new UnsupportedOperationException();
        }
    }

    private static class FactoryMethodService
    extends FactoryService {
        private final ServiceMethod method;
        private Object target;

        public FactoryMethodService(DefaultServiceRegistry owner, Object target, ServiceMethod method) {
            super(owner, method.getServiceType());
            this.target = target;
            this.method = method;
        }

        @Override
        public String getDisplayName() {
            return "Service " + DefaultServiceRegistry.format(this.method.getServiceType()) + " at " + this.method.getOwner().getSimpleName() + "." + this.method.getName() + "()";
        }

        @Override
        protected Type[] getParameterTypes() {
            return this.method.getParameterTypes();
        }

        @Override
        protected Member getFactory() {
            return this.method.getMethod();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object invokeMethod(Object[] params) {
            Object result;
            try {
                result = this.method.invoke(this.target, params);
            }
            catch (Exception e2) {
                throw new ServiceCreationException(String.format("Could not create service of type %s using %s.%s().", DefaultServiceRegistry.format(this.serviceType), this.method.getOwner().getSimpleName(), this.method.getName()), e2);
            }
            try {
                if (result == null) {
                    throw new ServiceCreationException(String.format("Could not create service of type %s using %s.%s() as this method returned null.", DefaultServiceRegistry.format(this.serviceType), this.method.getOwner().getSimpleName(), this.method.getName()));
                }
                Object object = result;
                return object;
            }
            finally {
                this.target = null;
            }
        }
    }

    private static abstract class FactoryService
    extends SingletonService {
        private Service[] paramServices;
        private Service decorates;

        protected FactoryService(DefaultServiceRegistry owner, Type serviceType) {
            super(owner, serviceType);
        }

        protected abstract Type[] getParameterTypes();

        protected abstract Member getFactory();

        @Override
        protected void bind() {
            Type[] parameterTypes = this.getParameterTypes();
            if (parameterTypes.length == 0) {
                this.paramServices = NO_DEPENDENTS;
                return;
            }
            this.paramServices = new Service[parameterTypes.length];
            for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
                Service paramProvider;
                Type paramType = parameterTypes[i2];
                if (paramType.equals(this.serviceType)) {
                    paramProvider = DefaultServiceRegistry.find(paramType, this.owner.parentServices);
                    if (paramProvider == null) {
                        throw new ServiceCreationException(String.format("Cannot create service of type %s using %s.%s() as required service of type %s is not available in parent registries.", DefaultServiceRegistry.format(this.serviceType), this.getFactory().getDeclaringClass().getSimpleName(), this.getFactory().getName(), DefaultServiceRegistry.format(paramType)));
                    }
                    this.paramServices[i2] = paramProvider;
                    this.decorates = paramProvider;
                    continue;
                }
                try {
                    paramProvider = DefaultServiceRegistry.find(paramType, this.owner.allServices);
                }
                catch (ServiceLookupException e2) {
                    throw new ServiceCreationException(String.format("Cannot create service of type %s using %s.%s() as there is a problem with parameter #%s of type %s.", DefaultServiceRegistry.format(this.serviceType), this.getFactory().getDeclaringClass().getSimpleName(), this.getFactory().getName(), i2 + 1, DefaultServiceRegistry.format(paramType)), e2);
                }
                if (paramProvider == null) {
                    throw new ServiceCreationException(String.format("Cannot create service of type %s using %s.%s() as required service of type %s is not available.", DefaultServiceRegistry.format(this.serviceType), this.getFactory().getDeclaringClass().getSimpleName(), this.getFactory().getName(), DefaultServiceRegistry.format(paramType)));
                }
                this.paramServices[i2] = paramProvider;
                paramProvider.requiredBy(this);
            }
        }

        @Override
        protected Object create() {
            Object[] params = this.assembleParameters();
            Object result = this.invokeMethod(params);
            this.paramServices = null;
            return result;
        }

        private Object[] assembleParameters() {
            if (this.paramServices == NO_DEPENDENTS) {
                return NO_PARAMS;
            }
            Object[] params = new Object[this.paramServices.length];
            for (int i2 = 0; i2 < this.paramServices.length; ++i2) {
                Service paramProvider = this.paramServices[i2];
                params[i2] = paramProvider.get();
            }
            return params;
        }

        @Override
        public ServiceProvider.Visitor getAll(Class<?> serviceType, final ServiceProvider.Visitor visitor) {
            super.getAll(serviceType, visitor);
            if (this.decorates == null) {
                return visitor;
            }
            return new ServiceProvider.Visitor(){

                @Override
                public void visit(Service service) {
                    if (service != FactoryService.this.decorates) {
                        visitor.visit(service);
                    }
                }
            };
        }

        protected abstract Object invokeMethod(Object[] var1);
    }

    private static abstract class SingletonService
    extends ManagedObjectServiceProvider<Object>
    implements Service {
        final Type serviceType;
        final Class serviceClass;
        BindState state = BindState.UNBOUND;
        Class factoryElementType;

        SingletonService(DefaultServiceRegistry owner, Type serviceType) {
            super(owner);
            this.serviceType = serviceType;
            this.serviceClass = DefaultServiceRegistry.unwrap(serviceType);
        }

        public String toString() {
            return this.getDisplayName();
        }

        @Override
        public Object get() {
            return this.getInstance();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Service prepare() {
            if (this.state == BindState.BOUND) {
                return this;
            }
            SingletonService singletonService = this;
            synchronized (singletonService) {
                if (this.state == BindState.BINDING) {
                    throw new ServiceValidationException("Cycle in dependencies of " + this.getDisplayName() + " detected");
                }
                if (this.state == BindState.UNBOUND) {
                    this.state = BindState.BINDING;
                    try {
                        this.bind();
                        this.state = BindState.BOUND;
                    }
                    catch (RuntimeException e2) {
                        this.state = BindState.UNBOUND;
                        throw e2;
                    }
                }
                return this;
            }
        }

        protected void bind() {
        }

        @Override
        public Service getService(Type serviceType) {
            if (!DefaultServiceRegistry.isSatisfiedBy(serviceType, this.serviceType)) {
                return null;
            }
            return this.prepare();
        }

        @Override
        public ServiceProvider.Visitor getAll(Class<?> serviceType, ServiceProvider.Visitor visitor) {
            if (serviceType.isAssignableFrom(this.serviceClass)) {
                visitor.visit(this.prepare());
            }
            return visitor;
        }

        @Override
        public Service getFactory(Class<?> elementType) {
            if (!this.isFactory(this.serviceType, elementType)) {
                return null;
            }
            return this.prepare();
        }

        private boolean isFactory(Type type, Class<?> elementType) {
            Type actualType;
            ParameterizedType parameterizedType;
            Class c2 = DefaultServiceRegistry.unwrap(type);
            if (!Factory.class.isAssignableFrom(c2)) {
                return false;
            }
            if (this.factoryElementType != null) {
                return elementType.isAssignableFrom(this.factoryElementType);
            }
            if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType().equals(Factory.class) && (actualType = parameterizedType.getActualTypeArguments()[0]) instanceof Class) {
                this.factoryElementType = (Class)actualType;
                return elementType.isAssignableFrom((Class)actualType);
            }
            for (Type interfaceType : c2.getGenericInterfaces()) {
                if (!this.isFactory(interfaceType, elementType)) continue;
                return true;
            }
            return false;
        }

        private static enum BindState {
            UNBOUND,
            BINDING,
            BOUND;

        }
    }

    private static abstract class ManagedObjectServiceProvider<T>
    implements ServiceProvider {
        protected final DefaultServiceRegistry owner;
        private final Queue<ServiceProvider> dependents = new ConcurrentLinkedQueue<ServiceProvider>();
        private volatile T instance;

        protected ManagedObjectServiceProvider(DefaultServiceRegistry owner) {
            this.owner = owner;
        }

        protected final void setInstance(T instance) {
            this.instance = instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final T getInstance() {
            T result = this.instance;
            if (result == null) {
                ManagedObjectServiceProvider managedObjectServiceProvider = this;
                synchronized (managedObjectServiceProvider) {
                    result = this.instance;
                    if (result == null) {
                        result = this.instance = this.create();
                        assert (this.instance != null) : String.format("create() of %s returned null", this.toString());
                    }
                }
            }
            return result;
        }

        protected abstract T create();

        public final void requiredBy(ServiceProvider serviceProvider) {
            if (this.fromSameRegistry(serviceProvider)) {
                this.dependents.add(serviceProvider);
            }
        }

        private boolean fromSameRegistry(ServiceProvider serviceProvider) {
            return serviceProvider instanceof ManagedObjectServiceProvider && ((ManagedObjectServiceProvider)serviceProvider).owner == this.owner;
        }

        @Override
        public final synchronized void stop() {
            try {
                if (this.instance != null) {
                    CompositeStoppable.stoppable(this.dependents).add((Object)this.instance).stop();
                }
            }
            finally {
                this.dependents.clear();
                this.instance = null;
            }
        }
    }

    private class OwnServices
    implements ServiceProvider {
        private final Map<Class<?>, List<ServiceProvider>> providersByType = new HashMap(16, 0.5f);
        private final CompositeStoppable stoppable = CompositeStoppable.stoppable(new Object[0]);
        private ProviderAnalyser analyser = new ProviderAnalyser();

        public OwnServices() {
            this.providersByType.put(ServiceRegistry.class, Collections.singletonList(new ThisAsService()));
        }

        @Override
        public Service getFactory(Class<?> type) {
            List<ServiceProvider> serviceProviders = this.getProviders(Factory.class);
            if (serviceProviders.isEmpty()) {
                return null;
            }
            if (serviceProviders.size() == 1) {
                return serviceProviders.get(0).getFactory(type);
            }
            ArrayList<Service> services = new ArrayList<Service>(serviceProviders.size());
            for (ServiceProvider serviceProvider : serviceProviders) {
                Service service = serviceProvider.getFactory(type);
                if (service == null) continue;
                services.add(service);
            }
            if (services.isEmpty()) {
                return null;
            }
            if (services.size() == 1) {
                return (Service)services.get(0);
            }
            TreeSet<String> descriptions = new TreeSet<String>();
            for (Service candidate : services) {
                descriptions.add(candidate.getDisplayName());
            }
            Formatter formatter = new Formatter();
            formatter.format("Multiple factories for objects of type %s available in %s:", DefaultServiceRegistry.format(type), DefaultServiceRegistry.this.getDisplayName());
            for (String description : descriptions) {
                formatter.format("%n   - %s", description);
            }
            throw new ServiceLookupException(formatter.toString());
        }

        @Override
        public Service getService(Type type) {
            List<ServiceProvider> serviceProviders = this.getProviders(DefaultServiceRegistry.unwrap(type));
            if (serviceProviders.isEmpty()) {
                return null;
            }
            if (serviceProviders.size() == 1) {
                return serviceProviders.get(0).getService(type);
            }
            ArrayList<Service> services = new ArrayList<Service>(serviceProviders.size());
            for (ServiceProvider serviceProvider : serviceProviders) {
                Service service = serviceProvider.getService(type);
                if (service == null) continue;
                services.add(service);
            }
            if (services.isEmpty()) {
                return null;
            }
            if (services.size() == 1) {
                return (Service)services.get(0);
            }
            TreeSet<String> descriptions = new TreeSet<String>();
            for (Service candidate : services) {
                descriptions.add(candidate.getDisplayName());
            }
            Formatter formatter = new Formatter();
            formatter.format("Multiple services of type %s available in %s:", DefaultServiceRegistry.format(type), DefaultServiceRegistry.this.getDisplayName());
            for (String description : descriptions) {
                formatter.format("%n   - %s", description);
            }
            throw new ServiceLookupException(formatter.toString());
        }

        private List<ServiceProvider> getProviders(Class<?> type) {
            List<ServiceProvider> providers = this.providersByType.get(type);
            return providers == null ? Collections.emptyList() : providers;
        }

        @Override
        public ServiceProvider.Visitor getAll(Class<?> serviceType, ServiceProvider.Visitor visitor) {
            for (ServiceProvider serviceProvider : this.getProviders(serviceType)) {
                visitor = serviceProvider.getAll(serviceType, visitor);
            }
            return visitor;
        }

        @Override
        public void stop() {
            this.stoppable.stop();
        }

        public void add(ServiceProvider serviceProvider) {
            DefaultServiceRegistry.this.assertMutable();
            if (!(serviceProvider instanceof SingletonService)) {
                throw new UnsupportedOperationException("Unsupported service provider type: " + serviceProvider);
            }
            this.stoppable.add((Object)serviceProvider);
            this.analyser.addProviderForClassHierarchy(((SingletonService)serviceProvider).serviceClass, serviceProvider);
        }

        public void noLongerMutable() {
            this.analyser = null;
        }

        private class ProviderAnalyser {
            private Set<Class<?>> seen = new HashSet(4, 0.5f);

            private ProviderAnalyser() {
            }

            public void addProviderForClassHierarchy(Class<?> serviceType, ServiceProvider serviceProvider) {
                this.analyseType(serviceType, serviceProvider);
                this.seen.clear();
            }

            private void analyseType(Class<?> type, ServiceProvider serviceProvider) {
                if (type == null || type == Object.class) {
                    return;
                }
                if (this.seen.add(type)) {
                    if (type.equals(ServiceRegistry.class)) {
                        throw new IllegalArgumentException("Cannot define a service of type ServiceRegistry: " + serviceProvider);
                    }
                    this.putServiceType(type, serviceProvider);
                    this.analyseType(type.getSuperclass(), serviceProvider);
                    for (Class<?> iface : type.getInterfaces()) {
                        this.analyseType(iface, serviceProvider);
                    }
                }
            }

            private void putServiceType(Class<?> type, ServiceProvider serviceProvider) {
                ArrayList<ServiceProvider> serviceProviders = (ArrayList<ServiceProvider>)OwnServices.this.providersByType.get(type);
                if (serviceProviders == null) {
                    serviceProviders = new ArrayList<ServiceProvider>(2);
                    OwnServices.this.providersByType.put(type, serviceProviders);
                }
                serviceProviders.add(serviceProvider);
            }
        }
    }

    private static class CollectingVisitor
    implements ServiceProvider.Visitor {
        private final List<Service> delegate;

        private CollectingVisitor(List<Service> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void visit(Service service) {
            this.delegate.add(service);
        }
    }

    private static class InstanceUnpackingVisitor<T>
    implements ServiceProvider.Visitor {
        private final Class<T> serviceType;
        private final List<T> delegate;

        private InstanceUnpackingVisitor(Class<T> serviceType, List<T> delegate) {
            this.serviceType = serviceType;
            this.delegate = delegate;
        }

        @Override
        public void visit(Service service) {
            this.delegate.add(this.serviceType.cast(service.get()));
        }
    }

    private static enum State {
        INIT,
        STARTED,
        CLOSED;

    }
}

