/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resources;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.gradle.api.Action;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLockRegistry;

public abstract class AbstractResourceLockRegistry<K, T extends ResourceLock>
implements ResourceLockRegistry {
    private final Cache<K, T> resourceLocks = CacheBuilder.newBuilder().weakValues().build();
    private final Multimap<Long, ResourceLock> threadResourceLockMap = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    private final ResourceLockCoordinationService coordinationService;

    public AbstractResourceLockRegistry(ResourceLockCoordinationService coordinationService) {
        this.coordinationService = coordinationService;
    }

    protected T getOrRegisterResourceLock(final K key, final ResourceLockProducer<K, T> producer) {
        try {
            return (T)((ResourceLock)this.resourceLocks.get(key, new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return AbstractResourceLockRegistry.this.createResourceLock(key, producer);
                }
            }));
        }
        catch (ExecutionException e2) {
            throw UncheckedException.throwAsUncheckedException(e2);
        }
    }

    protected T createResourceLock(K key, ResourceLockProducer<K, T> producer) {
        return producer.create(key, this.coordinationService, this.getLockAction(), this.getUnlockAction());
    }

    @Override
    public Collection<? extends ResourceLock> getResourceLocksByCurrentThread() {
        Long threadId = Thread.currentThread().getId();
        return ImmutableList.copyOf((Collection)this.threadResourceLockMap.get((Object)threadId));
    }

    @Override
    public boolean hasOpenLocks() {
        for (ResourceLock resourceLock : this.resourceLocks.asMap().values()) {
            if (!resourceLock.isLocked()) continue;
            return true;
        }
        return false;
    }

    private Action<ResourceLock> getLockAction() {
        return new Action<ResourceLock>(){

            @Override
            public void execute(ResourceLock resourceLock) {
                AbstractResourceLockRegistry.this.associateResourceLock(resourceLock);
            }
        };
    }

    private Action<ResourceLock> getUnlockAction() {
        return new Action<ResourceLock>(){

            @Override
            public void execute(ResourceLock resourceLock) {
                AbstractResourceLockRegistry.this.unassociateResourceLock(resourceLock);
            }
        };
    }

    public void associateResourceLock(ResourceLock resourceLock) {
        this.threadResourceLockMap.put((Object)Thread.currentThread().getId(), (Object)resourceLock);
    }

    public void unassociateResourceLock(ResourceLock resourceLock) {
        this.threadResourceLockMap.remove((Object)Thread.currentThread().getId(), (Object)resourceLock);
    }

    public static interface ResourceLockProducer<K, T extends ResourceLock> {
        public T create(K var1, ResourceLockCoordinationService var2, Action<ResourceLock> var3, Action<ResourceLock> var4);
    }
}

