/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import org.gradle.api.resources.MissingResourceException;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.hash.PrimitiveHasher;
import org.gradle.internal.resource.ResourceLocation;
import org.gradle.internal.resource.TextResource;

public class CachingTextResource
implements TextResource {
    private static final HashCode SIGNATURE = Hashing.signature(CachingTextResource.class);
    private final TextResource resource;
    private String content;
    private HashCode contentHash;

    public CachingTextResource(TextResource resource) {
        this.resource = resource;
    }

    @Override
    public String getDisplayName() {
        return this.resource.getDisplayName();
    }

    @Override
    public ResourceLocation getLocation() {
        return this.resource.getLocation();
    }

    @Override
    public File getFile() {
        return this.resource.getFile();
    }

    @Override
    public Charset getCharset() {
        return this.resource.getCharset();
    }

    @Override
    public boolean isContentCached() {
        return true;
    }

    @Override
    public boolean getExists() {
        try {
            this.maybeFetch();
        }
        catch (MissingResourceException e2) {
            return false;
        }
        return true;
    }

    @Override
    public boolean getHasEmptyContent() {
        this.maybeFetch();
        return this.content.length() == 0;
    }

    @Override
    public String getText() {
        this.maybeFetch();
        return this.content;
    }

    @Override
    public HashCode getContentHash() throws ResourceException {
        this.maybeFetch();
        return this.contentHash;
    }

    @Override
    public Reader getAsReader() {
        this.maybeFetch();
        return new StringReader(this.content);
    }

    private void maybeFetch() {
        if (this.content == null) {
            this.content = this.resource.getText();
            PrimitiveHasher hasher = Hashing.newPrimitiveHasher();
            hasher.putHash(SIGNATURE);
            hasher.putString((CharSequence)this.content);
            this.contentHash = hasher.hash();
        }
    }
}

