/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.remote.internal.hub;

import java.util.List;
import org.gradle.internal.remote.internal.hub.MethodArgsSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SerializerRegistry;

class DefaultMethodArgsSerializer
implements MethodArgsSerializer {
    private static final Object[] ZERO_ARGS = new Object[0];
    private final List<SerializerRegistry> serializerRegistries;
    private final MethodArgsSerializer defaultArgsSerializer;

    public DefaultMethodArgsSerializer(List<SerializerRegistry> serializerRegistries, MethodArgsSerializer defaultArgsSerializer) {
        this.serializerRegistries = serializerRegistries;
        this.defaultArgsSerializer = defaultArgsSerializer;
    }

    @Override
    public Serializer<Object[]> forTypes(Class<?>[] types) {
        if (types.length == 0) {
            return new EmptyArraySerializer();
        }
        SerializerRegistry selected = null;
        for (SerializerRegistry serializerRegistry : this.serializerRegistries) {
            if (!serializerRegistry.canSerialize(types[0])) continue;
            selected = serializerRegistry;
            break;
        }
        if (selected == null) {
            return this.defaultArgsSerializer.forTypes(types);
        }
        Serializer[] serializers = new Serializer[types.length];
        for (int i2 = 0; i2 < types.length; ++i2) {
            Class<?> type = types[i2];
            serializers[i2] = selected.build(type);
        }
        return new ArraySerializer(serializers);
    }

    private static class EmptyArraySerializer
    implements Serializer<Object[]> {
        private EmptyArraySerializer() {
        }

        @Override
        public Object[] read(Decoder decoder) {
            return ZERO_ARGS;
        }

        @Override
        public void write(Encoder encoder, Object[] value) {
        }
    }

    private static class ArraySerializer
    implements Serializer<Object[]> {
        private final Serializer<Object>[] serializers;

        ArraySerializer(Serializer<Object>[] serializers) {
            this.serializers = serializers;
        }

        @Override
        public Object[] read(Decoder decoder) throws Exception {
            Object[] result = new Object[this.serializers.length];
            for (int i2 = 0; i2 < this.serializers.length; ++i2) {
                result[i2] = this.serializers[i2].read(decoder);
            }
            return result;
        }

        @Override
        public void write(Encoder encoder, Object[] value) throws Exception {
            for (int i2 = 0; i2 < value.length; ++i2) {
                this.serializers[i2].write(encoder, value[i2]);
            }
        }
    }
}

