/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.process;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.gradle.api.Transformer;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.process.ArgCollector;

public class ArgWriter
implements ArgCollector {
    private static final Pattern WHITESPACE = Pattern.compile("\\s");
    private static final Pattern WHITESPACE_OR_HASH = Pattern.compile("\\s|#");
    private final PrintWriter writer;
    private final boolean backslashEscape;
    private final Pattern quotablePattern;

    private ArgWriter(PrintWriter writer, boolean backslashEscape, Pattern quotablePattern) {
        this.writer = writer;
        this.backslashEscape = backslashEscape;
        this.quotablePattern = quotablePattern;
    }

    public static ArgWriter unixStyle(PrintWriter writer) {
        return new ArgWriter(writer, true, WHITESPACE);
    }

    public static Transformer<ArgWriter, PrintWriter> unixStyleFactory() {
        return new Transformer<ArgWriter, PrintWriter>(){

            @Override
            public ArgWriter transform(PrintWriter original) {
                return ArgWriter.unixStyle(original);
            }
        };
    }

    public static ArgWriter javaStyle(PrintWriter writer) {
        return new ArgWriter(writer, true, WHITESPACE_OR_HASH);
    }

    public static Transformer<ArgWriter, PrintWriter> javaStyleFactory() {
        return new Transformer<ArgWriter, PrintWriter>(){

            @Override
            public ArgWriter transform(PrintWriter original) {
                return ArgWriter.javaStyle(original);
            }
        };
    }

    public static ArgWriter windowsStyle(PrintWriter writer) {
        return new ArgWriter(writer, false, WHITESPACE);
    }

    public static Transformer<ArgWriter, PrintWriter> windowsStyleFactory() {
        return new Transformer<ArgWriter, PrintWriter>(){

            @Override
            public ArgWriter transform(PrintWriter original) {
                return ArgWriter.windowsStyle(original);
            }
        };
    }

    public static Transformer<List<String>, List<String>> argsFileGenerator(final File argsFile, final Transformer<ArgWriter, PrintWriter> argWriterFactory) {
        return new Transformer<List<String>, List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> transform(List<String> args) {
                if (args.isEmpty()) {
                    return args;
                }
                argsFile.getParentFile().mkdirs();
                try {
                    PrintWriter writer = new PrintWriter(argsFile);
                    try {
                        ArgWriter argWriter = (ArgWriter)argWriterFactory.transform(writer);
                        argWriter.args(args);
                    }
                    finally {
                        writer.close();
                    }
                }
                catch (IOException e2) {
                    throw new UncheckedIOException(String.format("Could not write options file '%s'.", argsFile.getAbsolutePath()), e2);
                }
                return Collections.singletonList("@" + argsFile.getAbsolutePath());
            }
        };
    }

    @Override
    public ArgWriter args(Object ... args) {
        for (int i2 = 0; i2 < args.length; ++i2) {
            Object arg = args[i2];
            if (i2 > 0) {
                this.writer.print(' ');
            }
            String str = arg.toString();
            if (this.backslashEscape) {
                str = str.replace("\\", "\\\\").replace("\"", "\\\"");
            }
            if (str.isEmpty()) {
                this.writer.print("\"\"");
                continue;
            }
            if (this.needsQuoting(str)) {
                this.writer.print('\"');
                this.writer.print(str);
                this.writer.print('\"');
                continue;
            }
            this.writer.print(str);
        }
        this.writer.println();
        return this;
    }

    private boolean needsQuoting(String str) {
        return this.quotablePattern.matcher(str).find();
    }

    @Override
    public ArgCollector args(Iterable<?> args) {
        for (Object arg : args) {
            this.args(arg);
        }
        return this;
    }
}

