/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.jna;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.Map;
import org.gradle.internal.nativeintegration.EnvironmentModificationResult;
import org.gradle.internal.nativeintegration.NativeIntegrationException;
import org.gradle.internal.nativeintegration.NativeIntegrationUnavailableException;
import org.gradle.internal.nativeintegration.ProcessEnvironment;
import org.gradle.internal.os.OperatingSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsupportedEnvironment
implements ProcessEnvironment {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnsupportedEnvironment.class);
    private final Long pid = this.extractPIDFromRuntimeMXBeanName();

    private Long extractPIDFromRuntimeMXBeanName() {
        Long pid = null;
        String runtimeMXBeanName = ManagementFactory.getRuntimeMXBean().getName();
        int separatorPos = runtimeMXBeanName.indexOf(64);
        if (separatorPos > -1) {
            try {
                pid = Long.parseLong(runtimeMXBeanName.substring(0, separatorPos));
            }
            catch (NumberFormatException e2) {
                LOGGER.debug("Native-platform process: failed to parse PID from Runtime MX bean name: " + runtimeMXBeanName);
            }
        } else {
            LOGGER.debug("Native-platform process: failed to parse PID from Runtime MX bean name");
        }
        return pid;
    }

    @Override
    public EnvironmentModificationResult maybeSetEnvironment(Map<String, String> source) {
        return EnvironmentModificationResult.UNSUPPORTED_ENVIRONMENT;
    }

    @Override
    public void removeEnvironmentVariable(String name) throws NativeIntegrationException {
        throw this.notSupported();
    }

    @Override
    public EnvironmentModificationResult maybeRemoveEnvironmentVariable(String name) {
        return EnvironmentModificationResult.UNSUPPORTED_ENVIRONMENT;
    }

    @Override
    public void setEnvironmentVariable(String name, String value) throws NativeIntegrationException {
        throw this.notSupported();
    }

    @Override
    public EnvironmentModificationResult maybeSetEnvironmentVariable(String name, String value) {
        return EnvironmentModificationResult.UNSUPPORTED_ENVIRONMENT;
    }

    @Override
    public File getProcessDir() throws NativeIntegrationException {
        throw this.notSupported();
    }

    @Override
    public void setProcessDir(File processDir) throws NativeIntegrationException {
        throw this.notSupported();
    }

    @Override
    public boolean maybeSetProcessDir(File processDir) {
        return false;
    }

    @Override
    public Long getPid() throws NativeIntegrationException {
        if (this.pid != null) {
            return this.pid;
        }
        throw this.notSupported();
    }

    @Override
    public Long maybeGetPid() {
        return this.pid;
    }

    @Override
    public boolean maybeDetachProcess() {
        return false;
    }

    @Override
    public void detachProcess() {
        throw this.notSupported();
    }

    private NativeIntegrationException notSupported() {
        return new NativeIntegrationUnavailableException("We don't support this operating system: " + OperatingSystem.current());
    }
}

