/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.logging.events.LogLevelChangeEvent;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.RenderableOutputEvent;
import org.gradle.internal.logging.text.AbstractLineChoppingStyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutput;

public class StyledTextOutputBackedRenderer
implements OutputEventListener {
    public static final String ISO_8601_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private final OutputEventTextOutputImpl textOutput;
    private boolean debugOutput;
    private SimpleDateFormat dateFormat;
    private RenderableOutputEvent lastEvent;

    public StyledTextOutputBackedRenderer(StyledTextOutput textOutput) {
        this.textOutput = new OutputEventTextOutputImpl(textOutput);
    }

    @Override
    public void onOutput(OutputEvent event) {
        if (event instanceof LogLevelChangeEvent) {
            boolean newLogLevelIsDebug;
            LogLevelChangeEvent changeEvent = (LogLevelChangeEvent)event;
            boolean bl2 = newLogLevelIsDebug = changeEvent.getNewLogLevel() == LogLevel.DEBUG;
            if (newLogLevelIsDebug && this.dateFormat == null) {
                this.dateFormat = new SimpleDateFormat(ISO_8601_DATE_TIME_FORMAT);
            }
            this.debugOutput = newLogLevelIsDebug;
        }
        if (event instanceof RenderableOutputEvent) {
            RenderableOutputEvent outputEvent = (RenderableOutputEvent)event;
            this.textOutput.style(outputEvent.getLogLevel() == LogLevel.ERROR ? StyledTextOutput.Style.Error : StyledTextOutput.Style.Normal);
            if (this.debugOutput && (this.textOutput.atEndOfLine || this.lastEvent == null || !this.lastEvent.getCategory().equals(outputEvent.getCategory()))) {
                if (!this.textOutput.atEndOfLine) {
                    this.textOutput.println();
                }
                this.textOutput.text(this.dateFormat.format(new Date(outputEvent.getTimestamp())));
                this.textOutput.text(" [");
                this.textOutput.text((Object)outputEvent.getLogLevel());
                this.textOutput.text("] [");
                this.textOutput.text(outputEvent.getCategory());
                this.textOutput.text("] ");
            }
            outputEvent.render(this.textOutput);
            this.lastEvent = outputEvent;
            this.textOutput.style(StyledTextOutput.Style.Normal);
        }
    }

    private static class OutputEventTextOutputImpl
    extends AbstractLineChoppingStyledTextOutput {
        private final StyledTextOutput textOutput;
        private boolean atEndOfLine = true;

        public OutputEventTextOutputImpl(StyledTextOutput textOutput) {
            this.textOutput = textOutput;
        }

        @Override
        protected void doStyleChange(StyledTextOutput.Style style) {
            this.textOutput.style(style);
        }

        @Override
        protected void doLineText(CharSequence text) {
            this.textOutput.text(text);
            this.atEndOfLine = false;
        }

        @Override
        protected void doEndLine(CharSequence endOfLine) {
            this.textOutput.text(endOfLine);
            this.atEndOfLine = true;
        }
    }
}

