/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.exceptions;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.gradle.api.GradleException;
import org.gradle.internal.Factory;
import org.gradle.internal.exceptions.MultiCauseException;

public class DefaultMultiCauseException
extends GradleException
implements MultiCauseException {
    private final List<Throwable> causes = new CopyOnWriteArrayList<Throwable>();
    private transient ThreadLocal<Boolean> hideCause = this.threadLocal();
    private transient Factory<String> messageFactory;
    private String message;

    public DefaultMultiCauseException(String message) {
        super(message);
        this.message = message;
    }

    public DefaultMultiCauseException(String message, Throwable ... causes) {
        super(message);
        this.message = message;
        this.causes.addAll(Arrays.asList(causes));
    }

    public DefaultMultiCauseException(String message, Iterable<? extends Throwable> causes) {
        super(message);
        this.message = message;
        this.initCauses(causes);
    }

    public DefaultMultiCauseException(Factory<String> messageFactory) {
        this.messageFactory = messageFactory;
    }

    public DefaultMultiCauseException(Factory<String> messageFactory, Throwable ... causes) {
        this(messageFactory);
        this.causes.addAll(Arrays.asList(causes));
    }

    public DefaultMultiCauseException(Factory<String> messageFactory, Iterable<? extends Throwable> causes) {
        this(messageFactory);
        this.initCauses(causes);
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        inputStream.defaultReadObject();
        this.hideCause = this.threadLocal();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.getMessage();
        out.defaultWriteObject();
    }

    private ThreadLocal<Boolean> threadLocal() {
        return new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };
    }

    @Override
    public List<? extends Throwable> getCauses() {
        return this.causes;
    }

    @Override
    public Throwable initCause(Throwable throwable) {
        this.causes.clear();
        this.causes.add(throwable);
        return null;
    }

    public void initCauses(Iterable<? extends Throwable> causes) {
        this.causes.clear();
        for (Throwable throwable : causes) {
            this.causes.add(throwable);
        }
    }

    @Override
    public Throwable getCause() {
        if (this.hideCause.get().booleanValue()) {
            return null;
        }
        return this.causes.isEmpty() ? null : this.causes.get(0);
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        PrintWriter writer = new PrintWriter(printStream);
        this.printStackTrace(writer);
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter printWriter) {
        if (this.causes.size() <= 1) {
            super.printStackTrace(printWriter);
            return;
        }
        this.hideCause.set(true);
        try {
            super.printStackTrace(printWriter);
            for (int i2 = 0; i2 < this.causes.size(); ++i2) {
                Throwable cause = this.causes.get(i2);
                printWriter.format("Cause %s: ", i2 + 1);
                cause.printStackTrace(printWriter);
            }
        }
        finally {
            this.hideCause.set(false);
        }
    }

    @Override
    public String getMessage() {
        if (this.messageFactory != null) {
            this.message = this.messageFactory.create();
            this.messageFactory = null;
            return this.message;
        }
        return this.message;
    }
}

