/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.dispatch.MethodInvocation;
import org.gradle.internal.event.ListenerNotificationException;

public abstract class AbstractBroadcastDispatch<T>
implements Dispatch<MethodInvocation> {
    protected final Class<T> type;

    public AbstractBroadcastDispatch(Class<T> type) {
        this.type = type;
    }

    private String getErrorMessage() {
        String typeDescription = this.type.getSimpleName().replaceAll("(\\p{Upper})", " $1").trim().toLowerCase();
        return "Failed to notify " + typeDescription + ".";
    }

    protected void dispatch(MethodInvocation invocation, Dispatch<MethodInvocation> handler) {
        try {
            handler.dispatch(invocation);
        }
        catch (UncheckedException e2) {
            throw new ListenerNotificationException(invocation, this.getErrorMessage(), Collections.singletonList(e2.getCause()));
        }
        catch (RuntimeException t2) {
            throw t2;
        }
        catch (Throwable t3) {
            throw new ListenerNotificationException(invocation, this.getErrorMessage(), Collections.singletonList(t3));
        }
    }

    protected void dispatch(MethodInvocation invocation, Iterator<? extends Dispatch<MethodInvocation>> handlers) {
        ArrayList<Throwable> failures = null;
        while (handlers.hasNext()) {
            Dispatch<MethodInvocation> handler = handlers.next();
            try {
                handler.dispatch(invocation);
            }
            catch (ListenerNotificationException e2) {
                if (failures == null) {
                    failures = new ArrayList<Throwable>();
                }
                if (e2.getEvent() == invocation) {
                    failures.addAll(e2.getCauses());
                    continue;
                }
                failures.add(e2);
            }
            catch (UncheckedException e3) {
                if (failures == null) {
                    failures = new ArrayList();
                }
                failures.add(e3.getCause());
            }
            catch (Throwable t2) {
                if (failures == null) {
                    failures = new ArrayList();
                }
                failures.add(t2);
            }
        }
        if (failures == null) {
            return;
        }
        if (failures.size() == 1 && failures.get(0) instanceof RuntimeException) {
            throw (RuntimeException)failures.get(0);
        }
        throw new ListenerNotificationException(invocation, this.getErrorMessage(), failures);
    }
}

