/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.concurrent;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.Factory;

public class Synchronizer {
    private final Lock lock = new ReentrantLock();

    public <T> T synchronize(Factory<T> factory) {
        this.lock.lock();
        try {
            T t2 = factory.create();
            return t2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void synchronize(Runnable operation) {
        this.lock.lock();
        try {
            operation.run();
        }
        finally {
            this.lock.unlock();
        }
    }
}

