/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.processing;

import com.google.common.base.Objects;
import java.io.Serializable;
import javax.annotation.Nullable;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;

public final class GeneratedResource
implements Serializable {
    private final Location location;
    private final String path;

    public GeneratedResource(Location location, CharSequence pkg, CharSequence relativeName) {
        this(location, pkg.length() == 0 ? relativeName.toString() : pkg.toString().replace('.', '/') + '/' + relativeName);
    }

    public GeneratedResource(Location location, String path) {
        this.location = location;
        this.path = path;
    }

    public Location getLocation() {
        return this.location;
    }

    public String getPath() {
        return this.path;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        GeneratedResource that = (GeneratedResource)o2;
        return this.location == that.location && this.path.equals(that.path);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.location, this.path});
    }

    public String toString() {
        return this.path + " in " + (Object)((Object)this.location);
    }

    public static enum Location {
        CLASS_OUTPUT,
        SOURCE_OUTPUT,
        NATIVE_HEADER_OUTPUT;


        @Nullable
        public static Location from(JavaFileManager.Location location) {
            if (location instanceof StandardLocation) {
                switch ((StandardLocation)location) {
                    case CLASS_OUTPUT: {
                        return CLASS_OUTPUT;
                    }
                    case SOURCE_OUTPUT: {
                        return SOURCE_OUTPUT;
                    }
                    case NATIVE_HEADER_OUTPUT: {
                        return NATIVE_HEADER_OUTPUT;
                    }
                }
            }
            return null;
        }
    }
}

