/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.classpath;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassDependenciesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshot;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshotData;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassDependentsAccumulator;
import org.gradle.internal.FileUtils;
import org.gradle.internal.IoActions;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.StreamHasher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClasspathEntrySnapshotter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClasspathEntrySnapshotter.class);
    private final FileHasher fileHasher;
    private final StreamHasher hasher;
    private final ClassDependenciesAnalyzer analyzer;
    private final FileOperations fileOperations;

    public DefaultClasspathEntrySnapshotter(FileHasher fileHasher, StreamHasher streamHasher, ClassDependenciesAnalyzer analyzer, FileOperations fileOperations) {
        this.fileHasher = fileHasher;
        this.hasher = streamHasher;
        this.analyzer = analyzer;
        this.fileOperations = fileOperations;
    }

    public ClasspathEntrySnapshot createSnapshot(HashCode hash, File classpathEntry) {
        ClassDependentsAccumulator accumulator;
        HashMap hashes;
        block2: {
            hashes = Maps.newHashMap();
            accumulator = new ClassDependentsAccumulator();
            try {
                this.visit(classpathEntry, hashes, accumulator);
            }
            catch (Exception e2) {
                accumulator.fullRebuildNeeded(classpathEntry + " could not be analyzed for incremental compilation. See the debug log for more details");
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug("Could not analyze " + classpathEntry + " for incremental compilation", (Throwable)e2);
            }
        }
        return new ClasspathEntrySnapshot(new ClasspathEntrySnapshotData(hash, hashes, accumulator.getAnalysis()));
    }

    private void visit(File classpathEntry, Map<String, HashCode> hashes, ClassDependentsAccumulator accumulator) {
        if (FileUtils.hasExtension(classpathEntry, ".jar")) {
            this.fileOperations.zipTree((Object)classpathEntry).visit(new JarEntryVisitor(accumulator, hashes));
        }
        if (classpathEntry.isDirectory()) {
            this.fileOperations.fileTree((Object)classpathEntry).visit(new DirectoryEntryVisitor(accumulator, hashes));
        }
    }

    private class DirectoryEntryVisitor
    extends EntryVisitor {
        public DirectoryEntryVisitor(ClassDependentsAccumulator accumulator, Map<String, HashCode> hashes) {
            super(accumulator, hashes);
        }

        @Override
        protected HashCode getHashCode(FileVisitDetails fileDetails) {
            return DefaultClasspathEntrySnapshotter.this.fileHasher.hash(fileDetails.getFile(), fileDetails.getSize(), fileDetails.getLastModified());
        }
    }

    private class JarEntryVisitor
    extends EntryVisitor {
        public JarEntryVisitor(ClassDependentsAccumulator accumulator, Map<String, HashCode> hashes) {
            super(accumulator, hashes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected HashCode getHashCode(FileVisitDetails fileDetails) {
            InputStream inputStream = fileDetails.open();
            try {
                HashCode hashCode = DefaultClasspathEntrySnapshotter.this.hasher.hash(inputStream);
                return hashCode;
            }
            finally {
                IoActions.closeQuietly(inputStream);
            }
        }
    }

    private abstract class EntryVisitor
    implements FileVisitor {
        private final ClassDependentsAccumulator accumulator;
        private final Map<String, HashCode> hashes;

        public EntryVisitor(ClassDependentsAccumulator accumulator, Map<String, HashCode> hashes) {
            this.accumulator = accumulator;
            this.hashes = hashes;
        }

        @Override
        public void visitDir(FileVisitDetails dirDetails) {
        }

        @Override
        public void visitFile(FileVisitDetails fileDetails) {
            block3: {
                if (!fileDetails.getName().endsWith(".class")) {
                    return;
                }
                HashCode classFileHash = this.getHashCode(fileDetails);
                try {
                    ClassAnalysis analysis = DefaultClasspathEntrySnapshotter.this.analyzer.getClassAnalysis(classFileHash, fileDetails);
                    this.accumulator.addClass(analysis);
                    this.hashes.put(analysis.getClassName(), classFileHash);
                }
                catch (Exception e2) {
                    this.accumulator.fullRebuildNeeded(fileDetails.getName() + " could not be analyzed for incremental compilation. See the debug log for more details");
                    if (!LOGGER.isDebugEnabled()) break block3;
                    LOGGER.debug("Could not analyze " + fileDetails.getName() + " for incremental compilation", (Throwable)e2);
                }
            }
        }

        protected abstract HashCode getHashCode(FileVisitDetails var1);
    }
}

