/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.Closeable;
import java.util.Locale;
import javax.annotation.processing.Processor;
import javax.tools.JavaCompiler;
import org.gradle.internal.concurrent.CompositeStoppable;

class ResourceCleaningCompilationTask
implements JavaCompiler.CompilationTask {
    private final JavaCompiler.CompilationTask delegate;
    private final Closeable fileManager;

    ResourceCleaningCompilationTask(JavaCompiler.CompilationTask delegate, Closeable fileManager) {
        this.delegate = delegate;
        this.fileManager = fileManager;
    }

    @Override
    public void addModules(Iterable<String> moduleNames) {
    }

    @Override
    public void setProcessors(Iterable<? extends Processor> processors) {
        this.delegate.setProcessors(processors);
    }

    @Override
    public void setLocale(Locale locale) {
        this.delegate.setLocale(locale);
    }

    @Override
    public Boolean call() {
        Boolean bl2;
        try {
            bl2 = this.delegate.call();
        }
        catch (Throwable throwable) {
            CompositeStoppable.stoppable(this.fileManager).stop();
            this.cleanupZipCache();
            throw throwable;
        }
        CompositeStoppable.stoppable(this.fileManager).stop();
        this.cleanupZipCache();
        return bl2;
    }

    private void cleanupZipCache() {
        try {
            Class<?> zipFileIndexCache = Class.forName("com.sun.tools.javac.file.ZipFileIndexCache");
            Object instance = zipFileIndexCache.getMethod("getSharedInstance", new Class[0]).invoke(null, new Object[0]);
            zipFileIndexCache.getMethod("clearCache", new Class[0]).invoke(instance, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

