/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer;

import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.config.TestRetryTaskExtensionAccessor;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.JvmTestExecutionSpecFactory;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.RetryTestResultProcessor;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.RoundResult;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.TestFrameworkTemplate;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.framework.TestFrameworkStrategy;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.filter.AnnotationInspectorImpl;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.filter.ClassRetryMatcher;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.filter.RetryFilter;
import java.io.File;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.internal.tasks.testing.JvmTestExecutionSpec;
import org.gradle.api.internal.tasks.testing.TestExecuter;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.reflect.Instantiator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RetryTestExecuter
implements TestExecuter<JvmTestExecutionSpec> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryTestExecuter.class);
    private final TestRetryTaskExtensionAccessor extension;
    private final TestExecuter<JvmTestExecutionSpec> delegate;
    private final Test testTask;
    private final TestFrameworkTemplate frameworkTemplate;
    private RoundResult lastResult;

    public RetryTestExecuter(Test test, TestRetryTaskExtensionAccessor testRetryTaskExtensionAccessor, TestExecuter<JvmTestExecutionSpec> testExecuter, Instantiator instantiator, ObjectFactory objectFactory, Set<File> set, Set<File> set2) {
        this.extension = testRetryTaskExtensionAccessor;
        this.delegate = testExecuter;
        this.testTask = test;
        this.frameworkTemplate = new TestFrameworkTemplate(this.testTask, instantiator, objectFactory, set, set2);
    }

    @Override
    public void execute(JvmTestExecutionSpec jvmTestExecutionSpec, TestResultProcessor testResultProcessor) {
        int n2 = this.extension.getMaxRetries();
        int n3 = this.extension.getMaxFailures();
        boolean bl2 = this.extension.getFailOnPassedAfterRetry();
        if (n2 <= 0) {
            this.delegate.execute(jvmTestExecutionSpec, testResultProcessor);
            return;
        }
        TestFrameworkStrategy testFrameworkStrategy = TestFrameworkStrategy.of(jvmTestExecutionSpec.getTestFramework());
        if (testFrameworkStrategy == null) {
            LOGGER.warn("Test retry requested for task {} with unsupported test framework {} - failing tests will not be retried", (Object)jvmTestExecutionSpec.getIdentityPath(), (Object)jvmTestExecutionSpec.getTestFramework().getClass().getName());
            this.delegate.execute(jvmTestExecutionSpec, testResultProcessor);
            return;
        }
        AnnotationInspectorImpl annotationInspectorImpl = new AnnotationInspectorImpl(this.frameworkTemplate.testsReader);
        RetryFilter retryFilter = new RetryFilter(annotationInspectorImpl, this.extension.getIncludeClasses(), this.extension.getIncludeAnnotationClasses(), this.extension.getExcludeClasses(), this.extension.getExcludeAnnotationClasses());
        ClassRetryMatcher classRetryMatcher = new ClassRetryMatcher(annotationInspectorImpl, this.extension.getClassRetryIncludeClasses(), this.extension.getClassRetryIncludeAnnotationClasses());
        RetryTestResultProcessor retryTestResultProcessor = new RetryTestResultProcessor(testFrameworkStrategy, retryFilter, classRetryMatcher, this.frameworkTemplate.testsReader, testResultProcessor, n3);
        int n4 = 0;
        JvmTestExecutionSpec jvmTestExecutionSpec2 = jvmTestExecutionSpec;
        while (true) {
            RoundResult roundResult;
            this.delegate.execute(jvmTestExecutionSpec2, retryTestResultProcessor);
            this.lastResult = roundResult = retryTestResultProcessor.getResult();
            if (this.extension.getSimulateNotRetryableTest() || !roundResult.nonRetriedTests.isEmpty()) {
                this.testTask.setIgnoreFailures(true);
                break;
            }
            if (roundResult.failedTests.isEmpty()) {
                if (n4 <= 0 || roundResult.hasRetryFilteredFailures || bl2) break;
                this.testTask.setIgnoreFailures(true);
                break;
            }
            if (roundResult.lastRound) break;
            TestFramework testFramework = testFrameworkStrategy.createRetrying(this.frameworkTemplate, jvmTestExecutionSpec.getTestFramework(), roundResult.failedTests);
            jvmTestExecutionSpec2 = JvmTestExecutionSpecFactory.testExecutionSpecFor(testFramework, jvmTestExecutionSpec);
            retryTestResultProcessor.reset(++n4 == n2);
        }
    }

    public void failWithNonRetriedTestsIfAny() {
        if (this.extension.getSimulateNotRetryableTest() || this.hasNonRetriedTests()) {
            throw new IllegalStateException("org.gradle.test-retry was unable to retry the following test methods, which is unexpected. Please file a bug report at https://github.com/gradle/test-retry-gradle-plugin/issues" + this.lastResult.nonRetriedTests.stream().flatMap(entry -> ((Set)entry.getValue()).stream().map(string -> "   " + (String)entry.getKey() + "#" + string)).collect(Collectors.joining("\n", "\n", "\n")));
        }
    }

    private boolean hasNonRetriedTests() {
        return this.lastResult != null && !this.lastResult.nonRetriedTests.isEmpty();
    }

    @Override
    public void stopNow() {
        this.delegate.stopNow();
    }
}

