/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.extensions;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.StringUtil;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.component.ContainerLifeCycle;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.component.Dumpable;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.component.LifeCycle;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.compression.DeflaterPool;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.compression.InflaterPool;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.WebSocketException;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.extensions.Extension;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.extensions.AbstractExtension;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.extensions.compress.CompressExtension;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import java.io.IOException;

public class WebSocketExtensionFactory
extends ExtensionFactory
implements Dumpable,
LifeCycle {
    private final ContainerLifeCycle containerLifeCycle;
    private final WebSocketContainerScope container;
    private final InflaterPool inflaterPool;
    private final DeflaterPool deflaterPool;

    public WebSocketExtensionFactory(WebSocketContainerScope webSocketContainerScope) {
        this(webSocketContainerScope, null, null);
    }

    public WebSocketExtensionFactory(WebSocketContainerScope webSocketContainerScope, InflaterPool inflaterPool, DeflaterPool deflaterPool) {
        this.container = webSocketContainerScope;
        this.containerLifeCycle = new ContainerLifeCycle(){

            @Override
            public String toString() {
                return String.format("%s@%x{%s}", WebSocketExtensionFactory.class.getSimpleName(), this.hashCode(), WebSocketExtensionFactory.this.containerLifeCycle.getState());
            }
        };
        this.inflaterPool = inflaterPool != null ? inflaterPool : new InflaterPool(-1, true);
        this.containerLifeCycle.addBean(this.inflaterPool);
        this.deflaterPool = deflaterPool != null ? deflaterPool : new DeflaterPool(-1, -1, true);
        this.containerLifeCycle.addBean(this.deflaterPool);
    }

    @Override
    public Extension newInstance(ExtensionConfig extensionConfig) {
        if (extensionConfig == null) {
            return null;
        }
        String string = extensionConfig.getName();
        if (StringUtil.isBlank(string)) {
            return null;
        }
        Class<? extends Extension> clazz = this.getExtension(string);
        if (clazz == null) {
            return null;
        }
        try {
            AbstractExtension abstractExtension;
            Extension extension = this.container.getObjectFactory().createInstance(clazz);
            if (extension instanceof AbstractExtension) {
                abstractExtension = (AbstractExtension)extension;
                abstractExtension.init(this.container);
                abstractExtension.setConfig(extensionConfig);
            }
            if (extension instanceof CompressExtension) {
                abstractExtension = (CompressExtension)extension;
                ((CompressExtension)abstractExtension).setInflaterPool(this.inflaterPool);
                ((CompressExtension)abstractExtension).setDeflaterPool(this.deflaterPool);
            }
            return extension;
        }
        catch (Exception exception) {
            throw new WebSocketException("Cannot instantiate extension: " + clazz, exception);
        }
    }

    @Override
    public void start() throws Exception {
        this.containerLifeCycle.start();
    }

    @Override
    public void stop() throws Exception {
        this.containerLifeCycle.stop();
    }

    @Override
    public boolean isRunning() {
        return this.containerLifeCycle.isRunning();
    }

    @Override
    public boolean isStarted() {
        return this.containerLifeCycle.isStarted();
    }

    @Override
    public boolean isStarting() {
        return this.containerLifeCycle.isStarting();
    }

    @Override
    public boolean isStopping() {
        return this.containerLifeCycle.isStopping();
    }

    @Override
    public boolean isStopped() {
        return this.containerLifeCycle.isStopped();
    }

    @Override
    public boolean isFailed() {
        return this.containerLifeCycle.isFailed();
    }

    @Override
    public String dumpSelf() {
        return this.containerLifeCycle.dumpSelf();
    }

    @Override
    public void dump(Appendable appendable, String string) throws IOException {
        this.containerLifeCycle.dump(appendable, string);
    }

    public String toString() {
        return this.containerLifeCycle.toString();
    }
}

