/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.events;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.InvalidWebSocketException;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.events.EventDriver;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.events.EventDriverImpl;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.events.JettyAnnotatedImpl;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.events.JettyListenerImpl;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import java.util.ArrayList;
import java.util.List;

public class EventDriverFactory {
    private static final Logger LOG = Log.getLogger(EventDriverFactory.class);
    private final WebSocketContainerScope containerScope;
    private final List<EventDriverImpl> implementations;

    public EventDriverFactory(WebSocketContainerScope webSocketContainerScope) {
        this.containerScope = webSocketContainerScope;
        this.implementations = new ArrayList<EventDriverImpl>();
        this.addImplementation(new JettyListenerImpl());
        this.addImplementation(new JettyAnnotatedImpl());
    }

    public void addImplementation(EventDriverImpl eventDriverImpl) {
        if (this.implementations.contains(eventDriverImpl)) {
            LOG.warn("Ignoring attempt to add duplicate EventDriverImpl: " + eventDriverImpl, new Object[0]);
            return;
        }
        this.implementations.add(eventDriverImpl);
    }

    protected String getClassName(Object object) {
        return object.getClass().getName();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append("[implementations=[");
        boolean bl2 = false;
        for (EventDriverImpl eventDriverImpl : this.implementations) {
            if (bl2) {
                stringBuilder.append(',');
            }
            stringBuilder.append(eventDriverImpl.toString());
            bl2 = true;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public EventDriver wrap(Object object) {
        if (object == null) {
            throw new InvalidWebSocketException("null websocket object");
        }
        for (EventDriverImpl eventDriverImpl : this.implementations) {
            if (!eventDriverImpl.supports(object)) continue;
            try {
                return eventDriverImpl.create(object, this.containerScope.getPolicy().clonePolicy());
            }
            catch (Throwable throwable) {
                throw new InvalidWebSocketException("Unable to create websocket", throwable);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClassName(object));
        stringBuilder.append(" is not a valid WebSocket object.");
        stringBuilder.append("  Object must obey one of the following rules: ");
        int n2 = this.implementations.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            EventDriverImpl eventDriverImpl = this.implementations.get(i2);
            if (i2 > 0) {
                stringBuilder.append(" or ");
            }
            stringBuilder.append("\n(").append(i2 + 1).append(") ");
            stringBuilder.append(eventDriverImpl.describeRule());
        }
        throw new InvalidWebSocketException(stringBuilder.toString());
    }
}

