/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.thread;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.component.Destroyable;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.component.LifeCycle;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.thread.PrivilegedThreadFactory;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ShutdownThread
extends Thread {
    private static final Logger LOG = Log.getLogger(ShutdownThread.class);
    private static final ShutdownThread _thread = PrivilegedThreadFactory.newThread(() -> new ShutdownThread());
    private boolean _hooked;
    private final List<LifeCycle> _lifeCycles = new CopyOnWriteArrayList<LifeCycle>();

    private ShutdownThread() {
        super("JettyShutdownThread");
    }

    private synchronized void hook() {
        try {
            if (!this._hooked) {
                Runtime.getRuntime().addShutdownHook(this);
            }
            this._hooked = true;
        }
        catch (Exception exception) {
            LOG.ignore(exception);
            LOG.info("shutdown already commenced", new Object[0]);
        }
    }

    private synchronized void unhook() {
        try {
            this._hooked = false;
            Runtime.getRuntime().removeShutdownHook(this);
        }
        catch (Exception exception) {
            LOG.ignore(exception);
            LOG.debug("shutdown already commenced", new Object[0]);
        }
    }

    public static synchronized void register(LifeCycle ... lifeCycleArray) {
        ShutdownThread._thread._lifeCycles.addAll(Arrays.asList(lifeCycleArray));
        if (ShutdownThread._thread._lifeCycles.size() > 0) {
            _thread.hook();
        }
    }

    public static synchronized void deregister(LifeCycle lifeCycle) {
        ShutdownThread._thread._lifeCycles.remove(lifeCycle);
        if (ShutdownThread._thread._lifeCycles.size() == 0) {
            _thread.unhook();
        }
    }

    public static synchronized boolean isRegistered(LifeCycle lifeCycle) {
        return ShutdownThread._thread._lifeCycles.contains(lifeCycle);
    }

    @Override
    public void run() {
        for (LifeCycle lifeCycle : ShutdownThread._thread._lifeCycles) {
            try {
                if (lifeCycle.isStarted()) {
                    lifeCycle.stop();
                    LOG.debug("Stopped {}", lifeCycle);
                }
                if (!(lifeCycle instanceof Destroyable)) continue;
                ((Destroyable)((Object)lifeCycle)).destroy();
                LOG.debug("Destroyed {}", lifeCycle);
            }
            catch (Exception exception) {
                LOG.debug(exception);
            }
        }
    }
}

