/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.StringUtil;

public class HostPort {
    private final String _host;
    private final int _port;

    public HostPort(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("No Authority");
        }
        try {
            if (string.isEmpty()) {
                this._host = string;
                this._port = 0;
            } else if (string.charAt(0) == '[') {
                int n2 = string.lastIndexOf(93);
                if (n2 < 0) {
                    throw new IllegalArgumentException("Bad IPv6 host");
                }
                this._host = string.substring(0, n2 + 1);
                if (string.length() > n2 + 1) {
                    if (string.charAt(n2 + 1) != ':') {
                        throw new IllegalArgumentException("Bad IPv6 port");
                    }
                    this._port = HostPort.parsePort(string.substring(n2 + 2));
                } else {
                    this._port = 0;
                }
            } else {
                int n3 = string.lastIndexOf(58);
                if (n3 >= 0) {
                    if (n3 != string.indexOf(58)) {
                        this._host = "[" + string + "]";
                        this._port = 0;
                    } else {
                        this._host = string.substring(0, n3);
                        this._port = HostPort.parsePort(string.substring(n3 + 1));
                    }
                } else {
                    this._host = string;
                    this._port = 0;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Bad HostPort", exception);
        }
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public String toString() {
        if (this._port > 0) {
            return this._host + ":" + this._port;
        }
        return this._host;
    }

    public static String normalizeHost(String string) {
        if (string == null || string.isEmpty() || string.charAt(0) == '[' || string.indexOf(58) < 0) {
            return string;
        }
        return "[" + string + "]";
    }

    public static int parsePort(String string) throws IllegalArgumentException {
        if (StringUtil.isEmpty(string)) {
            throw new IllegalArgumentException("Bad port");
        }
        int n2 = Integer.parseInt(string);
        if (n2 <= 0 || n2 > 65535) {
            throw new IllegalArgumentException("Bad port");
        }
        return n2;
    }
}

