/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.MemoryUtils;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class BlockingArrayQueue<E>
extends AbstractList<E>
implements BlockingQueue<E> {
    private static final int HEAD_OFFSET = MemoryUtils.getIntegersPerCacheLine() - 1;
    private static final int TAIL_OFFSET = HEAD_OFFSET + MemoryUtils.getIntegersPerCacheLine();
    private final int _maxCapacity;
    private final int _growCapacity;
    private final int[] _indexes = new int[TAIL_OFFSET + 1];
    private final Lock _tailLock = new ReentrantLock();
    private final AtomicInteger _size = new AtomicInteger();
    private final Lock _headLock = new ReentrantLock();
    private final Condition _notEmpty = this._headLock.newCondition();
    private Object[] _elements;

    public BlockingArrayQueue() {
        this._elements = new Object[128];
        this._growCapacity = 64;
        this._maxCapacity = Integer.MAX_VALUE;
    }

    public BlockingArrayQueue(int n2) {
        this._elements = new Object[n2];
        this._growCapacity = -1;
        this._maxCapacity = n2;
    }

    public BlockingArrayQueue(int n2, int n3) {
        this._elements = new Object[n2];
        this._growCapacity = n3;
        this._maxCapacity = Integer.MAX_VALUE;
    }

    public BlockingArrayQueue(int n2, int n3, int n4) {
        if (n2 > n4) {
            throw new IllegalArgumentException();
        }
        this._elements = new Object[n2];
        this._growCapacity = n3;
        this._maxCapacity = n4;
    }

    @Override
    public void clear() {
        this._tailLock.lock();
        try {
            this._headLock.lock();
            try {
                this._indexes[BlockingArrayQueue.HEAD_OFFSET] = 0;
                this._indexes[BlockingArrayQueue.TAIL_OFFSET] = 0;
                this._size.set(0);
            }
            finally {
                this._headLock.unlock();
            }
        }
        finally {
            this._tailLock.unlock();
        }
    }

    @Override
    public int size() {
        return this._size.get();
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public E poll() {
        if (this._size.get() == 0) {
            return null;
        }
        Object object = null;
        this._headLock.lock();
        try {
            if (this._size.get() > 0) {
                int n2 = this._indexes[HEAD_OFFSET];
                object = this._elements[n2];
                this._elements[n2] = null;
                this._indexes[BlockingArrayQueue.HEAD_OFFSET] = (n2 + 1) % this._elements.length;
                if (this._size.decrementAndGet() > 0) {
                    this._notEmpty.signal();
                }
            }
        }
        finally {
            this._headLock.unlock();
        }
        return (E)object;
    }

    @Override
    public E peek() {
        if (this._size.get() == 0) {
            return null;
        }
        Object object = null;
        this._headLock.lock();
        try {
            if (this._size.get() > 0) {
                object = this._elements[this._indexes[HEAD_OFFSET]];
            }
        }
        finally {
            this._headLock.unlock();
        }
        return (E)object;
    }

    @Override
    public E remove() {
        E e2 = this.poll();
        if (e2 == null) {
            throw new NoSuchElementException();
        }
        return e2;
    }

    @Override
    public E element() {
        E e2 = this.peek();
        if (e2 == null) {
            throw new NoSuchElementException();
        }
        return e2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e2) {
        Objects.requireNonNull(e2);
        boolean bl2 = false;
        this._tailLock.lock();
        try {
            int n2 = this._size.get();
            if (n2 >= this._maxCapacity) {
                boolean bl3 = false;
                return bl3;
            }
            if (n2 == this._elements.length) {
                this._headLock.lock();
                try {
                    if (!this.grow()) {
                        boolean bl4 = false;
                        return bl4;
                    }
                }
                finally {
                    this._headLock.unlock();
                }
            }
            int n3 = this._indexes[TAIL_OFFSET];
            this._elements[n3] = e2;
            this._indexes[BlockingArrayQueue.TAIL_OFFSET] = (n3 + 1) % this._elements.length;
            bl2 = this._size.getAndIncrement() == 0;
        }
        finally {
            this._tailLock.unlock();
        }
        if (bl2) {
            this._headLock.lock();
            try {
                this._notEmpty.signal();
            }
            finally {
                this._headLock.unlock();
            }
        }
        return true;
    }

    @Override
    public boolean add(E e2) {
        if (this.offer(e2)) {
            return true;
        }
        throw new IllegalStateException();
    }

    @Override
    public void put(E e2) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(E e2, long l2, TimeUnit timeUnit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public E take() throws InterruptedException {
        Object object = null;
        this._headLock.lockInterruptibly();
        try {
            try {
                while (this._size.get() == 0) {
                    this._notEmpty.await();
                }
            }
            catch (InterruptedException interruptedException) {
                this._notEmpty.signal();
                throw interruptedException;
            }
            int n2 = this._indexes[HEAD_OFFSET];
            object = this._elements[n2];
            this._elements[n2] = null;
            this._indexes[BlockingArrayQueue.HEAD_OFFSET] = (n2 + 1) % this._elements.length;
            if (this._size.decrementAndGet() > 0) {
                this._notEmpty.signal();
            }
        }
        finally {
            this._headLock.unlock();
        }
        return (E)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long l2, TimeUnit timeUnit) throws InterruptedException {
        long l3 = timeUnit.toNanos(l2);
        Object object = null;
        this._headLock.lockInterruptibly();
        try {
            while (this._size.get() == 0) {
                if (l3 <= 0L) {
                    E e2 = null;
                    return e2;
                }
                try {
                    l3 = this._notEmpty.awaitNanos(l3);
                }
                catch (InterruptedException interruptedException) {
                    this._notEmpty.signal();
                    throw interruptedException;
                }
            }
            int n2 = this._indexes[HEAD_OFFSET];
            object = this._elements[n2];
            this._elements[n2] = null;
            this._indexes[BlockingArrayQueue.HEAD_OFFSET] = (n2 + 1) % this._elements.length;
            if (this._size.decrementAndGet() > 0) {
                this._notEmpty.signal();
            }
        }
        finally {
            this._headLock.unlock();
        }
        return (E)object;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean remove(Object var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[DOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int remainingCapacity() {
        this._tailLock.lock();
        try {
            this._headLock.lock();
            try {
                int n2 = this.getCapacity() - this.size();
                this._headLock.unlock();
                return n2;
            }
            catch (Throwable throwable) {
                this._headLock.unlock();
                throw throwable;
            }
        }
        finally {
            this._tailLock.unlock();
        }
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        return this.drainTo(collection, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection, int n2) {
        int n3;
        this._tailLock.lock();
        try {
            this._headLock.lock();
            try {
                int n4 = this._indexes[HEAD_OFFSET];
                int n5 = this._indexes[TAIL_OFFSET];
                int n6 = this._elements.length;
                int n7 = n4;
                for (n3 = 0; n7 != n5 && n3 < n2; ++n3) {
                    collection.add(this._elements[n7]);
                    if (++n7 != n6) continue;
                    n7 = 0;
                }
                if (n7 == n5) {
                    this._indexes[BlockingArrayQueue.HEAD_OFFSET] = 0;
                    this._indexes[BlockingArrayQueue.TAIL_OFFSET] = 0;
                    this._size.set(0);
                } else {
                    this._indexes[BlockingArrayQueue.HEAD_OFFSET] = n7;
                    this._size.addAndGet(-n3);
                }
            }
            finally {
                this._headLock.unlock();
            }
        }
        finally {
            this._tailLock.unlock();
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(int n2) {
        this._tailLock.lock();
        try {
            Object object;
            this._headLock.lock();
            try {
                if (n2 < 0 || n2 >= this._size.get()) {
                    throw new IndexOutOfBoundsException("!(0<" + n2 + "<=" + this._size + ")");
                }
                int n3 = this._indexes[HEAD_OFFSET] + n2;
                int n4 = this._elements.length;
                if (n3 >= n4) {
                    n3 -= n4;
                }
                object = this._elements[n3];
                this._headLock.unlock();
            }
            catch (Throwable throwable) {
                this._headLock.unlock();
                throw throwable;
            }
            return (E)object;
        }
        finally {
            this._tailLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int n2, E e2) {
        if (e2 == null) {
            throw new NullPointerException();
        }
        this._tailLock.lock();
        try {
            this._headLock.lock();
            try {
                int n3 = this._size.get();
                if (n2 < 0 || n2 > n3) {
                    throw new IndexOutOfBoundsException("!(0<" + n2 + "<=" + this._size + ")");
                }
                if (n2 == n3) {
                    this.add(e2);
                } else {
                    if (this._indexes[TAIL_OFFSET] == this._indexes[HEAD_OFFSET] && !this.grow()) {
                        throw new IllegalStateException("full");
                    }
                    int n4 = this._indexes[HEAD_OFFSET] + n2;
                    int n5 = this._elements.length;
                    if (n4 >= n5) {
                        n4 -= n5;
                    }
                    this._size.incrementAndGet();
                    int n6 = this._indexes[TAIL_OFFSET];
                    this._indexes[BlockingArrayQueue.TAIL_OFFSET] = n6 = (n6 + 1) % n5;
                    if (n4 < n6) {
                        System.arraycopy(this._elements, n4, this._elements, n4 + 1, n6 - n4);
                        this._elements[n4] = e2;
                    } else {
                        if (n6 > 0) {
                            System.arraycopy(this._elements, 0, this._elements, 1, n6);
                            this._elements[0] = this._elements[n5 - 1];
                        }
                        System.arraycopy(this._elements, n4, this._elements, n4 + 1, n5 - n4 - 1);
                        this._elements[n4] = e2;
                    }
                }
            }
            finally {
                this._headLock.unlock();
            }
        }
        finally {
            this._tailLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int n2, E e2) {
        Objects.requireNonNull(e2);
        this._tailLock.lock();
        try {
            Object object;
            this._headLock.lock();
            try {
                if (n2 < 0 || n2 >= this._size.get()) {
                    throw new IndexOutOfBoundsException("!(0<" + n2 + "<=" + this._size + ")");
                }
                int n3 = this._indexes[HEAD_OFFSET] + n2;
                int n4 = this._elements.length;
                if (n3 >= n4) {
                    n3 -= n4;
                }
                Object object2 = this._elements[n3];
                this._elements[n3] = e2;
                object = object2;
                this._headLock.unlock();
            }
            catch (Throwable throwable) {
                this._headLock.unlock();
                throw throwable;
            }
            return (E)object;
        }
        finally {
            this._tailLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int n2) {
        this._tailLock.lock();
        try {
            Object object;
            this._headLock.lock();
            try {
                if (n2 < 0 || n2 >= this._size.get()) {
                    throw new IndexOutOfBoundsException("!(0<" + n2 + "<=" + this._size + ")");
                }
                int n3 = this._indexes[HEAD_OFFSET] + n2;
                int n4 = this._elements.length;
                if (n3 >= n4) {
                    n3 -= n4;
                }
                Object object2 = this._elements[n3];
                int n5 = this._indexes[TAIL_OFFSET];
                if (n3 < n5) {
                    System.arraycopy(this._elements, n3 + 1, this._elements, n3, n5 - n3);
                    int n6 = TAIL_OFFSET;
                    this._indexes[n6] = this._indexes[n6] - 1;
                } else {
                    System.arraycopy(this._elements, n3 + 1, this._elements, n3, n4 - n3 - 1);
                    this._elements[n4 - 1] = this._elements[0];
                    if (n5 > 0) {
                        System.arraycopy(this._elements, 1, this._elements, 0, n5);
                        int n7 = TAIL_OFFSET;
                        this._indexes[n7] = this._indexes[n7] - 1;
                    } else {
                        this._indexes[BlockingArrayQueue.TAIL_OFFSET] = n4 - 1;
                    }
                    this._elements[this._indexes[BlockingArrayQueue.TAIL_OFFSET]] = null;
                }
                this._size.decrementAndGet();
                object = object2;
                this._headLock.unlock();
            }
            catch (Throwable throwable) {
                this._headLock.unlock();
                throw throwable;
            }
            return (E)object;
        }
        finally {
            this._tailLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIterator<E> listIterator(int n2) {
        this._tailLock.lock();
        try {
            this._headLock.lock();
            try {
                Object[] objectArray = new Object[this.size()];
                if (this.size() > 0) {
                    int n3 = this._indexes[HEAD_OFFSET];
                    int n4 = this._indexes[TAIL_OFFSET];
                    if (n3 < n4) {
                        System.arraycopy(this._elements, n3, objectArray, 0, n4 - n3);
                    } else {
                        int n5 = this._elements.length - n3;
                        System.arraycopy(this._elements, n3, objectArray, 0, n5);
                        System.arraycopy(this._elements, 0, objectArray, n5, n4);
                    }
                }
                Itr itr = new Itr(objectArray, n2);
                this._headLock.unlock();
                return itr;
            }
            catch (Throwable throwable) {
                this._headLock.unlock();
                throw throwable;
            }
        }
        finally {
            this._tailLock.unlock();
        }
    }

    public int getCapacity() {
        this._tailLock.lock();
        try {
            int n2 = this._elements.length;
            return n2;
        }
        finally {
            this._tailLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean grow() {
        if (this._growCapacity <= 0) {
            return false;
        }
        this._tailLock.lock();
        try {
            this._headLock.lock();
            try {
                int n2;
                int n3 = this._indexes[HEAD_OFFSET];
                int n4 = this._indexes[TAIL_OFFSET];
                int n5 = this._elements.length;
                Object[] objectArray = new Object[n5 + this._growCapacity];
                if (n3 < n4) {
                    n2 = n4 - n3;
                    System.arraycopy(this._elements, n3, objectArray, 0, n2);
                } else if (n3 > n4 || this._size.get() > 0) {
                    n2 = n5 + n4 - n3;
                    int bl2 = n5 - n3;
                    System.arraycopy(this._elements, n3, objectArray, 0, bl2);
                    System.arraycopy(this._elements, 0, objectArray, bl2, n4);
                } else {
                    n2 = 0;
                }
                this._elements = objectArray;
                this._indexes[BlockingArrayQueue.HEAD_OFFSET] = 0;
                this._indexes[BlockingArrayQueue.TAIL_OFFSET] = n2;
                boolean bl2 = true;
                this._headLock.unlock();
                return bl2;
            }
            catch (Throwable throwable) {
                this._headLock.unlock();
                throw throwable;
            }
        }
        finally {
            this._tailLock.unlock();
        }
    }

    private class Itr
    implements ListIterator<E> {
        private final Object[] _elements;
        private int _cursor;

        public Itr(Object[] objectArray, int n2) {
            this._elements = objectArray;
            this._cursor = n2;
        }

        @Override
        public boolean hasNext() {
            return this._cursor < this._elements.length;
        }

        @Override
        public E next() {
            return this._elements[this._cursor++];
        }

        @Override
        public boolean hasPrevious() {
            return this._cursor > 0;
        }

        @Override
        public E previous() {
            return this._elements[--this._cursor];
        }

        @Override
        public int nextIndex() {
            return this._cursor + 1;
        }

        @Override
        public int previousIndex() {
            return this._cursor - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e2) {
            throw new UnsupportedOperationException();
        }
    }
}

