/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.Connection;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.EndPoint;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.BufferUtil;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.Callback;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.thread.Invocable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritePendingException;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public abstract class WriteFlusher {
    private static final Logger LOG = Log.getLogger(WriteFlusher.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private static final ByteBuffer[] EMPTY_BUFFERS = new ByteBuffer[]{BufferUtil.EMPTY_BUFFER};
    private static final EnumMap<StateType, Set<StateType>> __stateTransitions = new EnumMap(StateType.class);
    private static final State __IDLE = new IdleState();
    private static final State __WRITING = new WritingState();
    private static final State __COMPLETING = new CompletingState();
    private final EndPoint _endPoint;
    private final AtomicReference<State> _state = new AtomicReference();

    protected WriteFlusher(EndPoint endPoint) {
        this._state.set(__IDLE);
        this._endPoint = endPoint;
    }

    private boolean updateState(State state, State state2) {
        if (!this.isTransitionAllowed(state, state2)) {
            throw new IllegalStateException();
        }
        boolean bl2 = this._state.compareAndSet(state, state2);
        if (DEBUG) {
            LOG.debug("update {}:{}{}{}", this, state, bl2 ? "-->" : "!->", state2);
        }
        return bl2;
    }

    private boolean isTransitionAllowed(State state, State state2) {
        Set<StateType> set = __stateTransitions.get((Object)state.getType());
        if (!set.contains((Object)state2.getType())) {
            LOG.warn("{}: {} -> {} not allowed", this, state, state2);
            return false;
        }
        return true;
    }

    public Invocable.InvocationType getCallbackInvocationType() {
        State state = this._state.get();
        return state instanceof PendingState ? ((PendingState)state).getCallbackInvocationType() : Invocable.InvocationType.BLOCKING;
    }

    protected abstract void onIncompleteFlush();

    public void write(Callback callback, ByteBuffer ... byteBufferArray) throws WritePendingException {
        Objects.requireNonNull(callback);
        if (this.isFailed()) {
            this.fail(callback, new Throwable[0]);
            return;
        }
        if (DEBUG) {
            LOG.debug("write: {} {}", this, BufferUtil.toDetailString(byteBufferArray));
        }
        if (!this.updateState(__IDLE, __WRITING)) {
            throw new WritePendingException();
        }
        try {
            byteBufferArray = this.flush(byteBufferArray);
            if (byteBufferArray != null) {
                PendingState pendingState;
                if (DEBUG) {
                    LOG.debug("flushed incomplete", new Object[0]);
                }
                if (this.updateState(__WRITING, pendingState = new PendingState(byteBufferArray, callback))) {
                    this.onIncompleteFlush();
                } else {
                    this.fail(callback, new Throwable[0]);
                }
                return;
            }
            if (this.updateState(__WRITING, __IDLE)) {
                callback.succeeded();
            } else {
                this.fail(callback, new Throwable[0]);
            }
        }
        catch (Throwable throwable) {
            if (DEBUG) {
                LOG.debug("write exception", throwable);
            }
            if (this.updateState(__WRITING, new FailedState(throwable))) {
                callback.failed(throwable);
            }
            this.fail(callback, throwable);
        }
    }

    private void fail(Callback callback, Throwable ... throwableArray) {
        Object object;
        block4: while (true) {
            Throwable[] throwableArray2 = this._state.get();
            switch (throwableArray2.getType()) {
                case FAILED: {
                    Object object2 = (FailedState)throwableArray2;
                    object = ((FailedState)object2).getCause();
                    break block4;
                }
                case IDLE: {
                    for (Throwable throwable : throwableArray) {
                        LOG.warn(throwable);
                    }
                    return;
                }
                default: {
                    Object object2 = new IllegalStateException();
                    if (!this._state.compareAndSet((State)throwableArray2, new FailedState((Throwable)object2))) continue block4;
                    object = object2;
                    break block4;
                }
            }
            break;
        }
        for (Throwable throwable : throwableArray) {
            if (throwable == object) continue;
            ((Throwable)object).addSuppressed(throwable);
        }
        callback.failed((Throwable)object);
    }

    public void completeWrite() {
        State state;
        if (DEBUG) {
            LOG.debug("completeWrite: {}", this);
        }
        if ((state = this._state.get()).getType() != StateType.PENDING) {
            return;
        }
        PendingState pendingState = (PendingState)state;
        if (!this.updateState(pendingState, __COMPLETING)) {
            return;
        }
        Callback callback = pendingState._callback;
        try {
            ByteBuffer[] byteBufferArray = pendingState.getBuffers();
            byteBufferArray = this.flush(byteBufferArray);
            if (byteBufferArray != null) {
                if (DEBUG) {
                    LOG.debug("flushed incomplete {}", BufferUtil.toDetailString(byteBufferArray));
                }
                if (byteBufferArray != pendingState.getBuffers()) {
                    pendingState = new PendingState(byteBufferArray, callback);
                }
                if (this.updateState(__COMPLETING, pendingState)) {
                    this.onIncompleteFlush();
                } else {
                    this.fail(callback, new Throwable[0]);
                }
                return;
            }
            if (this.updateState(__COMPLETING, __IDLE)) {
                callback.succeeded();
            } else {
                this.fail(callback, new Throwable[0]);
            }
        }
        catch (Throwable throwable) {
            if (DEBUG) {
                LOG.debug("completeWrite exception", throwable);
            }
            if (this.updateState(__COMPLETING, new FailedState(throwable))) {
                callback.failed(throwable);
            }
            this.fail(callback, throwable);
        }
    }

    protected ByteBuffer[] flush(ByteBuffer[] byteBufferArray) throws IOException {
        boolean bl2 = true;
        while (bl2 && byteBufferArray != null) {
            Connection connection;
            long l2 = BufferUtil.remaining(byteBufferArray);
            boolean bl3 = this._endPoint.flush(byteBufferArray);
            long l3 = BufferUtil.remaining(byteBufferArray);
            long l4 = l2 - l3;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Flushed={} written={} remaining={} {}", bl3, l4, l3, this);
            }
            if (l4 > 0L && (connection = this._endPoint.getConnection()) instanceof Listener) {
                ((Listener)((Object)connection)).onFlushed(l4);
            }
            if (bl3) {
                return null;
            }
            bl2 = l4 > 0L;
            int n2 = 0;
            while (true) {
                if (n2 == byteBufferArray.length) {
                    byteBufferArray = null;
                    n2 = 0;
                    break;
                }
                int n3 = byteBufferArray[n2].remaining();
                if (n3 > 0) break;
                ++n2;
                bl2 = true;
            }
            if (n2 <= 0) continue;
            byteBufferArray = Arrays.copyOfRange(byteBufferArray, n2, byteBufferArray.length);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("!fully flushed {}", this);
        }
        return byteBufferArray == null ? EMPTY_BUFFERS : byteBufferArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onFail(Throwable throwable) {
        block5: while (true) {
            State state = this._state.get();
            switch (state.getType()) {
                case FAILED: 
                case IDLE: {
                    if (!DEBUG) return false;
                    LOG.debug("ignored: " + this, throwable);
                    return false;
                }
                case PENDING: {
                    PendingState pendingState;
                    if (DEBUG) {
                        LOG.debug("failed: " + this, throwable);
                    }
                    if (!this.updateState(pendingState = (PendingState)state, new FailedState(throwable))) continue block5;
                    pendingState._callback.failed(throwable);
                    return true;
                }
                case WRITING: 
                case COMPLETING: {
                    if (DEBUG) {
                        LOG.debug("failed: " + this, throwable);
                    }
                    if (this.updateState(state, new FailedState(throwable))) return true;
                    continue block5;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    public void onClose() {
        switch (this._state.get().getType()) {
            case FAILED: 
            case IDLE: {
                return;
            }
        }
        this.onFail(new ClosedChannelException());
    }

    boolean isFailed() {
        return this.isState(StateType.FAILED);
    }

    private boolean isState(StateType stateType) {
        return this._state.get().getType() == stateType;
    }

    public String toStateString() {
        switch (this._state.get().getType()) {
            case WRITING: {
                return "W";
            }
            case PENDING: {
                return "P";
            }
            case COMPLETING: {
                return "C";
            }
            case IDLE: {
                return "-";
            }
            case FAILED: {
                return "F";
            }
        }
        return "?";
    }

    public String toString() {
        State state = this._state.get();
        return String.format("WriteFlusher@%x{%s}->%s", this.hashCode(), state, state instanceof PendingState ? ((PendingState)state)._callback : null);
    }

    static {
        __stateTransitions.put(StateType.IDLE, EnumSet.of(StateType.WRITING));
        __stateTransitions.put(StateType.WRITING, EnumSet.of(StateType.IDLE, StateType.PENDING, StateType.FAILED));
        __stateTransitions.put(StateType.PENDING, EnumSet.of(StateType.COMPLETING, StateType.IDLE, StateType.FAILED));
        __stateTransitions.put(StateType.COMPLETING, EnumSet.of(StateType.IDLE, StateType.PENDING, StateType.FAILED));
        __stateTransitions.put(StateType.FAILED, EnumSet.noneOf(StateType.class));
    }

    public static interface Listener {
        public void onFlushed(long var1) throws IOException;
    }

    private class PendingState
    extends State {
        private final Callback _callback;
        private final ByteBuffer[] _buffers;

        private PendingState(ByteBuffer[] byteBufferArray, Callback callback) {
            super(StateType.PENDING);
            this._buffers = byteBufferArray;
            this._callback = callback;
        }

        public ByteBuffer[] getBuffers() {
            return this._buffers;
        }

        Invocable.InvocationType getCallbackInvocationType() {
            return Invocable.getInvocationType(this._callback);
        }
    }

    private static class CompletingState
    extends State {
        private CompletingState() {
            super(StateType.COMPLETING);
        }
    }

    private static class FailedState
    extends State {
        private final Throwable _cause;

        private FailedState(Throwable throwable) {
            super(StateType.FAILED);
            this._cause = throwable;
        }

        public Throwable getCause() {
            return this._cause;
        }
    }

    private static class WritingState
    extends State {
        private WritingState() {
            super(StateType.WRITING);
        }
    }

    private static class IdleState
    extends State {
        private IdleState() {
            super(StateType.IDLE);
        }
    }

    private static class State {
        private final StateType _type;

        private State(StateType stateType) {
            this._type = stateType;
        }

        public StateType getType() {
            return this._type;
        }

        public String toString() {
            return String.format("%s", new Object[]{this._type});
        }
    }

    private static enum StateType {
        IDLE,
        WRITING,
        PENDING,
        COMPLETING,
        FAILED;

    }
}

