/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.ByteBufferPool;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.BufferUtil;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;

public class RetainableByteBuffer {
    private final ByteBufferPool pool;
    private final ByteBuffer buffer;
    private final AtomicInteger references;

    public RetainableByteBuffer(ByteBufferPool byteBufferPool, int n2, boolean bl2) {
        this.pool = byteBufferPool;
        this.buffer = byteBufferPool.acquire(n2, bl2);
        this.references = new AtomicInteger(1);
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public int getReferences() {
        return this.references.get();
    }

    public void retain() {
        int n2;
        do {
            if ((n2 = this.references.get()) != 0) continue;
            throw new IllegalStateException("released " + this);
        } while (!this.references.compareAndSet(n2, n2 + 1));
    }

    public int release() {
        int n2 = this.references.decrementAndGet();
        if (n2 == 0) {
            this.pool.release(this.buffer);
        } else if (n2 < 0) {
            throw new IllegalStateException("already released " + this);
        }
        return n2;
    }

    public int remaining() {
        return this.buffer.remaining();
    }

    public boolean hasRemaining() {
        return this.remaining() > 0;
    }

    public boolean isEmpty() {
        return !this.hasRemaining();
    }

    public void clear() {
        BufferUtil.clear(this.buffer);
    }

    public String toString() {
        return String.format("%s@%x{%s,r=%d}", this.getClass().getSimpleName(), this.hashCode(), BufferUtil.toDetailString(this.buffer), this.getReferences());
    }
}

