/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpField;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpFields;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpURI;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpVersion;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Supplier;

public class MetaData
implements Iterable<HttpField> {
    private HttpVersion _httpVersion;
    private final HttpFields _fields;
    private long _contentLength;
    private Supplier<HttpFields> _trailers;

    public MetaData(HttpVersion httpVersion, HttpFields httpFields, long l2) {
        this._httpVersion = httpVersion;
        this._fields = httpFields;
        this._contentLength = l2;
    }

    public HttpVersion getHttpVersion() {
        return this._httpVersion;
    }

    public HttpFields getFields() {
        return this._fields;
    }

    public Supplier<HttpFields> getTrailerSupplier() {
        return this._trailers;
    }

    public void setTrailerSupplier(Supplier<HttpFields> supplier) {
        this._trailers = supplier;
    }

    public long getContentLength() {
        if (this._contentLength == Long.MIN_VALUE && this._fields != null) {
            HttpField httpField = this._fields.getField(HttpHeader.CONTENT_LENGTH);
            this._contentLength = httpField == null ? -1L : httpField.getLongValue();
        }
        return this._contentLength;
    }

    @Override
    public Iterator<HttpField> iterator() {
        HttpFields httpFields = this.getFields();
        return httpFields == null ? Collections.emptyIterator() : httpFields.iterator();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (HttpField httpField : this) {
            stringBuilder.append(httpField).append(System.lineSeparator());
        }
        return stringBuilder.toString();
    }

    public static class Response
    extends MetaData {
        private int _status;
        private String _reason;

        public Response() {
            this(null, 0, null);
        }

        public Response(HttpVersion httpVersion, int n2, HttpFields httpFields) {
            this(httpVersion, n2, httpFields, Long.MIN_VALUE);
        }

        public Response(HttpVersion httpVersion, int n2, HttpFields httpFields, long l2) {
            super(httpVersion, httpFields, l2);
            this._status = n2;
        }

        public Response(HttpVersion httpVersion, int n2, String string, HttpFields httpFields, long l2) {
            super(httpVersion, httpFields, l2);
            this._reason = string;
            this._status = n2;
        }

        public int getStatus() {
            return this._status;
        }

        @Override
        public String toString() {
            HttpFields httpFields = this.getFields();
            return String.format("%s{s=%d,h=%d,cl=%d}", new Object[]{this.getHttpVersion(), this.getStatus(), httpFields == null ? -1 : httpFields.size(), this.getContentLength()});
        }
    }

    public static class Request
    extends MetaData {
        private String _method;
        private HttpURI _uri;

        public Request(String string, HttpURI httpURI, HttpVersion httpVersion, HttpFields httpFields, long l2) {
            super(httpVersion, httpFields, l2);
            this._method = string;
            this._uri = httpURI;
        }

        public String getMethod() {
            return this._method;
        }

        public HttpURI getURI() {
            return this._uri;
        }

        public String getURIString() {
            return this._uri == null ? null : this._uri.toString();
        }

        @Override
        public String toString() {
            HttpFields httpFields = this.getFields();
            return String.format("%s{u=%s,%s,h=%d,cl=%d}", new Object[]{this.getMethod(), this.getURI(), this.getHttpVersion(), httpFields == null ? -1 : httpFields.size(), this.getContentLength()});
        }
    }
}

