/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.TypeUtil;

public class HttpTokens {
    static final byte[] CRLF = new byte[]{13, 10};
    public static final Token[] TOKENS = new Token[256];

    static {
        block8: for (int i2 = 0; i2 < 256; ++i2) {
            switch (i2) {
                case 10: {
                    HttpTokens.TOKENS[i2] = new Token((byte)i2, Type.LF);
                    continue block8;
                }
                case 13: {
                    HttpTokens.TOKENS[i2] = new Token((byte)i2, Type.CR);
                    continue block8;
                }
                case 32: {
                    HttpTokens.TOKENS[i2] = new Token((byte)i2, Type.SPACE);
                    continue block8;
                }
                case 9: {
                    HttpTokens.TOKENS[i2] = new Token((byte)i2, Type.HTAB);
                    continue block8;
                }
                case 58: {
                    HttpTokens.TOKENS[i2] = new Token((byte)i2, Type.COLON);
                    continue block8;
                }
                case 33: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 42: 
                case 43: 
                case 45: 
                case 46: 
                case 94: 
                case 95: 
                case 96: 
                case 124: 
                case 126: {
                    HttpTokens.TOKENS[i2] = new Token((byte)i2, Type.TCHAR);
                    continue block8;
                }
                default: {
                    HttpTokens.TOKENS[i2] = i2 >= 48 && i2 <= 57 ? new Token((byte)i2, Type.DIGIT) : (i2 >= 65 && i2 <= 90 ? new Token((byte)i2, Type.ALPHA) : (i2 >= 97 && i2 <= 122 ? new Token((byte)i2, Type.ALPHA) : (i2 >= 33 && i2 <= 126 ? new Token((byte)i2, Type.VCHAR) : (i2 >= 128 ? new Token((byte)i2, Type.OTEXT) : new Token((byte)i2, Type.CNTL)))));
                }
            }
        }
    }

    public static class Token {
        private final Type _type;
        private final byte _b;
        private final char _c;
        private final int _x;

        private Token(byte by2, Type type) {
            this._type = type;
            this._b = by2;
            this._c = (char)(0xFF & by2);
            char c2 = this._c >= 'A' & this._c <= 'Z' ? (char)(this._c - 65 + 97) : this._c;
            this._x = this._type == Type.DIGIT || this._type == Type.ALPHA && c2 >= 'a' && c2 <= 'f' ? TypeUtil.convertHexDigit(by2) : -1;
        }

        public Type getType() {
            return this._type;
        }

        public byte getByte() {
            return this._b;
        }

        public char getChar() {
            return this._c;
        }

        public boolean isHexDigit() {
            return this._x >= 0;
        }

        public int getHexDigit() {
            return this._x;
        }

        public String toString() {
            switch (this._type) {
                case SPACE: 
                case COLON: 
                case ALPHA: 
                case DIGIT: 
                case TCHAR: 
                case VCHAR: {
                    return (Object)((Object)this._type) + "='" + this._c + "'";
                }
                case CR: {
                    return "CR=\\r";
                }
                case LF: {
                    return "LF=\\n";
                }
            }
            return String.format("%s=0x%x", new Object[]{this._type, this._b});
        }
    }

    public static enum Type {
        CNTL,
        HTAB,
        LF,
        CR,
        SPACE,
        COLON,
        DIGIT,
        ALPHA,
        TCHAR,
        VCHAR,
        OTEXT;

    }

    public static enum EndOfContent {
        UNKNOWN_CONTENT,
        NO_CONTENT,
        EOF_CONTENT,
        CONTENT_LENGTH,
        CHUNKED_CONTENT;

    }
}

