/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.AuthenticationProtocolHandler;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpClient;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpDestination;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.ProxyConfiguration;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.api.Request;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.api.Response;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpHeader;
import java.net.URI;

public class ProxyAuthenticationProtocolHandler
extends AuthenticationProtocolHandler {
    private static final String ATTRIBUTE = ProxyAuthenticationProtocolHandler.class.getName() + ".attribute";

    public ProxyAuthenticationProtocolHandler(HttpClient httpClient) {
        this(httpClient, 16384);
    }

    public ProxyAuthenticationProtocolHandler(HttpClient httpClient, int n2) {
        super(httpClient, n2);
    }

    @Override
    public String getName() {
        return "proxy-authenticate";
    }

    @Override
    public boolean accept(Request request, Response response) {
        return response.getStatus() == 407;
    }

    @Override
    protected HttpHeader getAuthenticateHeader() {
        return HttpHeader.PROXY_AUTHENTICATE;
    }

    @Override
    protected HttpHeader getAuthorizationHeader() {
        return HttpHeader.PROXY_AUTHORIZATION;
    }

    @Override
    protected URI getAuthenticationURI(Request request) {
        HttpDestination httpDestination = this.getHttpClient().destinationFor(request.getScheme(), request.getHost(), request.getPort());
        ProxyConfiguration.Proxy proxy = httpDestination.getProxy();
        return proxy != null ? proxy.getURI() : request.getURI();
    }

    @Override
    protected String getAuthenticationAttribute() {
        return ATTRIBUTE;
    }
}

