/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.archivers.tar;

import com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.archivers.ArchiveEntry;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.archivers.tar.TarArchiveStructSparse;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.archivers.tar.TarUtils;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.archivers.zip.ZipEncoding;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.utils.ArchiveUtils;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.utils.IOUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public class TarArchiveEntry
implements ArchiveEntry {
    private static final TarArchiveEntry[] EMPTY_TAR_ARCHIVE_ENTRY_ARRAY = new TarArchiveEntry[0];
    private String name = "";
    private final boolean preserveAbsolutePath;
    private int mode;
    private long userId;
    private long groupId;
    private long size;
    private long modTime;
    private boolean checkSumOK;
    private byte linkFlag;
    private String linkName = "";
    private String magic = "ustar\u0000";
    private String version = "00";
    private String userName;
    private String groupName = "";
    private int devMajor;
    private int devMinor;
    private List<TarArchiveStructSparse> sparseHeaders;
    private boolean isExtended;
    private long realSize;
    private boolean paxGNUSparse;
    private boolean paxGNU1XSparse;
    private boolean starSparse;
    private final Path file;
    private final LinkOption[] linkOptions;
    private final Map<String, String> extraPaxHeaders = new HashMap<String, String>();
    private long dataOffset = -1L;

    private TarArchiveEntry(boolean bl2) {
        String string = System.getProperty("user.name", "");
        if (string.length() > 31) {
            string = string.substring(0, 31);
        }
        this.userName = string;
        this.file = null;
        this.linkOptions = IOUtils.EMPTY_LINK_OPTIONS;
        this.preserveAbsolutePath = bl2;
    }

    public TarArchiveEntry(String string) {
        this(string, false);
    }

    public TarArchiveEntry(String string, boolean bl2) {
        this(bl2);
        string = TarArchiveEntry.normalizeFileName(string, bl2);
        boolean bl3 = string.endsWith("/");
        this.name = string;
        this.mode = bl3 ? 16877 : 33188;
        this.linkFlag = (byte)(bl3 ? 53 : 48);
        this.modTime = System.currentTimeMillis() / 1000L;
        this.userName = "";
    }

    public TarArchiveEntry(String string, byte by2) {
        this(string, by2, false);
    }

    public TarArchiveEntry(String string, byte by2, boolean bl2) {
        this(string, bl2);
        this.linkFlag = by2;
        if (by2 == 76) {
            this.magic = "ustar ";
            this.version = " \u0000";
        }
    }

    public TarArchiveEntry(byte[] byArray, ZipEncoding zipEncoding, boolean bl2) throws IOException {
        this(false);
        this.parseTarHeader(byArray, zipEncoding, false, bl2);
    }

    public boolean equals(TarArchiveEntry tarArchiveEntry) {
        return tarArchiveEntry != null && this.getName().equals(tarArchiveEntry.getName());
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.equals((TarArchiveEntry)object);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = TarArchiveEntry.normalizeFileName(string, this.preserveAbsolutePath);
    }

    public void setMode(int n2) {
        this.mode = n2;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public void setLinkName(String string) {
        this.linkName = string;
    }

    public long getLongUserId() {
        return this.userId;
    }

    public void setUserId(long l2) {
        this.userId = l2;
    }

    public long getLongGroupId() {
        return this.groupId;
    }

    public void setGroupId(long l2) {
        this.groupId = l2;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public void setGroupName(String string) {
        this.groupName = string;
    }

    public void setModTime(long l2) {
        this.modTime = l2 / 1000L;
    }

    public void setModTime(Date date) {
        this.modTime = date.getTime() / 1000L;
    }

    public Date getModTime() {
        return new Date(this.modTime * 1000L);
    }

    public int getMode() {
        return this.mode;
    }

    public long getSize() {
        return this.size;
    }

    public void setSparseHeaders(List<TarArchiveStructSparse> list) {
        this.sparseHeaders = list;
    }

    public List<TarArchiveStructSparse> getSparseHeaders() {
        return this.sparseHeaders;
    }

    public List<TarArchiveStructSparse> getOrderedSparseHeaders() throws IOException {
        TarArchiveStructSparse tarArchiveStructSparse2;
        if (this.sparseHeaders == null || this.sparseHeaders.isEmpty()) {
            return Collections.emptyList();
        }
        List<TarArchiveStructSparse> list = this.sparseHeaders.stream().filter(tarArchiveStructSparse -> tarArchiveStructSparse.getOffset() > 0L || tarArchiveStructSparse.getNumbytes() > 0L).sorted(Comparator.comparingLong(TarArchiveStructSparse::getOffset)).collect(Collectors.toList());
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            TarArchiveStructSparse tarArchiveStructSparse3 = (TarArchiveStructSparse)list.get(i2);
            if (i2 + 1 < n2 && tarArchiveStructSparse3.getOffset() + tarArchiveStructSparse3.getNumbytes() > list.get(i2 + 1).getOffset()) {
                throw new IOException("Corrupted TAR archive. Sparse blocks for " + this.getName() + " overlap each other.");
            }
            if (tarArchiveStructSparse3.getOffset() + tarArchiveStructSparse3.getNumbytes() >= 0L) continue;
            throw new IOException("Unreadable TAR archive. Offset and numbytes for sparse block in " + this.getName() + " too large.");
        }
        if (!list.isEmpty() && (tarArchiveStructSparse2 = list.get(n2 - 1)).getOffset() + tarArchiveStructSparse2.getNumbytes() > this.getRealSize()) {
            throw new IOException("Corrupted TAR archive. Sparse block extends beyond real size of the entry");
        }
        return list;
    }

    public boolean isPaxGNU1XSparse() {
        return this.paxGNU1XSparse;
    }

    public void setSize(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Size is out of range: " + l2);
        }
        this.size = l2;
    }

    public int getDevMajor() {
        return this.devMajor;
    }

    public void setDevMajor(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Major device number is out of range: " + n2);
        }
        this.devMajor = n2;
    }

    public int getDevMinor() {
        return this.devMinor;
    }

    public void setDevMinor(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Minor device number is out of range: " + n2);
        }
        this.devMinor = n2;
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    public long getRealSize() {
        if (!this.isSparse()) {
            return this.getSize();
        }
        return this.realSize;
    }

    public boolean isGNUSparse() {
        return this.isOldGNUSparse() || this.isPaxGNUSparse();
    }

    public boolean isOldGNUSparse() {
        return this.linkFlag == 83;
    }

    public boolean isPaxGNUSparse() {
        return this.paxGNUSparse;
    }

    public boolean isStarSparse() {
        return this.starSparse;
    }

    public boolean isGNULongLinkEntry() {
        return this.linkFlag == 75;
    }

    public boolean isGNULongNameEntry() {
        return this.linkFlag == 76;
    }

    public boolean isPaxHeader() {
        return this.linkFlag == 120 || this.linkFlag == 88;
    }

    public boolean isGlobalPaxHeader() {
        return this.linkFlag == 103;
    }

    public boolean isDirectory() {
        if (this.file != null) {
            return Files.isDirectory(this.file, this.linkOptions);
        }
        if (this.linkFlag == 53) {
            return true;
        }
        return !this.isPaxHeader() && !this.isGlobalPaxHeader() && this.getName().endsWith("/");
    }

    public boolean isFile() {
        if (this.file != null) {
            return Files.isRegularFile(this.file, this.linkOptions);
        }
        if (this.linkFlag == 0 || this.linkFlag == 48) {
            return true;
        }
        return !this.getName().endsWith("/");
    }

    public boolean isSymbolicLink() {
        return this.linkFlag == 50;
    }

    public boolean isLink() {
        return this.linkFlag == 49;
    }

    public boolean isCharacterDevice() {
        return this.linkFlag == 51;
    }

    public boolean isBlockDevice() {
        return this.linkFlag == 52;
    }

    public boolean isFIFO() {
        return this.linkFlag == 54;
    }

    public boolean isSparse() {
        return this.isGNUSparse() || this.isStarSparse();
    }

    public Map<String, String> getExtraPaxHeaders() {
        return Collections.unmodifiableMap(this.extraPaxHeaders);
    }

    void updateEntryFromPaxHeaders(Map<String, String> map) throws IOException {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            this.processPaxHeader(string, string2, map);
        }
    }

    private void processPaxHeader(String string, String string2, Map<String, String> map) throws IOException {
        switch (string) {
            case "path": {
                this.setName(string2);
                break;
            }
            case "linkpath": {
                this.setLinkName(string2);
                break;
            }
            case "gid": {
                this.setGroupId(Long.parseLong(string2));
                break;
            }
            case "gname": {
                this.setGroupName(string2);
                break;
            }
            case "uid": {
                this.setUserId(Long.parseLong(string2));
                break;
            }
            case "uname": {
                this.setUserName(string2);
                break;
            }
            case "size": {
                long l2 = Long.parseLong(string2);
                if (l2 < 0L) {
                    throw new IOException("Corrupted TAR archive. Entry size is negative");
                }
                this.setSize(l2);
                break;
            }
            case "mtime": {
                this.setModTime((long)(Double.parseDouble(string2) * 1000.0));
                break;
            }
            case "SCHILY.devminor": {
                int n2 = Integer.parseInt(string2);
                if (n2 < 0) {
                    throw new IOException("Corrupted TAR archive. Dev-Minor is negative");
                }
                this.setDevMinor(n2);
                break;
            }
            case "SCHILY.devmajor": {
                int n3 = Integer.parseInt(string2);
                if (n3 < 0) {
                    throw new IOException("Corrupted TAR archive. Dev-Major is negative");
                }
                this.setDevMajor(n3);
                break;
            }
            case "GNU.sparse.size": {
                this.fillGNUSparse0xData(map);
                break;
            }
            case "GNU.sparse.realsize": {
                this.fillGNUSparse1xData(map);
                break;
            }
            case "SCHILY.filetype": {
                if (!"sparse".equals(string2)) break;
                this.fillStarSparseData(map);
                break;
            }
            default: {
                this.extraPaxHeaders.put(string, string2);
            }
        }
    }

    public void writeEntryHeader(byte[] byArray, ZipEncoding zipEncoding, boolean bl2) throws IOException {
        int n2 = 0;
        n2 = TarUtils.formatNameBytes(this.name, byArray, n2, 100, zipEncoding);
        n2 = this.writeEntryHeaderField(this.mode, byArray, n2, 8, bl2);
        n2 = this.writeEntryHeaderField(this.userId, byArray, n2, 8, bl2);
        n2 = this.writeEntryHeaderField(this.groupId, byArray, n2, 8, bl2);
        n2 = this.writeEntryHeaderField(this.size, byArray, n2, 12, bl2);
        int n3 = n2 = this.writeEntryHeaderField(this.modTime, byArray, n2, 12, bl2);
        for (int i2 = 0; i2 < 8; ++i2) {
            byArray[n2++] = 32;
        }
        byArray[n2++] = this.linkFlag;
        n2 = TarUtils.formatNameBytes(this.linkName, byArray, n2, 100, zipEncoding);
        n2 = TarUtils.formatNameBytes(this.magic, byArray, n2, 6);
        n2 = TarUtils.formatNameBytes(this.version, byArray, n2, 2);
        n2 = TarUtils.formatNameBytes(this.userName, byArray, n2, 32, zipEncoding);
        n2 = TarUtils.formatNameBytes(this.groupName, byArray, n2, 32, zipEncoding);
        n2 = this.writeEntryHeaderField(this.devMajor, byArray, n2, 8, bl2);
        n2 = this.writeEntryHeaderField(this.devMinor, byArray, n2, 8, bl2);
        while (n2 < byArray.length) {
            byArray[n2++] = 0;
        }
        long l2 = TarUtils.computeCheckSum(byArray);
        TarUtils.formatCheckSumOctalBytes(l2, byArray, n3, 8);
    }

    private int writeEntryHeaderField(long l2, byte[] byArray, int n2, int n3, boolean bl2) {
        if (!(bl2 || l2 >= 0L && l2 < 1L << 3 * (n3 - 1))) {
            return TarUtils.formatLongOctalBytes(0L, byArray, n2, n3);
        }
        return TarUtils.formatLongOctalOrBinaryBytes(l2, byArray, n2, n3);
    }

    private void parseTarHeader(byte[] byArray, ZipEncoding zipEncoding, boolean bl2, boolean bl3) throws IOException {
        try {
            this.parseTarHeaderUnwrapped(byArray, zipEncoding, bl2, bl3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("Corrupted TAR archive.", illegalArgumentException);
        }
    }

    private void parseTarHeaderUnwrapped(byte[] byArray, ZipEncoding zipEncoding, boolean bl2, boolean bl3) throws IOException {
        int n2 = 0;
        this.name = bl2 ? TarUtils.parseName(byArray, n2, 100) : TarUtils.parseName(byArray, n2, 100, zipEncoding);
        this.mode = (int)this.parseOctalOrBinary(byArray, n2 += 100, 8, bl3);
        this.userId = (int)this.parseOctalOrBinary(byArray, n2 += 8, 8, bl3);
        this.groupId = (int)this.parseOctalOrBinary(byArray, n2 += 8, 8, bl3);
        this.size = TarUtils.parseOctalOrBinary(byArray, n2 += 8, 12);
        if (this.size < 0L) {
            throw new IOException("broken archive, entry with negative size");
        }
        this.modTime = this.parseOctalOrBinary(byArray, n2 += 12, 12, bl3);
        n2 += 12;
        this.checkSumOK = TarUtils.verifyCheckSum(byArray);
        n2 += 8;
        this.linkFlag = byArray[n2++];
        this.linkName = bl2 ? TarUtils.parseName(byArray, n2, 100) : TarUtils.parseName(byArray, n2, 100, zipEncoding);
        this.magic = TarUtils.parseName(byArray, n2 += 100, 6);
        this.version = TarUtils.parseName(byArray, n2 += 6, 2);
        this.userName = bl2 ? TarUtils.parseName(byArray, n2, 32) : TarUtils.parseName(byArray, n2 += 2, 32, zipEncoding);
        this.groupName = bl2 ? TarUtils.parseName(byArray, n2, 32) : TarUtils.parseName(byArray, n2 += 32, 32, zipEncoding);
        n2 += 32;
        if (this.linkFlag == 51 || this.linkFlag == 52) {
            this.devMajor = (int)this.parseOctalOrBinary(byArray, n2, 8, bl3);
            this.devMinor = (int)this.parseOctalOrBinary(byArray, n2 += 8, 8, bl3);
            n2 += 8;
        } else {
            n2 += 16;
        }
        int n3 = this.evaluateType(byArray);
        switch (n3) {
            case 2: {
                n2 += 12;
                n2 += 12;
                n2 += 12;
                n2 += 4;
                this.sparseHeaders = new ArrayList<TarArchiveStructSparse>(TarUtils.readSparseStructs(byArray, ++n2, 4));
                this.isExtended = TarUtils.parseBoolean(byArray, n2 += 96);
                this.realSize = TarUtils.parseOctal(byArray, ++n2, 12);
                n2 += 12;
                break;
            }
            case 4: {
                String string;
                String string2 = string = bl2 ? TarUtils.parseName(byArray, n2, 131) : TarUtils.parseName(byArray, n2, 131, zipEncoding);
                if (string.isEmpty()) break;
                this.name = string + "/" + this.name;
                break;
            }
            default: {
                String string;
                String string3 = string = bl2 ? TarUtils.parseName(byArray, n2, 155) : TarUtils.parseName(byArray, n2, 155, zipEncoding);
                if (this.isDirectory() && !this.name.endsWith("/")) {
                    this.name = this.name + "/";
                }
                if (string.isEmpty()) break;
                this.name = string + "/" + this.name;
            }
        }
    }

    private long parseOctalOrBinary(byte[] byArray, int n2, int n3, boolean bl2) {
        if (bl2) {
            try {
                return TarUtils.parseOctalOrBinary(byArray, n2, n3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1L;
            }
        }
        return TarUtils.parseOctalOrBinary(byArray, n2, n3);
    }

    private static String normalizeFileName(String string, boolean bl2) {
        String string2;
        if (!bl2 && (string2 = System.getProperty("os.name").toLowerCase(Locale.ENGLISH)) != null) {
            int n2;
            if (string2.startsWith("windows")) {
                if (string.length() > 2) {
                    n2 = string.charAt(0);
                    char c2 = string.charAt(1);
                    if (c2 == ':' && (n2 >= 97 && n2 <= 122 || n2 >= 65 && n2 <= 90)) {
                        string = string.substring(2);
                    }
                }
            } else if (string2.contains("netware") && (n2 = string.indexOf(58)) != -1) {
                string = string.substring(n2 + 1);
            }
        }
        string = string.replace(File.separatorChar, '/');
        while (!bl2 && string.startsWith("/")) {
            string = string.substring(1);
        }
        return string;
    }

    private int evaluateType(byte[] byArray) {
        if (ArchiveUtils.matchAsciiBuffer("ustar ", byArray, 257, 6)) {
            return 2;
        }
        if (ArchiveUtils.matchAsciiBuffer("ustar\u0000", byArray, 257, 6)) {
            if (ArchiveUtils.matchAsciiBuffer("tar\u0000", byArray, 508, 4)) {
                return 4;
            }
            return 3;
        }
        return 0;
    }

    void fillGNUSparse0xData(Map<String, String> map) {
        this.paxGNUSparse = true;
        this.realSize = Integer.parseInt(map.get("GNU.sparse.size"));
        if (map.containsKey("GNU.sparse.name")) {
            this.name = map.get("GNU.sparse.name");
        }
    }

    void fillGNUSparse1xData(Map<String, String> map) throws IOException {
        this.paxGNUSparse = true;
        this.paxGNU1XSparse = true;
        if (map.containsKey("GNU.sparse.name")) {
            this.name = map.get("GNU.sparse.name");
        }
        if (map.containsKey("GNU.sparse.realsize")) {
            try {
                this.realSize = Integer.parseInt(map.get("GNU.sparse.realsize"));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Corrupted TAR archive. GNU.sparse.realsize header for " + this.name + " contains non-numeric value");
            }
        }
    }

    void fillStarSparseData(Map<String, String> map) throws IOException {
        this.starSparse = true;
        if (map.containsKey("SCHILY.realsize")) {
            try {
                this.realSize = Long.parseLong(map.get("SCHILY.realsize"));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Corrupted TAR archive. SCHILY.realsize header for " + this.name + " contains non-numeric value");
            }
        }
    }
}

