/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ser.std;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.SerializationFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;

public abstract class DateTimeSerializerBase<T>
extends StdScalarSerializer<T>
implements ContextualSerializer {
    protected final Boolean _useTimestamp;
    protected final DateFormat _customFormat;
    protected final AtomicReference<DateFormat> _reusedCustomFormat;

    protected DateTimeSerializerBase(Class<T> clazz, Boolean bl2, DateFormat dateFormat) {
        super(clazz);
        this._useTimestamp = bl2;
        this._customFormat = dateFormat;
        this._reusedCustomFormat = dateFormat == null ? null : new AtomicReference();
    }

    public abstract DateTimeSerializerBase<T> withFormat(Boolean var1, DateFormat var2);

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        boolean bl2;
        boolean bl3;
        JsonFormat.Value value = this.findFormatOverrides(serializerProvider, beanProperty, this.handledType());
        if (value == null) {
            return this;
        }
        JsonFormat.Shape shape = value.getShape();
        if (shape.isNumeric()) {
            return this.withFormat(Boolean.TRUE, null);
        }
        if (value.hasPattern()) {
            Locale locale = value.hasLocale() ? value.getLocale() : serializerProvider.getLocale();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(value.getPattern(), locale);
            TimeZone timeZone = value.hasTimeZone() ? value.getTimeZone() : serializerProvider.getTimeZone();
            simpleDateFormat.setTimeZone(timeZone);
            return this.withFormat(Boolean.FALSE, simpleDateFormat);
        }
        boolean bl4 = value.hasLocale();
        boolean bl5 = value.hasTimeZone();
        boolean bl6 = bl3 = shape == JsonFormat.Shape.STRING;
        if (!(bl4 || bl5 || bl3)) {
            return this;
        }
        DateFormat dateFormat = serializerProvider.getConfig().getDateFormat();
        if (dateFormat instanceof StdDateFormat) {
            StdDateFormat stdDateFormat = (StdDateFormat)dateFormat;
            if (value.hasLocale()) {
                stdDateFormat = stdDateFormat.withLocale(value.getLocale());
            }
            if (value.hasTimeZone()) {
                stdDateFormat = stdDateFormat.withTimeZone(value.getTimeZone());
            }
            return this.withFormat(Boolean.FALSE, stdDateFormat);
        }
        if (!(dateFormat instanceof SimpleDateFormat)) {
            serializerProvider.reportBadDefinition(this.handledType(), String.format("Configured `DateFormat` (%s) not a `SimpleDateFormat`; cannot configure `Locale` or `TimeZone`", dateFormat.getClass().getName()));
        }
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)dateFormat;
        simpleDateFormat = bl4 ? new SimpleDateFormat(simpleDateFormat.toPattern(), value.getLocale()) : (SimpleDateFormat)simpleDateFormat.clone();
        TimeZone timeZone = value.getTimeZone();
        boolean bl7 = bl2 = timeZone != null && !timeZone.equals(simpleDateFormat.getTimeZone());
        if (bl2) {
            simpleDateFormat.setTimeZone(timeZone);
        }
        return this.withFormat(Boolean.FALSE, simpleDateFormat);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, T t2) {
        return false;
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        return this.createSchemaNode(this._asTimestamp(serializerProvider) ? "number" : "string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        this._acceptJsonFormatVisitor(jsonFormatVisitorWrapper, javaType, this._asTimestamp(jsonFormatVisitorWrapper.getProvider()));
    }

    protected boolean _asTimestamp(SerializerProvider serializerProvider) {
        if (this._useTimestamp != null) {
            return this._useTimestamp;
        }
        if (this._customFormat == null) {
            if (serializerProvider != null) {
                return serializerProvider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            }
            throw new IllegalArgumentException("Null SerializerProvider passed for " + this.handledType().getName());
        }
        return false;
    }

    protected void _acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType, boolean bl2) throws JsonMappingException {
        if (bl2) {
            this.visitIntFormat(jsonFormatVisitorWrapper, javaType, JsonParser.NumberType.LONG, JsonValueFormat.UTC_MILLISEC);
        } else {
            this.visitStringFormat(jsonFormatVisitorWrapper, javaType, JsonValueFormat.DATE_TIME);
        }
    }

    protected void _serializeAsString(Date date, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this._customFormat == null) {
            serializerProvider.defaultSerializeDateValue(date, jsonGenerator);
            return;
        }
        DateFormat dateFormat = this._reusedCustomFormat.getAndSet(null);
        if (dateFormat == null) {
            dateFormat = (DateFormat)this._customFormat.clone();
        }
        jsonGenerator.writeString(dateFormat.format(date));
        this._reusedCustomFormat.compareAndSet(null, dateFormat);
    }
}

