/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.std;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.type.ArrayType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.type.LogicalType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.AccessPattern;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.ObjectBuffer;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Objects;

@JacksonStdImpl
public class ObjectArrayDeserializer
extends ContainerDeserializerBase<Object[]>
implements ContextualDeserializer {
    protected final boolean _untyped;
    protected final Class<?> _elementClass;
    protected JsonDeserializer<Object> _elementDeserializer;
    protected final TypeDeserializer _elementTypeDeserializer;
    protected final Object[] _emptyValue;

    public ObjectArrayDeserializer(JavaType javaType, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer) {
        super(javaType, null, null);
        ArrayType arrayType = (ArrayType)javaType;
        this._elementClass = arrayType.getContentType().getRawClass();
        this._untyped = this._elementClass == Object.class;
        this._elementDeserializer = jsonDeserializer;
        this._elementTypeDeserializer = typeDeserializer;
        this._emptyValue = arrayType.getEmptyArray();
    }

    protected ObjectArrayDeserializer(ObjectArrayDeserializer objectArrayDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer, NullValueProvider nullValueProvider, Boolean bl2) {
        super(objectArrayDeserializer, nullValueProvider, bl2);
        this._elementClass = objectArrayDeserializer._elementClass;
        this._untyped = objectArrayDeserializer._untyped;
        this._emptyValue = objectArrayDeserializer._emptyValue;
        this._elementDeserializer = jsonDeserializer;
        this._elementTypeDeserializer = typeDeserializer;
    }

    public ObjectArrayDeserializer withResolved(TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer, NullValueProvider nullValueProvider, Boolean bl2) {
        if (Objects.equals(bl2, this._unwrapSingle) && nullValueProvider == this._nullProvider && jsonDeserializer == this._elementDeserializer && typeDeserializer == this._elementTypeDeserializer) {
            return this;
        }
        return new ObjectArrayDeserializer(this, jsonDeserializer, typeDeserializer, nullValueProvider, bl2);
    }

    @Override
    public boolean isCachable() {
        return this._elementDeserializer == null && this._elementTypeDeserializer == null;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Array;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer = this._elementDeserializer;
        Boolean bl2 = this.findFormatFeature(deserializationContext, beanProperty, this._containerType.getRawClass(), JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        jsonDeserializer = this.findConvertingContentDeserializer(deserializationContext, beanProperty, jsonDeserializer);
        JavaType javaType = this._containerType.getContentType();
        jsonDeserializer = jsonDeserializer == null ? deserializationContext.findContextualValueDeserializer(javaType, beanProperty) : deserializationContext.handleSecondaryContextualization(jsonDeserializer, beanProperty, javaType);
        TypeDeserializer typeDeserializer = this._elementTypeDeserializer;
        if (typeDeserializer != null) {
            typeDeserializer = typeDeserializer.forProperty(beanProperty);
        }
        NullValueProvider nullValueProvider = this.findContentNullProvider(deserializationContext, beanProperty, jsonDeserializer);
        return this.withResolved(typeDeserializer, jsonDeserializer, nullValueProvider, bl2);
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        return this._elementDeserializer;
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.CONSTANT;
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) throws JsonMappingException {
        return this._emptyValue;
    }

    @Override
    public Object[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Object object;
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext);
        }
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        Object[] objectArray = objectBuffer.resetAndStart();
        int n2 = 0;
        TypeDeserializer typeDeserializer = this._elementTypeDeserializer;
        try {
            JsonToken jsonToken;
            while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                if (jsonToken == JsonToken.VALUE_NULL) {
                    if (this._skipNullValues) continue;
                    object = this._nullProvider.getNullValue(deserializationContext);
                } else {
                    object = typeDeserializer == null ? this._elementDeserializer.deserialize(jsonParser, deserializationContext) : this._elementDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer);
                }
                if (n2 >= objectArray.length) {
                    objectArray = objectBuffer.appendCompletedChunk(objectArray);
                    n2 = 0;
                }
                objectArray[n2++] = object;
            }
        }
        catch (Exception exception) {
            throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)objectArray, objectBuffer.bufferedSize() + n2);
        }
        object = this._untyped ? objectBuffer.completeAndClearBuffer(objectArray, n2) : objectBuffer.completeAndClearBuffer(objectArray, n2, this._elementClass);
        deserializationContext.returnObjectBuffer(objectBuffer);
        return object;
    }

    public Object[] deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return (Object[])typeDeserializer.deserializeTypedFromArray(jsonParser, deserializationContext);
    }

    @Override
    public Object[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Object[] objectArray) throws IOException {
        Object object;
        if (!jsonParser.isExpectedStartArrayToken()) {
            Object[] objectArray2 = this.handleNonArray(jsonParser, deserializationContext);
            if (objectArray2 == null) {
                return objectArray;
            }
            int n2 = objectArray.length;
            Object[] objectArray3 = new Object[n2 + objectArray2.length];
            System.arraycopy(objectArray, 0, objectArray3, 0, n2);
            System.arraycopy(objectArray2, 0, objectArray3, n2, objectArray2.length);
            return objectArray3;
        }
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        int n3 = objectArray.length;
        Object[] objectArray4 = objectBuffer.resetAndStart(objectArray, n3);
        TypeDeserializer typeDeserializer = this._elementTypeDeserializer;
        try {
            JsonToken jsonToken;
            while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                if (jsonToken == JsonToken.VALUE_NULL) {
                    if (this._skipNullValues) continue;
                    object = this._nullProvider.getNullValue(deserializationContext);
                } else {
                    object = typeDeserializer == null ? this._elementDeserializer.deserialize(jsonParser, deserializationContext) : this._elementDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer);
                }
                if (n3 >= objectArray4.length) {
                    objectArray4 = objectBuffer.appendCompletedChunk(objectArray4);
                    n3 = 0;
                }
                objectArray4[n3++] = object;
            }
        }
        catch (Exception exception) {
            throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)objectArray4, objectBuffer.bufferedSize() + n3);
        }
        object = this._untyped ? objectBuffer.completeAndClearBuffer(objectArray4, n3) : objectBuffer.completeAndClearBuffer(objectArray4, n3, this._elementClass);
        deserializationContext.returnObjectBuffer(objectBuffer);
        return object;
    }

    protected Byte[] deserializeFromBase64(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        byte[] byArray = jsonParser.getBinaryValue(deserializationContext.getBase64Variant());
        Byte[] byteArray = new Byte[byArray.length];
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            byteArray[i2] = byArray[i2];
        }
        return byteArray;
    }

    protected Object[] handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Object object;
        boolean bl2;
        boolean bl3 = bl2 = this._unwrapSingle == Boolean.TRUE || this._unwrapSingle == null && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (!bl2) {
            if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
                if (this._elementClass == Byte.class) {
                    return this.deserializeFromBase64(jsonParser, deserializationContext);
                }
                return (Object[])this._deserializeFromString(jsonParser, deserializationContext);
            }
            return (Object[])deserializationContext.handleUnexpectedToken(this._containerType, jsonParser);
        }
        if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
            if (this._skipNullValues) {
                return this._emptyValue;
            }
            object = this._nullProvider.getNullValue(deserializationContext);
        } else {
            object = this._elementTypeDeserializer == null ? this._elementDeserializer.deserialize(jsonParser, deserializationContext) : this._elementDeserializer.deserializeWithType(jsonParser, deserializationContext, this._elementTypeDeserializer);
        }
        Object[] objectArray = this._untyped ? new Object[1] : (Object[])Array.newInstance(this._elementClass, 1);
        objectArray[0] = object;
        return objectArray;
    }
}

