/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.serializers;

import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.Kryo;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.KryoException;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.io.Input;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.io.InputChunked;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.io.Output;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.io.OutputChunked;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.serializers.TaggedFieldSerializerConfig;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.minlog.Log;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;

public class TaggedFieldSerializer<T>
extends FieldSerializer<T> {
    private int[] tags;
    private int writeFieldCount;
    private boolean[] deprecated;
    private boolean[] annexed;
    private static final Comparator<FieldSerializer.CachedField> TAGGED_VALUE_COMPARATOR = new Comparator<FieldSerializer.CachedField>(){

        @Override
        public int compare(FieldSerializer.CachedField cachedField, FieldSerializer.CachedField cachedField2) {
            return cachedField.getField().getAnnotation(Tag.class).value() - cachedField2.getField().getAnnotation(Tag.class).value();
        }
    };

    public TaggedFieldSerializer(Kryo kryo, Class clazz) {
        super(kryo, clazz, null, kryo.getTaggedFieldSerializerConfig().clone());
    }

    public boolean isSkipUnknownTags() {
        return ((TaggedFieldSerializerConfig)this.config).isSkipUnknownTags();
    }

    @Override
    protected void initializeCachedFields() {
        Field field;
        int n2;
        FieldSerializer.CachedField[] cachedFieldArray = this.getFields();
        int n3 = cachedFieldArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            field = cachedFieldArray[n2].getField();
            if (field.getAnnotation(Tag.class) != null) continue;
            if (Log.TRACE) {
                Log.trace("kryo", "Ignoring field without tag: " + cachedFieldArray[n2]);
            }
            super.removeField(cachedFieldArray[n2]);
        }
        cachedFieldArray = this.getFields();
        this.tags = new int[cachedFieldArray.length];
        this.deprecated = new boolean[cachedFieldArray.length];
        this.annexed = new boolean[cachedFieldArray.length];
        this.writeFieldCount = cachedFieldArray.length;
        Arrays.sort(cachedFieldArray, TAGGED_VALUE_COMPARATOR);
        n3 = cachedFieldArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            field = cachedFieldArray[n2].getField();
            this.tags[n2] = field.getAnnotation(Tag.class).value();
            if (n2 > 0 && this.tags[n2] == this.tags[n2 - 1]) {
                throw new KryoException(String.format("The fields [%s] and [%s] both have a Tag value of %d.", field, cachedFieldArray[n2 - 1].getField(), this.tags[n2]));
            }
            if (field.getAnnotation(Deprecated.class) != null) {
                this.deprecated[n2] = true;
                --this.writeFieldCount;
            }
            if (!field.getAnnotation(Tag.class).annexed()) continue;
            this.annexed[n2] = true;
        }
        this.removedFields.clear();
    }

    @Override
    public void removeField(String string) {
        super.removeField(string);
        this.initializeCachedFields();
    }

    @Override
    public void removeField(FieldSerializer.CachedField cachedField) {
        super.removeField(cachedField);
        this.initializeCachedFields();
    }

    @Override
    public void write(Kryo kryo, Output output, T t2) {
        FieldSerializer.CachedField[] cachedFieldArray = this.getFields();
        output.writeVarInt(this.writeFieldCount, true);
        OutputChunked outputChunked = null;
        int n2 = cachedFieldArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.deprecated[i2]) continue;
            output.writeVarInt(this.tags[i2], true);
            if (this.annexed[i2]) {
                if (outputChunked == null) {
                    outputChunked = new OutputChunked(output, 1024);
                }
                cachedFieldArray[i2].write(outputChunked, t2);
                outputChunked.endChunks();
                continue;
            }
            cachedFieldArray[i2].write(output, t2);
        }
    }

    @Override
    public T read(Kryo kryo, Input input, Class<T> clazz) {
        T t2 = this.create(kryo, input, clazz);
        kryo.reference(t2);
        int n2 = input.readVarInt(true);
        int[] nArray = this.tags;
        InputChunked inputChunked = null;
        FieldSerializer.CachedField[] cachedFieldArray = this.getFields();
        int n3 = n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = input.readVarInt(true);
            FieldSerializer.CachedField cachedField = null;
            boolean bl2 = false;
            int n5 = nArray.length;
            for (int i3 = 0; i3 < n5; ++i3) {
                if (nArray[i3] != n4) continue;
                cachedField = cachedFieldArray[i3];
                bl2 = this.annexed[i3];
                break;
            }
            if (cachedField == null) {
                if (this.isSkipUnknownTags()) {
                    if (inputChunked == null) {
                        inputChunked = new InputChunked(input, 1024);
                    }
                    inputChunked.nextChunks();
                    if (!Log.TRACE) continue;
                    Log.trace(String.format("Unknown field tag: %d (%s) encountered. Assuming a future annexed tag with chunked encoding and skipping.", n4, this.getType().getName()));
                    continue;
                }
                throw new KryoException("Unknown field tag: " + n4 + " (" + this.getType().getName() + ")");
            }
            if (bl2) {
                if (inputChunked == null) {
                    inputChunked = new InputChunked(input, 1024);
                }
                cachedField.read(inputChunked, t2);
                inputChunked.nextChunks();
                continue;
            }
            cachedField.read(input, t2);
        }
        return t2;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Tag {
        public int value();

        public boolean annexed() default false;
    }
}

