/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.serializers;

import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.Kryo;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.KryoException;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.Registration;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.Serializer;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.io.Input;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.io.Output;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.minlog.Log;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.reflectasm.FieldAccess;

class ObjectField
extends FieldSerializer.CachedField {
    public Class[] generics;
    final FieldSerializer fieldSerializer;
    final Class type;
    final Kryo kryo;

    ObjectField(FieldSerializer fieldSerializer) {
        this.fieldSerializer = fieldSerializer;
        this.kryo = fieldSerializer.kryo;
        this.type = fieldSerializer.type;
    }

    public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.field.get(object);
    }

    public void setField(Object object, Object object2) throws IllegalArgumentException, IllegalAccessException {
        this.field.set(object, object2);
    }

    @Override
    public void write(Output output, Object object) {
        try {
            if (Log.TRACE) {
                Log.trace("kryo", "Write field: " + this + " (" + object.getClass().getName() + ") pos=" + output.position());
            }
            Object object2 = this.getField(object);
            Serializer serializer = this.serializer;
            if (this.valueClass == null) {
                if (object2 == null) {
                    this.kryo.writeClass(output, null);
                    return;
                }
                Registration registration = this.kryo.writeClass(output, object2.getClass());
                if (serializer == null) {
                    serializer = registration.getSerializer();
                }
                serializer.setGenerics(this.kryo, this.generics);
                this.kryo.writeObject(output, object2, serializer);
            } else {
                if (serializer == null) {
                    this.serializer = serializer = this.kryo.getSerializer(this.valueClass);
                }
                serializer.setGenerics(this.kryo, this.generics);
                if (this.canBeNull) {
                    this.kryo.writeObjectOrNull(output, object2, serializer);
                } else {
                    if (object2 == null) {
                        throw new KryoException("Field value is null but canBeNull is false: " + this + " (" + object.getClass().getName() + ")");
                    }
                    this.kryo.writeObject(output, object2, serializer);
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new KryoException("Error accessing field: " + this + " (" + object.getClass().getName() + ")", illegalAccessException);
        }
        catch (KryoException kryoException) {
            kryoException.addTrace(this + " (" + object.getClass().getName() + ")");
            throw kryoException;
        }
        catch (RuntimeException runtimeException) {
            KryoException kryoException = new KryoException(runtimeException);
            kryoException.addTrace(this + " (" + object.getClass().getName() + ")");
            throw kryoException;
        }
    }

    @Override
    public void read(Input input, Object object) {
        try {
            Object var3_7;
            if (Log.TRACE) {
                Log.trace("kryo", "Read field: " + this + " (" + this.type.getName() + ") pos=" + input.position());
            }
            Class clazz = this.valueClass;
            Serializer serializer = this.serializer;
            if (clazz == null) {
                Registration registration = this.kryo.readClass(input);
                if (registration == null) {
                    var3_7 = null;
                } else {
                    if (serializer == null) {
                        serializer = registration.getSerializer();
                    }
                    serializer.setGenerics(this.kryo, this.generics);
                    var3_7 = this.kryo.readObject(input, registration.getType(), serializer);
                }
            } else {
                if (serializer == null) {
                    this.serializer = serializer = this.kryo.getSerializer(this.valueClass);
                }
                serializer.setGenerics(this.kryo, this.generics);
                var3_7 = this.canBeNull ? this.kryo.readObjectOrNull(input, clazz, serializer) : this.kryo.readObject(input, clazz, serializer);
            }
            this.setField(object, var3_7);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new KryoException("Error accessing field: " + this + " (" + this.type.getName() + ")", illegalAccessException);
        }
        catch (KryoException kryoException) {
            kryoException.addTrace(this + " (" + this.type.getName() + ")");
            throw kryoException;
        }
        catch (RuntimeException runtimeException) {
            KryoException kryoException = new KryoException(runtimeException);
            kryoException.addTrace(this + " (" + this.type.getName() + ")");
            throw kryoException;
        }
    }

    @Override
    public void copy(Object object, Object object2) {
        try {
            if (this.accessIndex != -1) {
                FieldAccess fieldAccess = (FieldAccess)this.fieldSerializer.access;
                fieldAccess.set(object2, this.accessIndex, this.kryo.copy(fieldAccess.get(object, this.accessIndex)));
            } else {
                this.setField(object2, this.kryo.copy(this.getField(object)));
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new KryoException("Error accessing field: " + this + " (" + this.type.getName() + ")", illegalAccessException);
        }
        catch (KryoException kryoException) {
            kryoException.addTrace(this + " (" + this.type.getName() + ")");
            throw kryoException;
        }
        catch (RuntimeException runtimeException) {
            KryoException kryoException = new KryoException(runtimeException);
            kryoException.addTrace(this + " (" + this.type.getName() + ")");
            throw kryoException;
        }
    }

    static final class ObjectDoubleField
    extends ObjectField {
        public ObjectDoubleField(FieldSerializer fieldSerializer) {
            super(fieldSerializer);
        }

        @Override
        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getDouble(object);
        }

        @Override
        public void write(Output output, Object object) {
            try {
                output.writeDouble(this.field.getDouble(object));
            }
            catch (Exception exception) {
                KryoException kryoException = new KryoException(exception);
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
        }

        @Override
        public void read(Input input, Object object) {
            try {
                this.field.setDouble(object, input.readDouble());
            }
            catch (Exception exception) {
                KryoException kryoException = new KryoException(exception);
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
        }

        @Override
        public void copy(Object object, Object object2) {
            try {
                this.field.setDouble(object2, this.field.getDouble(object));
            }
            catch (Exception exception) {
                KryoException kryoException = new KryoException(exception);
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
        }
    }

    static final class ObjectLongField
    extends ObjectField {
        public ObjectLongField(FieldSerializer fieldSerializer) {
            super(fieldSerializer);
        }

        @Override
        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getLong(object);
        }

        @Override
        public void write(Output output, Object object) {
            try {
                if (this.varIntsEnabled) {
                    output.writeLong(this.field.getLong(object), false);
                } else {
                    output.writeLong(this.field.getLong(object));
                }
            }
            catch (Exception exception) {
                KryoException kryoException = new KryoException(exception);
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
        }

        @Override
        public void read(Input input, Object object) {
            try {
                if (this.varIntsEnabled) {
                    this.field.setLong(object, input.readLong(false));
                } else {
                    this.field.setLong(object, input.readLong());
                }
            }
            catch (Exception exception) {
                KryoException kryoException = new KryoException(exception);
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
        }

        @Override
        public void copy(Object object, Object object2) {
            try {
                this.field.setLong(object2, this.field.getLong(object));
            }
            catch (Exception exception) {
                KryoException kryoException = new KryoException(exception);
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
        }
    }

    static final class ObjectCharField
    extends ObjectField {
        public ObjectCharField(FieldSerializer fieldSerializer) {
            super(fieldSerializer);
        }

        @Override
        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return Character.valueOf(this.field.getChar(object));
        }

        @Override
        public void write(Output output, Object object) {
            try {
                output.writeChar(this.field.getChar(object));
            }
            catch (Exception exception) {
                KryoException kryoException = new KryoException(exception);
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
        }

        @Override
        public void read(Input input, Object object) {
            try {
                this.field.setChar(object, input.readChar());
            }
            catch (Exception exception) {
                KryoException kryoException = new KryoException(exception);
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
        }

        @Override
        public void copy(Object object, Object object2) {
            try {
                this.field.setChar(object2, this.field.getChar(object));
            }
            catch (Exception exception) {
                KryoException kryoException = new KryoException(exception);
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
        }
    }

    static final class ObjectBooleanField
    extends ObjectField {
        public ObjectBooleanField(FieldSerializer fieldSerializer) {
            super(fieldSerializer);
        }

        @Override
        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getBoolean(object);
        }

        @Override
        public void write(Output output, Object object) {
            try {
                output.writeBoolean(this.field.getBoolean(object));
            }
            catch (Exception exception) {
                KryoException kryoException = new KryoException(exception);
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
        }

        @Override
        public void read(Input input, Object object) {
            try {
                this.field.setBoolean(object, input.readBoolean());
            }
            catch (Exception exception) {
                KryoException kryoException = new KryoException(exception);
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
        }

        @Override
        public void copy(Object object, Object object2) {
            try {
                this.field.setBoolean(object2, this.field.getBoolean(object));
            }
            catch (Exception exception) {
                KryoException kryoException = new KryoException(exception);
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
        }
    }

    static final class ObjectByteField
    extends ObjectField {
        public ObjectByteField(FieldSerializer fieldSerializer) {
            super(fieldSerializer);
        }

        @Override
        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getByte(object);
        }

        @Override
        public void write(Output output, Object object) {
            try {
                output.writeByte(this.field.getByte(object));
            }
            catch (Exception exception) {
                KryoException kryoException = new KryoException(exception);
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
        }

        @Override
        public void read(Input input, Object object) {
            try {
                this.field.setByte(object, input.readByte());
            }
            catch (Exception exception) {
                KryoException kryoException = new KryoException(exception);
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
        }

        @Override
        public void copy(Object object, Object object2) {
            try {
                this.field.setByte(object2, this.field.getByte(object));
            }
            catch (Exception exception) {
                KryoException kryoException = new KryoException(exception);
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
        }
    }

    static final class ObjectShortField
    extends ObjectField {
        public ObjectShortField(FieldSerializer fieldSerializer) {
            super(fieldSerializer);
        }

        @Override
        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getShort(object);
        }

        @Override
        public void write(Output output, Object object) {
            try {
                output.writeShort(this.field.getShort(object));
            }
            catch (Exception exception) {
                KryoException kryoException = new KryoException(exception);
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
        }

        @Override
        public void read(Input input, Object object) {
            try {
                this.field.setShort(object, input.readShort());
            }
            catch (Exception exception) {
                KryoException kryoException = new KryoException(exception);
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
        }

        @Override
        public void copy(Object object, Object object2) {
            try {
                this.field.setShort(object2, this.field.getShort(object));
            }
            catch (Exception exception) {
                KryoException kryoException = new KryoException(exception);
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
        }
    }

    static final class ObjectFloatField
    extends ObjectField {
        public ObjectFloatField(FieldSerializer fieldSerializer) {
            super(fieldSerializer);
        }

        @Override
        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return Float.valueOf(this.field.getFloat(object));
        }

        @Override
        public void write(Output output, Object object) {
            try {
                output.writeFloat(this.field.getFloat(object));
            }
            catch (Exception exception) {
                KryoException kryoException = new KryoException(exception);
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
        }

        @Override
        public void read(Input input, Object object) {
            try {
                this.field.setFloat(object, input.readFloat());
            }
            catch (Exception exception) {
                KryoException kryoException = new KryoException(exception);
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
        }

        @Override
        public void copy(Object object, Object object2) {
            try {
                this.field.setFloat(object2, this.field.getFloat(object));
            }
            catch (Exception exception) {
                KryoException kryoException = new KryoException(exception);
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
        }
    }

    static final class ObjectIntField
    extends ObjectField {
        public ObjectIntField(FieldSerializer fieldSerializer) {
            super(fieldSerializer);
        }

        @Override
        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getInt(object);
        }

        @Override
        public void write(Output output, Object object) {
            try {
                if (this.varIntsEnabled) {
                    output.writeInt(this.field.getInt(object), false);
                } else {
                    output.writeInt(this.field.getInt(object));
                }
            }
            catch (Exception exception) {
                KryoException kryoException = new KryoException(exception);
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
        }

        @Override
        public void read(Input input, Object object) {
            try {
                if (this.varIntsEnabled) {
                    this.field.setInt(object, input.readInt(false));
                } else {
                    this.field.setInt(object, input.readInt());
                }
            }
            catch (Exception exception) {
                KryoException kryoException = new KryoException(exception);
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
        }

        @Override
        public void copy(Object object, Object object2) {
            try {
                this.field.setInt(object2, this.field.getInt(object));
            }
            catch (Exception exception) {
                KryoException kryoException = new KryoException(exception);
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
        }
    }
}

