/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.serializers;

import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.Kryo;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.serializers.Generics;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.serializers.GenericsResolver;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.serializers.ObjectField;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.minlog.Log;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

final class FieldSerializerGenericsUtil {
    private Kryo kryo;
    private FieldSerializer serializer;

    public FieldSerializerGenericsUtil(FieldSerializer fieldSerializer) {
        this.serializer = fieldSerializer;
        this.kryo = fieldSerializer.getKryo();
    }

    Generics buildGenericsScope(Class clazz, Class[] classArray) {
        Type[] typeArray;
        Object object;
        Class clazz2 = clazz;
        TypeVariable<Class<Object>>[] typeVariableArray = null;
        while (clazz2 != null && ((typeVariableArray = clazz2 == this.serializer.type ? this.serializer.typeParameters : clazz2.getTypeParameters()) == null || typeVariableArray.length == 0)) {
            if (clazz2 == this.serializer.type) {
                clazz2 = this.serializer.componentType;
                if (clazz2 != null) continue;
                clazz2 = this.serializer.type;
                object = null;
                do {
                    object = clazz2.getGenericSuperclass();
                    clazz2 = clazz2.getSuperclass();
                } while (object != null && !(object instanceof ParameterizedType));
                if (object == null) break;
                ParameterizedType parameterizedType = (ParameterizedType)object;
                typeArray = parameterizedType.getActualTypeArguments();
                typeVariableArray = clazz2.getTypeParameters();
                classArray = new Class[typeArray.length];
                for (int i2 = 0; i2 < typeArray.length; ++i2) {
                    classArray[i2] = typeArray[i2] instanceof Class ? (Class)typeArray[i2] : Object.class;
                }
                break;
            }
            clazz2 = clazz2.getComponentType();
        }
        if (typeVariableArray != null && typeVariableArray.length > 0) {
            if (Log.TRACE) {
                Log.trace("kryo", "Class " + clazz.getName() + " has generic type parameters");
            }
            int n2 = 0;
            typeArray = new HashMap();
            for (TypeVariable typeVariable : typeVariableArray) {
                Class<?> clazz3;
                String string = typeVariable.getName();
                if (Log.TRACE) {
                    Log.trace("kryo", "Type parameter variable: name=" + string + " type bounds=" + Arrays.toString(typeVariable.getBounds()));
                }
                if ((clazz3 = this.getTypeVarConcreteClass(classArray, n2, string)) != null) {
                    typeArray.put(string, clazz3);
                    if (Log.TRACE) {
                        Log.trace("kryo", "Concrete type used for " + string + " is: " + clazz3.getName());
                    }
                }
                ++n2;
            }
            object = new Generics((Map<String, Class>)typeArray);
            return object;
        }
        return null;
    }

    private Class<?> getTypeVarConcreteClass(Class[] classArray, int n2, String string) {
        GenericsResolver genericsResolver;
        if (classArray != null && classArray.length > n2) {
            return classArray[n2];
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Trying to use kryo.getGenericScope");
        }
        if ((genericsResolver = this.kryo.getGenericsResolver()).isSet()) {
            return genericsResolver.getConcreteClass(string);
        }
        return null;
    }

    Class[] computeFieldGenerics(Type type, Field field, Class[] classArray) {
        Object[] objectArray = null;
        if (type != null) {
            if (type instanceof TypeVariable && this.serializer.getGenericsScope() != null) {
                TypeVariable typeVariable = (TypeVariable)type;
                Class clazz = this.serializer.getGenericsScope().getConcreteClass(typeVariable.getName());
                if (clazz != null) {
                    classArray[0] = clazz;
                    objectArray = new Class[]{classArray[0]};
                    if (Log.TRACE) {
                        Log.trace("kryo", "Determined concrete class of '" + field.getName() + "' to be " + classArray[0].getName());
                    }
                }
            } else if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type[] typeArray = parameterizedType.getActualTypeArguments();
                if (typeArray != null) {
                    objectArray = new Class[typeArray.length];
                    for (int i2 = 0; i2 < typeArray.length; ++i2) {
                        Type type2 = typeArray[i2];
                        if (type2 instanceof Class) {
                            objectArray[i2] = (Class)type2;
                            continue;
                        }
                        if (type2 instanceof ParameterizedType) {
                            objectArray[i2] = (Class)((ParameterizedType)type2).getRawType();
                            continue;
                        }
                        if (type2 instanceof TypeVariable && this.serializer.getGenericsScope() != null) {
                            objectArray[i2] = this.serializer.getGenericsScope().getConcreteClass(((TypeVariable)type2).getName());
                            if (objectArray[i2] != null) continue;
                            objectArray[i2] = Object.class;
                            continue;
                        }
                        if (type2 instanceof WildcardType) {
                            objectArray[i2] = Object.class;
                            continue;
                        }
                        if (type2 instanceof GenericArrayType) {
                            Class clazz;
                            Generics generics;
                            Type type3 = ((GenericArrayType)type2).getGenericComponentType();
                            if (type3 instanceof Class) {
                                objectArray[i2] = Array.newInstance((Class)type3, 0).getClass();
                                continue;
                            }
                            if (!(type3 instanceof TypeVariable) || (generics = this.serializer.getGenericsScope()) == null || (clazz = generics.getConcreteClass(((TypeVariable)type3).getName())) == null) continue;
                            objectArray[i2] = Array.newInstance(clazz, 0).getClass();
                            continue;
                        }
                        objectArray[i2] = null;
                    }
                    if (Log.TRACE && objectArray != null) {
                        Log.trace("kryo", "Determined concrete class of parametrized '" + field.getName() + "' to be " + type + " where type parameters are " + Arrays.toString(objectArray));
                    }
                }
            } else if (type instanceof GenericArrayType) {
                GenericArrayType genericArrayType = (GenericArrayType)type;
                Type type4 = genericArrayType.getGenericComponentType();
                Class[] classArray2 = new Class[]{classArray[0]};
                objectArray = this.computeFieldGenerics(type4, field, classArray2);
                if (Log.TRACE && objectArray != null) {
                    Log.trace("kryo", "Determined concrete class of a generic array '" + field.getName() + "' to be " + type + " where type parameters are " + Arrays.toString(objectArray));
                } else if (Log.TRACE) {
                    Log.trace("kryo", "Determined concrete class of '" + field.getName() + "' to be " + type);
                }
            }
        }
        return objectArray;
    }

    FieldSerializer.CachedField newCachedFieldOfGenericType(Field field, int n2, Class[] classArray, Type type) {
        if (Log.TRACE) {
            Log.trace("kryo", "Field '" + field.getName() + "' of type " + classArray[0] + " of generic type " + type);
        }
        if (Log.TRACE && type != null) {
            Log.trace("kryo", "Field generic type is of class " + type.getClass().getName());
        }
        Class[] classArray2 = FieldSerializerGenericsUtil.getGenerics(type, this.kryo);
        Generics generics = this.buildGenericsScope(classArray[0], classArray2);
        if (classArray[0] == Object.class && type instanceof TypeVariable && this.serializer.getGenericsScope() != null) {
            TypeVariable typeVariable = (TypeVariable)type;
            Class clazz = this.serializer.getGenericsScope().getConcreteClass(typeVariable.getName());
            if (clazz != null) {
                generics = new Generics();
                generics.add(typeVariable.getName(), clazz);
            }
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Generics scope of field '" + field.getName() + "' of class " + type + " is " + generics);
        }
        Object[] objectArray = this.computeFieldGenerics(type, field, classArray);
        FieldSerializer.CachedField cachedField = this.serializer.newMatchingCachedField(field, n2, classArray[0], type, (Class[])objectArray);
        if (objectArray != null && cachedField instanceof ObjectField && objectArray.length > 0 && objectArray[0] != null) {
            ((ObjectField)cachedField).generics = objectArray;
            if (Log.TRACE) {
                Log.trace("kryo", "Field generics: " + Arrays.toString(objectArray));
            }
        }
        return cachedField;
    }

    public static Class[] getGenerics(Type type, Kryo kryo) {
        if (type instanceof GenericArrayType) {
            Type type2 = ((GenericArrayType)type).getGenericComponentType();
            if (type2 instanceof Class) {
                return new Class[]{(Class)type2};
            }
            return FieldSerializerGenericsUtil.getGenerics(type2, kryo);
        }
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Processing generic type " + type);
        }
        Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
        Class[] classArray = new Class[typeArray.length];
        int n2 = 0;
        for (Type type3 : typeArray) {
            Object object;
            Object object2;
            if (Log.TRACE) {
                Log.trace("kryo", "Processing actual type " + type3 + " (" + type3.getClass().getName() + ")");
            }
            classArray[var5_6] = Object.class;
            if (type3 instanceof Class) {
                classArray[var5_6] = (Class)type3;
            } else if (type3 instanceof ParameterizedType) {
                classArray[var5_6] = (Class)((ParameterizedType)type3).getRawType();
            } else if (type3 instanceof TypeVariable) {
                object2 = kryo.getGenericsResolver();
                if (!((GenericsResolver)object2).isSet() || (object = ((GenericsResolver)object2).getConcreteClass(((TypeVariable)type3).getName())) == null) continue;
                classArray[var5_6] = object;
            } else {
                if (!(type3 instanceof GenericArrayType)) continue;
                object2 = ((GenericArrayType)type3).getGenericComponentType();
                if (object2 instanceof Class) {
                    classArray[var5_6] = Array.newInstance((Class)object2, 0).getClass();
                } else if (object2 instanceof TypeVariable) {
                    Class clazz;
                    object = kryo.getGenericsResolver();
                    if (object.isSet() && (clazz = object.getConcreteClass(((TypeVariable)object2).getName())) != null) {
                        classArray[var5_6] = Array.newInstance(clazz, 0).getClass();
                    }
                } else {
                    object = FieldSerializerGenericsUtil.getGenerics((Type)object2, kryo);
                    if (object != null) {
                        classArray[var5_6] = object[0];
                    }
                }
            }
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        return classArray;
    }
}

