/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.serializers;

import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.Kryo;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.KryoException;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.KryoSerializable;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.Registration;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.Serializer;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.io.Input;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.io.Output;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.serializers.CollectionSerializer;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.serializers.MapSerializer;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.util.Util;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;

public class DefaultSerializers {

    public static class URLSerializer
    extends Serializer<URL> {
        public URLSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, URL uRL) {
            output.writeString(uRL.toExternalForm());
        }

        @Override
        public URL read(Kryo kryo, Input input, Class<URL> clazz) {
            try {
                return new URL(input.readString());
            }
            catch (MalformedURLException malformedURLException) {
                throw new KryoException(malformedURLException);
            }
        }
    }

    public static class CharsetSerializer
    extends Serializer<Charset> {
        public CharsetSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Charset charset) {
            output.writeString(charset.name());
        }

        @Override
        public Charset read(Kryo kryo, Input input, Class<Charset> clazz) {
            return Charset.forName(input.readString());
        }
    }

    public static class LocaleSerializer
    extends Serializer<Locale> {
        public static final Locale SPANISH = new Locale("es", "", "");
        public static final Locale SPAIN = new Locale("es", "ES", "");

        public LocaleSerializer() {
            this.setImmutable(true);
        }

        protected Locale create(String string, String string2, String string3) {
            Locale locale = Locale.getDefault();
            if (LocaleSerializer.isSameLocale(locale, string, string2, string3)) {
                return locale;
            }
            if (locale != Locale.US && LocaleSerializer.isSameLocale(Locale.US, string, string2, string3)) {
                return Locale.US;
            }
            if (LocaleSerializer.isSameLocale(Locale.ENGLISH, string, string2, string3)) {
                return Locale.ENGLISH;
            }
            if (LocaleSerializer.isSameLocale(Locale.GERMAN, string, string2, string3)) {
                return Locale.GERMAN;
            }
            if (LocaleSerializer.isSameLocale(SPANISH, string, string2, string3)) {
                return SPANISH;
            }
            if (LocaleSerializer.isSameLocale(Locale.FRENCH, string, string2, string3)) {
                return Locale.FRENCH;
            }
            if (LocaleSerializer.isSameLocale(Locale.ITALIAN, string, string2, string3)) {
                return Locale.ITALIAN;
            }
            if (LocaleSerializer.isSameLocale(Locale.JAPANESE, string, string2, string3)) {
                return Locale.JAPANESE;
            }
            if (LocaleSerializer.isSameLocale(Locale.KOREAN, string, string2, string3)) {
                return Locale.KOREAN;
            }
            if (LocaleSerializer.isSameLocale(Locale.SIMPLIFIED_CHINESE, string, string2, string3)) {
                return Locale.SIMPLIFIED_CHINESE;
            }
            if (LocaleSerializer.isSameLocale(Locale.CHINESE, string, string2, string3)) {
                return Locale.CHINESE;
            }
            if (LocaleSerializer.isSameLocale(Locale.TRADITIONAL_CHINESE, string, string2, string3)) {
                return Locale.TRADITIONAL_CHINESE;
            }
            if (LocaleSerializer.isSameLocale(Locale.UK, string, string2, string3)) {
                return Locale.UK;
            }
            if (LocaleSerializer.isSameLocale(Locale.GERMANY, string, string2, string3)) {
                return Locale.GERMANY;
            }
            if (LocaleSerializer.isSameLocale(SPAIN, string, string2, string3)) {
                return SPAIN;
            }
            if (LocaleSerializer.isSameLocale(Locale.FRANCE, string, string2, string3)) {
                return Locale.FRANCE;
            }
            if (LocaleSerializer.isSameLocale(Locale.ITALY, string, string2, string3)) {
                return Locale.ITALY;
            }
            if (LocaleSerializer.isSameLocale(Locale.JAPAN, string, string2, string3)) {
                return Locale.JAPAN;
            }
            if (LocaleSerializer.isSameLocale(Locale.KOREA, string, string2, string3)) {
                return Locale.KOREA;
            }
            if (LocaleSerializer.isSameLocale(Locale.CANADA, string, string2, string3)) {
                return Locale.CANADA;
            }
            if (LocaleSerializer.isSameLocale(Locale.CANADA_FRENCH, string, string2, string3)) {
                return Locale.CANADA_FRENCH;
            }
            return new Locale(string, string2, string3);
        }

        @Override
        public void write(Kryo kryo, Output output, Locale locale) {
            output.writeAscii(locale.getLanguage());
            output.writeAscii(locale.getCountry());
            output.writeString(locale.getVariant());
        }

        @Override
        public Locale read(Kryo kryo, Input input, Class<Locale> clazz) {
            String string = input.readString();
            String string2 = input.readString();
            String string3 = input.readString();
            return this.create(string, string2, string3);
        }

        protected static boolean isSameLocale(Locale locale, String string, String string2, String string3) {
            try {
                return locale.getLanguage().equals(string) && locale.getCountry().equals(string2) && locale.getVariant().equals(string3);
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }
    }

    public static class TreeSetSerializer
    extends CollectionSerializer {
        @Override
        public void write(Kryo kryo, Output output, Collection collection) {
            TreeSet treeSet = (TreeSet)collection;
            kryo.writeClassAndObject(output, treeSet.comparator());
            super.write(kryo, output, collection);
        }

        @Override
        protected TreeSet create(Kryo kryo, Input input, Class<Collection> clazz) {
            return this.createTreeSet(clazz, (Comparator)kryo.readClassAndObject(input));
        }

        @Override
        protected TreeSet createCopy(Kryo kryo, Collection collection) {
            return this.createTreeSet(collection.getClass(), ((TreeSet)collection).comparator());
        }

        private TreeSet createTreeSet(Class<? extends Collection> clazz, Comparator comparator) {
            if (clazz != TreeSet.class && clazz != null) {
                try {
                    Constructor<? extends Collection> constructor = clazz.getConstructor(Comparator.class);
                    if (!constructor.isAccessible()) {
                        try {
                            constructor.setAccessible(true);
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                    return (TreeSet)constructor.newInstance(comparator);
                }
                catch (Exception exception) {
                    throw new KryoException(exception);
                }
            }
            return new TreeSet(comparator);
        }
    }

    public static class TreeMapSerializer
    extends MapSerializer {
        @Override
        public void write(Kryo kryo, Output output, Map map) {
            TreeMap treeMap = (TreeMap)map;
            kryo.writeClassAndObject(output, treeMap.comparator());
            super.write(kryo, output, map);
        }

        @Override
        protected Map create(Kryo kryo, Input input, Class<Map> clazz) {
            return this.createTreeMap(clazz, (Comparator)kryo.readClassAndObject(input));
        }

        @Override
        protected Map createCopy(Kryo kryo, Map map) {
            return this.createTreeMap(map.getClass(), ((TreeMap)map).comparator());
        }

        private TreeMap createTreeMap(Class<? extends Map> clazz, Comparator comparator) {
            if (clazz != TreeMap.class && clazz != null) {
                try {
                    Constructor<? extends Map> constructor = clazz.getConstructor(Comparator.class);
                    if (!constructor.isAccessible()) {
                        try {
                            constructor.setAccessible(true);
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                    return (TreeMap)constructor.newInstance(comparator);
                }
                catch (Exception exception) {
                    throw new KryoException(exception);
                }
            }
            return new TreeMap(comparator);
        }
    }

    public static class CalendarSerializer
    extends Serializer<Calendar> {
        TimeZoneSerializer timeZoneSerializer = new TimeZoneSerializer();

        @Override
        public void write(Kryo kryo, Output output, Calendar calendar) {
            this.timeZoneSerializer.write(kryo, output, calendar.getTimeZone());
            output.writeLong(calendar.getTimeInMillis(), true);
            output.writeBoolean(calendar.isLenient());
            output.writeInt(calendar.getFirstDayOfWeek(), true);
            output.writeInt(calendar.getMinimalDaysInFirstWeek(), true);
            if (calendar instanceof GregorianCalendar) {
                output.writeLong(((GregorianCalendar)calendar).getGregorianChange().getTime(), false);
            } else {
                output.writeLong(-12219292800000L, false);
            }
        }

        @Override
        public Calendar read(Kryo kryo, Input input, Class<Calendar> clazz) {
            Calendar calendar = Calendar.getInstance((TimeZone)this.timeZoneSerializer.read(kryo, input, (Class)TimeZone.class));
            calendar.setTimeInMillis(input.readLong(true));
            calendar.setLenient(input.readBoolean());
            calendar.setFirstDayOfWeek(input.readInt(true));
            calendar.setMinimalDaysInFirstWeek(input.readInt(true));
            long l2 = input.readLong(false);
            if (l2 != -12219292800000L && calendar instanceof GregorianCalendar) {
                ((GregorianCalendar)calendar).setGregorianChange(new java.util.Date(l2));
            }
            return calendar;
        }

        @Override
        public Calendar copy(Kryo kryo, Calendar calendar) {
            return (Calendar)calendar.clone();
        }
    }

    public static class TimeZoneSerializer
    extends Serializer<TimeZone> {
        public TimeZoneSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, TimeZone timeZone) {
            output.writeString(timeZone.getID());
        }

        @Override
        public TimeZone read(Kryo kryo, Input input, Class<TimeZone> clazz) {
            return TimeZone.getTimeZone(input.readString());
        }
    }

    public static class CollectionsSingletonSetSerializer
    extends Serializer<Set> {
        public CollectionsSingletonSetSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Set set) {
            kryo.writeClassAndObject(output, set.iterator().next());
        }

        @Override
        public Set read(Kryo kryo, Input input, Class clazz) {
            return Collections.singleton(kryo.readClassAndObject(input));
        }
    }

    public static class CollectionsSingletonMapSerializer
    extends Serializer<Map> {
        public CollectionsSingletonMapSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Map map) {
            Map.Entry entry = map.entrySet().iterator().next();
            kryo.writeClassAndObject(output, entry.getKey());
            kryo.writeClassAndObject(output, entry.getValue());
        }

        @Override
        public Map read(Kryo kryo, Input input, Class clazz) {
            Object object = kryo.readClassAndObject(input);
            Object object2 = kryo.readClassAndObject(input);
            return Collections.singletonMap(object, object2);
        }
    }

    public static class CollectionsSingletonListSerializer
    extends Serializer<List> {
        public CollectionsSingletonListSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, List list) {
            kryo.writeClassAndObject(output, list.get(0));
        }

        @Override
        public List read(Kryo kryo, Input input, Class clazz) {
            return Collections.singletonList(kryo.readClassAndObject(input));
        }
    }

    public static class CollectionsEmptySetSerializer
    extends Serializer {
        public CollectionsEmptySetSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, Object object) {
        }

        public Object read(Kryo kryo, Input input, Class clazz) {
            return Collections.EMPTY_SET;
        }
    }

    public static class CollectionsEmptyMapSerializer
    extends Serializer {
        public CollectionsEmptyMapSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, Object object) {
        }

        public Object read(Kryo kryo, Input input, Class clazz) {
            return Collections.EMPTY_MAP;
        }
    }

    public static class CollectionsEmptyListSerializer
    extends Serializer {
        public CollectionsEmptyListSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, Object object) {
        }

        public Object read(Kryo kryo, Input input, Class clazz) {
            return Collections.EMPTY_LIST;
        }
    }

    public static class KryoSerializableSerializer
    extends Serializer<KryoSerializable> {
        @Override
        public void write(Kryo kryo, Output output, KryoSerializable kryoSerializable) {
            kryoSerializable.write(kryo, output);
        }

        @Override
        public KryoSerializable read(Kryo kryo, Input input, Class<KryoSerializable> clazz) {
            KryoSerializable kryoSerializable = kryo.newInstance(clazz);
            kryo.reference(kryoSerializable);
            kryoSerializable.read(kryo, input);
            return kryoSerializable;
        }
    }

    public static class StringBuilderSerializer
    extends Serializer<StringBuilder> {
        public StringBuilderSerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, StringBuilder stringBuilder) {
            output.writeString(stringBuilder);
        }

        @Override
        public StringBuilder read(Kryo kryo, Input input, Class<StringBuilder> clazz) {
            return input.readStringBuilder();
        }

        @Override
        public StringBuilder copy(Kryo kryo, StringBuilder stringBuilder) {
            return new StringBuilder(stringBuilder);
        }
    }

    public static class StringBufferSerializer
    extends Serializer<StringBuffer> {
        public StringBufferSerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, StringBuffer stringBuffer) {
            output.writeString(stringBuffer);
        }

        @Override
        public StringBuffer read(Kryo kryo, Input input, Class<StringBuffer> clazz) {
            String string = input.readString();
            if (string == null) {
                return null;
            }
            return new StringBuffer(string);
        }

        @Override
        public StringBuffer copy(Kryo kryo, StringBuffer stringBuffer) {
            return new StringBuffer(stringBuffer);
        }
    }

    public static class CurrencySerializer
    extends Serializer<Currency> {
        public CurrencySerializer() {
            this.setImmutable(true);
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Currency currency) {
            output.writeString(currency == null ? null : currency.getCurrencyCode());
        }

        @Override
        public Currency read(Kryo kryo, Input input, Class<Currency> clazz) {
            String string = input.readString();
            if (string == null) {
                return null;
            }
            return Currency.getInstance(string);
        }
    }

    public static class EnumSetSerializer
    extends Serializer<EnumSet> {
        @Override
        public void write(Kryo kryo, Output output, EnumSet enumSet) {
            Serializer serializer;
            if (enumSet.isEmpty()) {
                EnumSet enumSet2 = EnumSet.complementOf(enumSet);
                if (enumSet2.isEmpty()) {
                    throw new KryoException("An EnumSet must have a defined Enum to be serialized.");
                }
                serializer = kryo.writeClass(output, enumSet2.iterator().next().getClass()).getSerializer();
            } else {
                serializer = kryo.writeClass(output, enumSet.iterator().next().getClass()).getSerializer();
            }
            output.writeInt(enumSet.size(), true);
            for (Object e2 : enumSet) {
                serializer.write(kryo, output, e2);
            }
        }

        @Override
        public EnumSet read(Kryo kryo, Input input, Class<EnumSet> clazz) {
            Registration registration = kryo.readClass(input);
            EnumSet enumSet = EnumSet.noneOf(registration.getType());
            Serializer serializer = registration.getSerializer();
            int n2 = input.readInt(true);
            for (int i2 = 0; i2 < n2; ++i2) {
                enumSet.add(serializer.read(kryo, input, null));
            }
            return enumSet;
        }

        @Override
        public EnumSet copy(Kryo kryo, EnumSet enumSet) {
            return EnumSet.copyOf(enumSet);
        }
    }

    public static class EnumSerializer
    extends Serializer<Enum> {
        private Object[] enumConstants;

        public EnumSerializer(Class<? extends Enum> clazz) {
            this.setImmutable(true);
            this.setAcceptsNull(true);
            this.enumConstants = clazz.getEnumConstants();
            if (this.enumConstants == null && !Enum.class.equals(clazz)) {
                throw new IllegalArgumentException("The type must be an enum: " + clazz);
            }
        }

        @Override
        public void write(Kryo kryo, Output output, Enum enum_) {
            if (enum_ == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(enum_.ordinal() + 1, true);
        }

        @Override
        public Enum read(Kryo kryo, Input input, Class<Enum> clazz) {
            int n2 = input.readVarInt(true);
            if (n2 == 0) {
                return null;
            }
            if (--n2 < 0 || n2 > this.enumConstants.length - 1) {
                throw new KryoException("Invalid ordinal for enum \"" + clazz.getName() + "\": " + n2);
            }
            Object object = this.enumConstants[n2];
            return (Enum)object;
        }
    }

    public static class DateSerializer
    extends Serializer<java.util.Date> {
        private java.util.Date create(Kryo kryo, Class<? extends java.util.Date> clazz, long l2) throws KryoException {
            if (clazz == java.util.Date.class || clazz == null) {
                return new java.util.Date(l2);
            }
            if (clazz == Timestamp.class) {
                return new Timestamp(l2);
            }
            if (clazz == Date.class) {
                return new Date(l2);
            }
            if (clazz == Time.class) {
                return new Time(l2);
            }
            try {
                Constructor<? extends java.util.Date> constructor = clazz.getConstructor(Long.TYPE);
                if (!constructor.isAccessible()) {
                    try {
                        constructor.setAccessible(true);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
                return constructor.newInstance(l2);
            }
            catch (Exception exception) {
                java.util.Date date = kryo.newInstance(clazz);
                date.setTime(l2);
                return date;
            }
        }

        @Override
        public void write(Kryo kryo, Output output, java.util.Date date) {
            output.writeLong(date.getTime(), true);
        }

        @Override
        public java.util.Date read(Kryo kryo, Input input, Class<java.util.Date> clazz) {
            return this.create(kryo, clazz, input.readLong(true));
        }

        @Override
        public java.util.Date copy(Kryo kryo, java.util.Date date) {
            return this.create(kryo, date.getClass(), date.getTime());
        }
    }

    public static class ClassSerializer
    extends Serializer<Class> {
        public ClassSerializer() {
            this.setImmutable(true);
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Class clazz) {
            kryo.writeClass(output, clazz);
            output.writeByte(clazz != null && clazz.isPrimitive() ? 1 : 0);
        }

        @Override
        public Class read(Kryo kryo, Input input, Class<Class> clazz) {
            Class clazz2;
            Registration registration = kryo.readClass(input);
            int n2 = input.read();
            Class clazz3 = clazz2 = registration != null ? registration.getType() : null;
            if (clazz2 == null || !clazz2.isPrimitive()) {
                return clazz2;
            }
            return n2 == 1 ? clazz2 : Util.getWrapperClass(clazz2);
        }
    }

    public static class BigDecimalSerializer
    extends Serializer<BigDecimal> {
        private final BigIntegerSerializer bigIntegerSerializer = new BigIntegerSerializer();

        public BigDecimalSerializer() {
            this.setAcceptsNull(true);
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, BigDecimal bigDecimal) {
            if (bigDecimal == null) {
                output.writeVarInt(0, true);
                return;
            }
            BigDecimal bigDecimal2 = bigDecimal;
            if (bigDecimal2 == BigDecimal.ZERO) {
                this.bigIntegerSerializer.write(kryo, output, BigInteger.ZERO);
                output.writeInt(0, false);
                return;
            }
            this.bigIntegerSerializer.write(kryo, output, bigDecimal2.unscaledValue());
            output.writeInt(bigDecimal2.scale(), false);
        }

        @Override
        public BigDecimal read(Kryo kryo, Input input, Class<BigDecimal> clazz) {
            Object object = this.bigIntegerSerializer.read(kryo, input, (Class)BigInteger.class);
            if (object == null) {
                return null;
            }
            int n2 = input.readInt(false);
            if (clazz != BigDecimal.class && clazz != null) {
                try {
                    Constructor<BigDecimal> constructor = clazz.getConstructor(BigInteger.class, Integer.TYPE);
                    if (!constructor.isAccessible()) {
                        try {
                            constructor.setAccessible(true);
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                    return constructor.newInstance(object, n2);
                }
                catch (Exception exception) {
                    throw new KryoException(exception);
                }
            }
            if (object == BigInteger.ZERO && n2 == 0) {
                return BigDecimal.ZERO;
            }
            return new BigDecimal((BigInteger)object, n2);
        }
    }

    public static class BigIntegerSerializer
    extends Serializer<BigInteger> {
        public BigIntegerSerializer() {
            this.setImmutable(true);
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, BigInteger bigInteger) {
            if (bigInteger == null) {
                output.writeVarInt(0, true);
                return;
            }
            BigInteger bigInteger2 = bigInteger;
            if (bigInteger2 == BigInteger.ZERO) {
                output.writeVarInt(2, true);
                output.writeByte(0);
                return;
            }
            byte[] byArray = bigInteger2.toByteArray();
            output.writeVarInt(byArray.length + 1, true);
            output.writeBytes(byArray);
        }

        @Override
        public BigInteger read(Kryo kryo, Input input, Class<BigInteger> clazz) {
            int n2 = input.readVarInt(true);
            if (n2 == 0) {
                return null;
            }
            byte[] byArray = input.readBytes(n2 - 1);
            if (clazz != BigInteger.class && clazz != null) {
                try {
                    Constructor<BigInteger> constructor = clazz.getConstructor(byte[].class);
                    if (!constructor.isAccessible()) {
                        try {
                            constructor.setAccessible(true);
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                    return constructor.newInstance(new Object[]{byArray});
                }
                catch (Exception exception) {
                    throw new KryoException(exception);
                }
            }
            if (n2 == 2) {
                switch (byArray[0]) {
                    case 0: {
                        return BigInteger.ZERO;
                    }
                    case 1: {
                        return BigInteger.ONE;
                    }
                    case 10: {
                        return BigInteger.TEN;
                    }
                }
            }
            return new BigInteger(byArray);
        }
    }

    public static class StringSerializer
    extends Serializer<String> {
        public StringSerializer() {
            this.setImmutable(true);
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, String string) {
            output.writeString(string);
        }

        @Override
        public String read(Kryo kryo, Input input, Class<String> clazz) {
            return input.readString();
        }
    }

    public static class DoubleSerializer
    extends Serializer<Double> {
        public DoubleSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Double d2) {
            output.writeDouble(d2);
        }

        @Override
        public Double read(Kryo kryo, Input input, Class<Double> clazz) {
            return input.readDouble();
        }
    }

    public static class FloatSerializer
    extends Serializer<Float> {
        public FloatSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Float f2) {
            output.writeFloat(f2.floatValue());
        }

        @Override
        public Float read(Kryo kryo, Input input, Class<Float> clazz) {
            return Float.valueOf(input.readFloat());
        }
    }

    public static class LongSerializer
    extends Serializer<Long> {
        public LongSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Long l2) {
            output.writeLong(l2, false);
        }

        @Override
        public Long read(Kryo kryo, Input input, Class<Long> clazz) {
            return input.readLong(false);
        }
    }

    public static class IntSerializer
    extends Serializer<Integer> {
        public IntSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Integer n2) {
            output.writeInt(n2, false);
        }

        @Override
        public Integer read(Kryo kryo, Input input, Class<Integer> clazz) {
            return input.readInt(false);
        }
    }

    public static class ShortSerializer
    extends Serializer<Short> {
        public ShortSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Short s2) {
            output.writeShort(s2.shortValue());
        }

        @Override
        public Short read(Kryo kryo, Input input, Class<Short> clazz) {
            return input.readShort();
        }
    }

    public static class CharSerializer
    extends Serializer<Character> {
        public CharSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Character c2) {
            output.writeChar(c2.charValue());
        }

        @Override
        public Character read(Kryo kryo, Input input, Class<Character> clazz) {
            return Character.valueOf(input.readChar());
        }
    }

    public static class ByteSerializer
    extends Serializer<Byte> {
        public ByteSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Byte by2) {
            output.writeByte(by2);
        }

        @Override
        public Byte read(Kryo kryo, Input input, Class<Byte> clazz) {
            return input.readByte();
        }
    }

    public static class BooleanSerializer
    extends Serializer<Boolean> {
        public BooleanSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Boolean bl2) {
            output.writeBoolean(bl2);
        }

        @Override
        public Boolean read(Kryo kryo, Input input, Class<Boolean> clazz) {
            return input.readBoolean();
        }
    }

    public static class VoidSerializer
    extends Serializer {
        public VoidSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, Object object) {
        }

        public Object read(Kryo kryo, Input input, Class clazz) {
            return null;
        }
    }
}

