/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.io;

import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.KryoException;
import java.io.IOException;
import java.io.InputStream;

public class Input
extends InputStream {
    protected byte[] buffer;
    protected int position;
    protected int capacity;
    protected int limit;
    protected long total;
    protected char[] chars = new char[32];
    protected InputStream inputStream;

    public Input() {
    }

    public Input(int n2) {
        this.capacity = n2;
        this.buffer = new byte[n2];
    }

    public Input(byte[] byArray) {
        this.setBuffer(byArray, 0, byArray.length);
    }

    public Input(InputStream inputStream) {
        this(4096);
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream cannot be null.");
        }
        this.inputStream = inputStream;
    }

    public Input(InputStream inputStream, int n2) {
        this(n2);
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream cannot be null.");
        }
        this.inputStream = inputStream;
    }

    public void setBuffer(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.buffer = byArray;
        this.position = n2;
        this.limit = n2 + n3;
        this.capacity = byArray.length;
        this.total = 0L;
        this.inputStream = null;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public int position() {
        return this.position;
    }

    public void skip(int n2) throws KryoException {
        int n3 = Math.min(this.limit - this.position, n2);
        while (true) {
            this.position += n3;
            if ((n2 -= n3) == 0) break;
            n3 = Math.min(n2, this.capacity);
            this.require(n3);
        }
    }

    protected int fill(byte[] byArray, int n2, int n3) throws KryoException {
        if (this.inputStream == null) {
            return -1;
        }
        try {
            return this.inputStream.read(byArray, n2, n3);
        }
        catch (IOException iOException) {
            throw new KryoException(iOException);
        }
    }

    protected int require(int n2) throws KryoException {
        int n3;
        int n4 = this.limit - this.position;
        if (n4 >= n2) {
            return n4;
        }
        if (n2 > this.capacity) {
            throw new KryoException("Buffer too small: capacity: " + this.capacity + ", required: " + n2);
        }
        if (n4 > 0) {
            n3 = this.fill(this.buffer, this.limit, this.capacity - this.limit);
            if (n3 == -1) {
                throw new KryoException("Buffer underflow.");
            }
            if ((n4 += n3) >= n2) {
                this.limit += n3;
                return n4;
            }
        }
        System.arraycopy(this.buffer, this.position, this.buffer, 0, n4);
        this.total += (long)this.position;
        this.position = 0;
        do {
            if ((n3 = this.fill(this.buffer, n4, this.capacity - n4)) != -1) continue;
            if (n4 >= n2) break;
            throw new KryoException("Buffer underflow.");
        } while ((n4 += n3) < n2);
        this.limit = n4;
        return n4;
    }

    private int optional(int n2) throws KryoException {
        int n3 = this.limit - this.position;
        if (n3 >= n2) {
            return n2;
        }
        n2 = Math.min(n2, this.capacity);
        int n4 = this.fill(this.buffer, this.limit, this.capacity - this.limit);
        if (n4 == -1) {
            return n3 == 0 ? -1 : Math.min(n3, n2);
        }
        if ((n3 += n4) >= n2) {
            this.limit += n4;
            return n2;
        }
        System.arraycopy(this.buffer, this.position, this.buffer, 0, n3);
        this.total += (long)this.position;
        this.position = 0;
        while ((n4 = this.fill(this.buffer, n3, this.capacity - n3)) != -1 && (n3 += n4) < n2) {
        }
        this.limit = n3;
        return n3 == 0 ? -1 : Math.min(n3, n2);
    }

    public boolean eof() {
        return this.optional(1) <= 0;
    }

    @Override
    public int available() throws IOException {
        return this.limit - this.position + (null != this.inputStream ? this.inputStream.available() : 0);
    }

    @Override
    public int read() throws KryoException {
        if (this.optional(1) <= 0) {
            return -1;
        }
        return this.buffer[this.position++] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws KryoException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws KryoException {
        if (byArray == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int n4 = n3;
        int n5 = Math.min(this.limit - this.position, n3);
        do {
            System.arraycopy(this.buffer, this.position, byArray, n2, n5);
            this.position += n5;
            if ((n3 -= n5) == 0) break;
            n2 += n5;
            n5 = this.optional(n3);
            if (n5 != -1) continue;
            if (n4 == n3) {
                return -1;
            }
            break;
        } while (this.position != this.limit);
        return n4 - n3;
    }

    @Override
    public long skip(long l2) throws KryoException {
        int n2;
        for (long i2 = l2; i2 > 0L; i2 -= (long)n2) {
            n2 = (int)Math.min(0x7FFFFFF7L, i2);
            this.skip(n2);
        }
        return l2;
    }

    @Override
    public void close() throws KryoException {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public byte readByte() throws KryoException {
        this.require(1);
        return this.buffer[this.position++];
    }

    public byte[] readBytes(int n2) throws KryoException {
        byte[] byArray = new byte[n2];
        this.readBytes(byArray, 0, n2);
        return byArray;
    }

    public void readBytes(byte[] byArray, int n2, int n3) throws KryoException {
        if (byArray == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int n4 = Math.min(this.limit - this.position, n3);
        while (true) {
            System.arraycopy(this.buffer, this.position, byArray, n2, n4);
            this.position += n4;
            if ((n3 -= n4) == 0) break;
            n2 += n4;
            n4 = Math.min(n3, this.capacity);
            this.require(n4);
        }
    }

    public int readInt() throws KryoException {
        this.require(4);
        byte[] byArray = this.buffer;
        int n2 = this.position;
        this.position = n2 + 4;
        return (byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    public int readInt(boolean bl2) throws KryoException {
        return this.readVarInt(bl2);
    }

    public int readVarInt(boolean bl2) throws KryoException {
        if (this.require(1) < 5) {
            return this.readInt_slow(bl2);
        }
        byte by2 = this.buffer[this.position++];
        int n2 = by2 & 0x7F;
        if ((by2 & 0x80) != 0) {
            byte[] byArray = this.buffer;
            by2 = byArray[this.position++];
            n2 |= (by2 & 0x7F) << 7;
            if ((by2 & 0x80) != 0) {
                by2 = byArray[this.position++];
                n2 |= (by2 & 0x7F) << 14;
                if ((by2 & 0x80) != 0) {
                    by2 = byArray[this.position++];
                    n2 |= (by2 & 0x7F) << 21;
                    if ((by2 & 0x80) != 0) {
                        by2 = byArray[this.position++];
                        n2 |= (by2 & 0x7F) << 28;
                    }
                }
            }
        }
        return bl2 ? n2 : n2 >>> 1 ^ -(n2 & 1);
    }

    private int readInt_slow(boolean bl2) {
        byte by2 = this.buffer[this.position++];
        int n2 = by2 & 0x7F;
        if ((by2 & 0x80) != 0) {
            this.require(1);
            byte[] byArray = this.buffer;
            by2 = byArray[this.position++];
            n2 |= (by2 & 0x7F) << 7;
            if ((by2 & 0x80) != 0) {
                this.require(1);
                by2 = byArray[this.position++];
                n2 |= (by2 & 0x7F) << 14;
                if ((by2 & 0x80) != 0) {
                    this.require(1);
                    by2 = byArray[this.position++];
                    n2 |= (by2 & 0x7F) << 21;
                    if ((by2 & 0x80) != 0) {
                        this.require(1);
                        by2 = byArray[this.position++];
                        n2 |= (by2 & 0x7F) << 28;
                    }
                }
            }
        }
        return bl2 ? n2 : n2 >>> 1 ^ -(n2 & 1);
    }

    public String readString() {
        byte by2;
        int n2 = this.require(1);
        if (((by2 = this.buffer[this.position++]) & 0x80) == 0) {
            return this.readAscii();
        }
        int n3 = n2 >= 5 ? this.readUtf8Length(by2) : this.readUtf8Length_slow(by2);
        switch (n3) {
            case 0: {
                return null;
            }
            case 1: {
                return "";
            }
        }
        if (this.chars.length < --n3) {
            this.chars = new char[n3];
        }
        this.readUtf8(n3);
        return new String(this.chars, 0, n3);
    }

    private int readUtf8Length(int n2) {
        int n3 = n2 & 0x3F;
        if ((n2 & 0x40) != 0) {
            byte[] byArray = this.buffer;
            n2 = byArray[this.position++];
            n3 |= (n2 & 0x7F) << 6;
            if ((n2 & 0x80) != 0) {
                n2 = byArray[this.position++];
                n3 |= (n2 & 0x7F) << 13;
                if ((n2 & 0x80) != 0) {
                    n2 = byArray[this.position++];
                    n3 |= (n2 & 0x7F) << 20;
                    if ((n2 & 0x80) != 0) {
                        n2 = byArray[this.position++];
                        n3 |= (n2 & 0x7F) << 27;
                    }
                }
            }
        }
        return n3;
    }

    private int readUtf8Length_slow(int n2) {
        int n3 = n2 & 0x3F;
        if ((n2 & 0x40) != 0) {
            this.require(1);
            byte[] byArray = this.buffer;
            n2 = byArray[this.position++];
            n3 |= (n2 & 0x7F) << 6;
            if ((n2 & 0x80) != 0) {
                this.require(1);
                n2 = byArray[this.position++];
                n3 |= (n2 & 0x7F) << 13;
                if ((n2 & 0x80) != 0) {
                    this.require(1);
                    n2 = byArray[this.position++];
                    n3 |= (n2 & 0x7F) << 20;
                    if ((n2 & 0x80) != 0) {
                        this.require(1);
                        n2 = byArray[this.position++];
                        n3 |= (n2 & 0x7F) << 27;
                    }
                }
            }
        }
        return n3;
    }

    private void readUtf8(int n2) {
        byte[] byArray = this.buffer;
        char[] cArray = this.chars;
        int n3 = 0;
        int n4 = Math.min(this.require(1), n2);
        int n5 = this.position;
        while (n3 < n4) {
            byte by2;
            if ((by2 = byArray[n5++]) < 0) {
                --n5;
                break;
            }
            cArray[n3++] = (char)by2;
        }
        this.position = n5;
        if (n3 < n2) {
            this.readUtf8_slow(n2, n3);
        }
    }

    private void readUtf8_slow(int n2, int n3) {
        char[] cArray = this.chars;
        byte[] byArray = this.buffer;
        while (n3 < n2) {
            if (this.position == this.limit) {
                this.require(1);
            }
            int n4 = byArray[this.position++] & 0xFF;
            switch (n4 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n3] = (char)n4;
                    break;
                }
                case 12: 
                case 13: {
                    if (this.position == this.limit) {
                        this.require(1);
                    }
                    cArray[n3] = (char)((n4 & 0x1F) << 6 | byArray[this.position++] & 0x3F);
                    break;
                }
                case 14: {
                    this.require(2);
                    cArray[n3] = (char)((n4 & 0xF) << 12 | (byArray[this.position++] & 0x3F) << 6 | byArray[this.position++] & 0x3F);
                }
            }
            ++n3;
        }
    }

    private String readAscii() {
        byte by2;
        byte[] byArray = this.buffer;
        int n2 = this.position;
        int n3 = n2 - 1;
        int n4 = this.limit;
        do {
            if (n2 != n4) continue;
            return this.readAscii_slow();
        } while (((by2 = byArray[n2++]) & 0x80) == 0);
        int n5 = n2 - 1;
        byArray[n5] = (byte)(byArray[n5] & 0x7F);
        String string = new String(byArray, 0, n3, n2 - n3);
        int n6 = n2 - 1;
        byArray[n6] = (byte)(byArray[n6] | 0x80);
        this.position = n2;
        return string;
    }

    private String readAscii_slow() {
        --this.position;
        int n2 = this.limit - this.position;
        if (n2 > this.chars.length) {
            this.chars = new char[n2 * 2];
        }
        char[] cArray = this.chars;
        byte[] byArray = this.buffer;
        int n3 = this.position;
        int n4 = 0;
        int n5 = this.limit;
        while (n3 < n5) {
            cArray[n4] = (char)byArray[n3];
            ++n3;
            ++n4;
        }
        this.position = this.limit;
        while (true) {
            this.require(1);
            n3 = byArray[this.position++];
            if (n2 == cArray.length) {
                char[] cArray2 = new char[n2 * 2];
                System.arraycopy(cArray, 0, cArray2, 0, n2);
                cArray = cArray2;
                this.chars = cArray2;
            }
            if ((n3 & 0x80) == 128) break;
            cArray[n2++] = (char)n3;
        }
        cArray[n2++] = (char)(n3 & 0x7F);
        return new String(cArray, 0, n2);
    }

    public StringBuilder readStringBuilder() {
        byte by2;
        int n2 = this.require(1);
        if (((by2 = this.buffer[this.position++]) & 0x80) == 0) {
            return new StringBuilder(this.readAscii());
        }
        int n3 = n2 >= 5 ? this.readUtf8Length(by2) : this.readUtf8Length_slow(by2);
        switch (n3) {
            case 0: {
                return null;
            }
            case 1: {
                return new StringBuilder("");
            }
        }
        if (this.chars.length < --n3) {
            this.chars = new char[n3];
        }
        this.readUtf8(n3);
        StringBuilder stringBuilder = new StringBuilder(n3);
        stringBuilder.append(this.chars, 0, n3);
        return stringBuilder;
    }

    public float readFloat() throws KryoException {
        return Float.intBitsToFloat(this.readInt());
    }

    public short readShort() throws KryoException {
        this.require(2);
        return (short)((this.buffer[this.position++] & 0xFF) << 8 | this.buffer[this.position++] & 0xFF);
    }

    public long readLong() throws KryoException {
        this.require(8);
        byte[] byArray = this.buffer;
        return (long)byArray[this.position++] << 56 | (long)(byArray[this.position++] & 0xFF) << 48 | (long)(byArray[this.position++] & 0xFF) << 40 | (long)(byArray[this.position++] & 0xFF) << 32 | (long)(byArray[this.position++] & 0xFF) << 24 | (long)((byArray[this.position++] & 0xFF) << 16) | (long)((byArray[this.position++] & 0xFF) << 8) | (long)(byArray[this.position++] & 0xFF);
    }

    public long readLong(boolean bl2) throws KryoException {
        return this.readVarLong(bl2);
    }

    public long readVarLong(boolean bl2) throws KryoException {
        if (this.require(1) < 9) {
            return this.readLong_slow(bl2);
        }
        byte by2 = this.buffer[this.position++];
        long l2 = by2 & 0x7F;
        if ((by2 & 0x80) != 0) {
            byte[] byArray = this.buffer;
            by2 = byArray[this.position++];
            l2 |= (long)((by2 & 0x7F) << 7);
            if ((by2 & 0x80) != 0) {
                by2 = byArray[this.position++];
                l2 |= (long)((by2 & 0x7F) << 14);
                if ((by2 & 0x80) != 0) {
                    by2 = byArray[this.position++];
                    l2 |= (long)((by2 & 0x7F) << 21);
                    if ((by2 & 0x80) != 0) {
                        by2 = byArray[this.position++];
                        l2 |= (long)(by2 & 0x7F) << 28;
                        if ((by2 & 0x80) != 0) {
                            by2 = byArray[this.position++];
                            l2 |= (long)(by2 & 0x7F) << 35;
                            if ((by2 & 0x80) != 0) {
                                by2 = byArray[this.position++];
                                l2 |= (long)(by2 & 0x7F) << 42;
                                if ((by2 & 0x80) != 0) {
                                    by2 = byArray[this.position++];
                                    l2 |= (long)(by2 & 0x7F) << 49;
                                    if ((by2 & 0x80) != 0) {
                                        by2 = byArray[this.position++];
                                        l2 |= (long)by2 << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!bl2) {
            l2 = l2 >>> 1 ^ -(l2 & 1L);
        }
        return l2;
    }

    private long readLong_slow(boolean bl2) {
        byte by2 = this.buffer[this.position++];
        long l2 = by2 & 0x7F;
        if ((by2 & 0x80) != 0) {
            this.require(1);
            byte[] byArray = this.buffer;
            by2 = byArray[this.position++];
            l2 |= (long)((by2 & 0x7F) << 7);
            if ((by2 & 0x80) != 0) {
                this.require(1);
                by2 = byArray[this.position++];
                l2 |= (long)((by2 & 0x7F) << 14);
                if ((by2 & 0x80) != 0) {
                    this.require(1);
                    by2 = byArray[this.position++];
                    l2 |= (long)((by2 & 0x7F) << 21);
                    if ((by2 & 0x80) != 0) {
                        this.require(1);
                        by2 = byArray[this.position++];
                        l2 |= (long)(by2 & 0x7F) << 28;
                        if ((by2 & 0x80) != 0) {
                            this.require(1);
                            by2 = byArray[this.position++];
                            l2 |= (long)(by2 & 0x7F) << 35;
                            if ((by2 & 0x80) != 0) {
                                this.require(1);
                                by2 = byArray[this.position++];
                                l2 |= (long)(by2 & 0x7F) << 42;
                                if ((by2 & 0x80) != 0) {
                                    this.require(1);
                                    by2 = byArray[this.position++];
                                    l2 |= (long)(by2 & 0x7F) << 49;
                                    if ((by2 & 0x80) != 0) {
                                        this.require(1);
                                        by2 = byArray[this.position++];
                                        l2 |= (long)by2 << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!bl2) {
            l2 = l2 >>> 1 ^ -(l2 & 1L);
        }
        return l2;
    }

    public boolean readBoolean() throws KryoException {
        this.require(1);
        return this.buffer[this.position++] == 1;
    }

    public char readChar() throws KryoException {
        this.require(2);
        return (char)((this.buffer[this.position++] & 0xFF) << 8 | this.buffer[this.position++] & 0xFF);
    }

    public double readDouble() throws KryoException {
        return Double.longBitsToDouble(this.readLong());
    }

    public int[] readInts(int n2, boolean bl2) throws KryoException {
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = this.readInt(bl2);
        }
        return nArray;
    }

    public long[] readLongs(int n2, boolean bl2) throws KryoException {
        long[] lArray = new long[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            lArray[i2] = this.readLong(bl2);
        }
        return lArray;
    }

    public float[] readFloats(int n2) throws KryoException {
        float[] fArray = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray[i2] = this.readFloat();
        }
        return fArray;
    }

    public short[] readShorts(int n2) throws KryoException {
        short[] sArray = new short[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            sArray[i2] = this.readShort();
        }
        return sArray;
    }

    public char[] readChars(int n2) throws KryoException {
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = this.readChar();
        }
        return cArray;
    }

    public double[] readDoubles(int n2) throws KryoException {
        double[] dArray = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = this.readDouble();
        }
        return dArray;
    }
}

