/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.gradleplugin.testselection.internal;

import com.gradle.enterprise.testacceleration.client.d.c;
import com.gradle.enterprise.testacceleration.client.selection.b;
import com.gradle.obfuscation.Keep;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

@Keep
@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
public abstract class FingerprintMapperTask
extends DefaultTask {
    public static final String TASK_NAME = "remapPtsFingerprints";

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getToRemapFile();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getHashMapFile();

    @OutputFile
    public abstract Property<File> getOutputFile();

    public FingerprintMapperTask() {
        this.getOutputFile().set(this.getToRemapFile().map(regularFile -> new File(regularFile.getAsFile().getParentFile(), regularFile.getAsFile().getName() + ".mapped.json")));
    }

    @TaskAction
    void remapFile() throws IOException {
        File file = (File)this.getOutputFile().get();
        this.getLogger().lifecycle("Remapped file will be written to {}", file);
        try (OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            FingerprintMapperTask.remapFileBasedInputs(this.getToRemapFile().getAsFile().get().toPath(), this.getHashMapFile().getAsFile().get().toPath(), outputStream);
        }
    }

    private static void remapFileBasedInputs(Path path, Path path2, OutputStream outputStream) throws IOException {
        com.gradle.enterprise.testacceleration.client.selection.c c2 = c.a().readValue(Files.readAllBytes(path2), com.gradle.enterprise.testacceleration.client.selection.c.class);
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            JsonNode jsonNode = c.a().readTree(inputStream);
            b.a(jsonNode, c2);
            c.a().writerWithDefaultPrettyPrinter().writeValue(outputStream, (Object)jsonNode);
        }
    }

    @Option(option="input-file", description="The JSON file containing input file and class name hash codes to remap.")
    public void setToRemapFileViaOption(String string) {
        this.getToRemapFile().set(new File(string));
    }

    @Option(option="hash-file", description="File containing a map of hash codes to input file paths and class names.")
    public void setHashMapFileViaOption(String string) {
        this.getHashMapFile().set(new File(string));
    }
}

