/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.openrewrite.Checksum;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.HttpSenderExecutionContextView;
import org.openrewrite.Validated;
import org.openrewrite.gradle.util.DistributionInfos;
import org.openrewrite.gradle.util.GradleWrapperJar;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.ipc.http.HttpSender;
import org.openrewrite.remote.Remote;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public final class GradleWrapper {
    public static final Path WRAPPER_JAR_LOCATION = Paths.get("gradle/wrapper/gradle-wrapper.jar", new String[0]);
    public static final Path WRAPPER_PROPERTIES_LOCATION = Paths.get("gradle/wrapper/gradle-wrapper.properties", new String[0]);
    public static final Path WRAPPER_SCRIPT_LOCATION = Paths.get("gradlew", new String[0]);
    public static final Path WRAPPER_BATCH_LOCATION = Paths.get("gradlew.bat", new String[0]);
    private final String version;
    private final DistributionInfos distributionInfos;
    static final FileAttributes WRAPPER_JAR_FILE_ATTRIBUTES = new FileAttributes(null, null, null, true, true, false, 0L);

    public static Validated validate(ExecutionContext ctx, final String version, @Nullable String distribution, @Nullable Validated cachedValidation) {
        if (cachedValidation != null) {
            return cachedValidation;
        }
        final String distributionTypeName = distribution != null ? distribution : DistributionType.Bin.name().toLowerCase();
        final HttpSender httpSender = HttpSenderExecutionContextView.view((ExecutionContext)ctx).getHttpSender();
        return new Validated.Both(Validated.test((String)"distributionType", (String)"must be a valid distribution type", (Object)distributionTypeName, dt2 -> {
            try {
                DistributionType.valueOf(dt2);
                return true;
            }
            catch (Throwable e2) {
                return false;
            }
        }), Semver.validate((String)version, null)){
            GradleWrapper wrapper;

            public boolean isValid() {
                if (!super.isValid()) {
                    return false;
                }
                try {
                    this.buildWrapper();
                    return true;
                }
                catch (Throwable t2) {
                    return false;
                }
            }

            public GradleWrapper getValue() {
                return this.buildWrapper();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private GradleWrapper buildWrapper() {
                if (this.wrapper != null) {
                    return this.wrapper;
                }
                DistributionType distributionType = Arrays.stream(DistributionType.values()).filter(dt2 -> dt2.name().equalsIgnoreCase(distributionTypeName)).findAny().orElseThrow(() -> new IllegalArgumentException("Unknown distribution type " + distributionTypeName));
                VersionComparator versionComparator = Objects.requireNonNull((VersionComparator)Semver.validate((String)version, null).getValue());
                String gradleVersionsUrl = "https://services.gradle.org/versions/all";
                try (HttpSender.Response resp = httpSender.send(httpSender.get(gradleVersionsUrl).build());){
                    if (!resp.isSuccessful()) throw new IOException("Could not get Gradle versions at: " + gradleVersionsUrl);
                    List allVersions = (List)new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(resp.getBody(), (TypeReference)new TypeReference<List<GradleVersion>>(){});
                    GradleVersion gradleVersion = allVersions.stream().filter(v2 -> versionComparator.isValid(null, ((GradleVersion)v2).version)).max((v1, v2) -> versionComparator.compare(null, ((GradleVersion)v1).version, ((GradleVersion)v2).version)).orElseThrow(() -> new IllegalStateException("Expected to find at least one Gradle wrapper version to select from."));
                    DistributionInfos infos = DistributionInfos.fetch(httpSender, distributionType, gradleVersion);
                    GradleWrapper gradleWrapper = this.wrapper = new GradleWrapper(gradleVersion.version, infos);
                    return gradleWrapper;
                }
                catch (IOException e2) {
                    throw new UncheckedIOException(e2);
                }
            }
        };
    }

    public String getDistributionUrl() {
        return this.distributionInfos.getDownloadUrl();
    }

    public String getPropertiesFormattedUrl() {
        return this.getDistributionUrl().replaceAll("(?<!\\\\)://", "\\\\://");
    }

    public Checksum getDistributionChecksum() {
        return this.distributionInfos.getChecksum();
    }

    public Remote asRemote() {
        return new GradleWrapperJar(URI.create(this.getDistributionUrl()), this.version, this.distributionInfos.getWrapperJarChecksum());
    }

    public GradleWrapper(String version, DistributionInfos distributionInfos) {
        this.version = version;
        this.distributionInfos = distributionInfos;
    }

    public String getVersion() {
        return this.version;
    }

    public DistributionInfos getDistributionInfos() {
        return this.distributionInfos;
    }

    public boolean equals(@Nullable Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof GradleWrapper)) {
            return false;
        }
        GradleWrapper other = (GradleWrapper)o2;
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        DistributionInfos this$distributionInfos = this.getDistributionInfos();
        DistributionInfos other$distributionInfos = other.getDistributionInfos();
        return !(this$distributionInfos == null ? other$distributionInfos != null : !((Object)this$distributionInfos).equals(other$distributionInfos));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        DistributionInfos $distributionInfos = this.getDistributionInfos();
        result = result * 59 + ($distributionInfos == null ? 43 : ((Object)$distributionInfos).hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "GradleWrapper(version=" + this.getVersion() + ", distributionInfos=" + this.getDistributionInfos() + ")";
    }

    public static enum DistributionType {
        Bin,
        All;

    }

    static final class GradleVersion {
        private final String version;
        private final String downloadUrl;
        private final String checksumUrl;
        private final String wrapperChecksumUrl;

        @JsonCreator
        public GradleVersion(@JsonProperty(value="version") String version, @JsonProperty(value="downloadUrl") String downloadUrl, @JsonProperty(value="checksumUrl") String checksumUrl, @JsonProperty(value="wrapperChecksumUrl") String wrapperChecksumUrl) {
            this.version = version;
            this.downloadUrl = downloadUrl;
            this.checksumUrl = checksumUrl;
            this.wrapperChecksumUrl = wrapperChecksumUrl;
        }

        public String getVersion() {
            return this.version;
        }

        public String getDownloadUrl() {
            return this.downloadUrl;
        }

        public String getChecksumUrl() {
            return this.checksumUrl;
        }

        public String getWrapperChecksumUrl() {
            return this.wrapperChecksumUrl;
        }

        public boolean equals(@Nullable Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof GradleVersion)) {
                return false;
            }
            GradleVersion other = (GradleVersion)o2;
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$downloadUrl = this.getDownloadUrl();
            String other$downloadUrl = other.getDownloadUrl();
            if (this$downloadUrl == null ? other$downloadUrl != null : !this$downloadUrl.equals(other$downloadUrl)) {
                return false;
            }
            String this$checksumUrl = this.getChecksumUrl();
            String other$checksumUrl = other.getChecksumUrl();
            if (this$checksumUrl == null ? other$checksumUrl != null : !this$checksumUrl.equals(other$checksumUrl)) {
                return false;
            }
            String this$wrapperChecksumUrl = this.getWrapperChecksumUrl();
            String other$wrapperChecksumUrl = other.getWrapperChecksumUrl();
            return !(this$wrapperChecksumUrl == null ? other$wrapperChecksumUrl != null : !this$wrapperChecksumUrl.equals(other$wrapperChecksumUrl));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $downloadUrl = this.getDownloadUrl();
            result = result * 59 + ($downloadUrl == null ? 43 : $downloadUrl.hashCode());
            String $checksumUrl = this.getChecksumUrl();
            result = result * 59 + ($checksumUrl == null ? 43 : $checksumUrl.hashCode());
            String $wrapperChecksumUrl = this.getWrapperChecksumUrl();
            result = result * 59 + ($wrapperChecksumUrl == null ? 43 : $wrapperChecksumUrl.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "GradleWrapper.GradleVersion(version=" + this.getVersion() + ", downloadUrl=" + this.getDownloadUrl() + ", checksumUrl=" + this.getChecksumUrl() + ", wrapperChecksumUrl=" + this.getWrapperChecksumUrl() + ")";
        }
    }
}

